/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.CommodityBo;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.AuditResultStatusEnum;
import com.tydic.commodity.base.enumType.CommodityStatusEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.atom.api.UccCommodityAtomService;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateCommodityStatusReqBo;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.estore.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.po.UccCommodityLogPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccJoinQuerySkusPo;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.utils.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchUpdateCommoStatusForMarketServiceImpl
implements BatchUpdateCommoStatusForMarketService {
    private static final Logger log = LoggerFactory.getLogger(BatchUpdateCommoStatusForMarketServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchUpdateCommoStatusForMarketServiceImpl.class);
    @Autowired
    private UccCommodityAtomService uccCommodityAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @Override
    public RspUccBo batchUpdateCommoStatusForMarket(BatchUpdateCommoStatusForMarketBO statusForMarketBO, CommodityStatusEnum commodityStatusEnum, SkuStatusEnum skuStatusEnum) {
        ValidatorUtil.validator((Object)statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Object batchId = null;
        ArrayList uccCommodityLogPOS = Lists.newArrayList();
        ArrayList batchUpdateSkuBOS = Lists.newArrayList();
        ArrayList batchUpdateCommodityBOs = Lists.newArrayList();
        BatchUpdateSkuStatusReqBO batchUpdateSkuStatusReqBO = new BatchUpdateSkuStatusReqBO();
        BatchUpdateCommodityStatusReqBo commodityStatusReqBo = new BatchUpdateCommodityStatusReqBo();
        long[] sequence = new long[statusForMarketBO.getBusinessId().length];
        sequence = this.uccBatchSequence.nextIds(statusForMarketBO.getBusinessId().length);
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(statusForMarketBO.getBusinessId()[i]);
            if (uccCommodityPo == null) continue;
            if (commodityStatusEnum != null) {
                UccCommodityLogPO uccCommodityLogPO = new UccCommodityLogPO();
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)uccCommodityLogPO);
                uccCommodityLogPO.setBatchId(Long.valueOf(sequence[i]));
                uccCommodityLogPO.setAduitResult(statusForMarketBO.getReason());
                uccCommodityLogPOS.add(uccCommodityLogPO);
                BatchUpdateCommodityBO batchUpdateCommodityBO = new BatchUpdateCommodityBO();
                batchUpdateCommodityBO.setCommodityId(uccCommodityPo.getCommodityId());
                batchUpdateCommodityBO.setStatus(commodityStatusEnum.getStatus());
                commodityStatusReqBo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                batchUpdateCommodityBOs.add(batchUpdateCommodityBO);
            }
            if (skuStatusEnum == null) continue;
            BatchUpdateSkuBO batchUpdateSkuBO = new BatchUpdateSkuBO();
            batchUpdateSkuBO.setCommodityId(statusForMarketBO.getBusinessId()[i]);
            batchUpdateSkuBO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
            batchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuBOS.add(batchUpdateSkuBO);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List skuPos = this.skuMapper.queryJoinSkuByCommodityId(uccJoinQuerySkusPo);
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            batchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
            this.processUpdateSkuAndLog(batchUpdateSkuStatusReqBO, UccSkuLogPo2, statusForMarketBO);
        }
        if (commodityStatusEnum != null) {
            commodityStatusReqBo.setBoList(batchUpdateCommodityBOs);
            this.processUpdateCommodityAndLog(commodityStatusReqBo, uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty((Collection)batchUpdateSkuBOS)) {
            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setCommodityIds(batchUpdateSkuBOS.stream().map(BatchUpdateSkuBO::getCommodityId).collect(Collectors.toList()));
            syncSceneCommodityToEsReqBO.setSupplierId(((BatchUpdateSkuBO)batchUpdateSkuBOS.get(0)).getSupplierShopId());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        LOGGER.info("\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    @Override
    public void updateCommoApprovalStatus(CommodityBo commodityBo, AuditResultStatusEnum auditResultStatusEnum) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(commodityBo.getCommodityId());
        uccCommodityPo.setApprovalStatus(commodityBo.getApprovalStatus());
        uccCommodityPo.setSupplierShopId(commodityBo.getSupplierShopId());
        this.uccCommodityMapper.updateCommodity(uccCommodityPo);
    }

    @Override
    public void batchUpdateCommoApprovalStatus(List<CommodityBo> commodityBos) {
        if (!CollectionUtils.isEmpty(commodityBos)) {
            Map<Integer, List<CommodityBo>> map = commodityBos.stream().filter(a -> a.getApprovalStatus() != null).collect(Collectors.groupingBy(CommodityBo::getApprovalStatus));
            Iterator<Map.Entry<Integer, List<CommodityBo>>> iterator = map.entrySet().iterator();
            try {
                while (iterator.hasNext()) {
                    Map.Entry<Integer, List<CommodityBo>> each = iterator.next();
                    Integer approvalStatus = each.getKey();
                    List<CommodityBo> bos = each.getValue();
                    if (approvalStatus == null || CollectionUtils.isEmpty(bos)) continue;
                    List commodityIds = bos.stream().map(CommodityBo::getCommodityId).collect(Collectors.toList());
                    UccCommodityPo uccCommodityPo = new UccCommodityPo();
                    uccCommodityPo.setApprovalStatus(approvalStatus);
                    this.uccCommodityMapper.batchUpdateById(commodityIds, uccCommodityPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
        }
    }

    private void processUpdateCommodityAndLog(BatchUpdateCommodityStatusReqBo reqBO, List<UccCommodityLogPO> commodityLogPOS) {
        try {
            if (CollectionUtils.isNotEmpty(commodityLogPOS)) {
                this.uccCommodityLogMapper.batchInsert(commodityLogPOS);
            }
            this.uccCommodityAtomService.batchUpdateCommodityByCommodityId(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void processUpdateSkuAndLog(BatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos, BatchUpdateCommoStatusForMarketBO statusForMarketBO) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
                List skuIds = uccSkuLogPos.stream().map(UccSkuLogPo::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuIds)) {
                    List uccSkuPoList = this.skuMapper.qeryBatchSkus(skuIds);
                    ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
                    for (UccSkuPo uccSkuPo : uccSkuPoList) {
                        UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                        logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                        logRecordAbilityBO.setCreateOperId("\u7ba1\u7406\u5458");
                        logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                        logRecordAbilityBO.setCreateTime(new Date());
                        if (statusForMarketBO.getOperationType() != null) {
                            logRecordAbilityBO.setOperationType(statusForMarketBO.getOperationType());
                            logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0b\u67b6-\u7269\u6599\u5206\u7c7b");
                        } else {
                            logRecordAbilityBO.setOperationType(Integer.valueOf(7));
                            logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0b\u67b6-\u9884\u8b66\u4e0b\u67b6");
                        }
                        recordAbilityBOS.add(logRecordAbilityBO);
                    }
                    try {
                        if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                            UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                            skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                            this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u8bb0\u5f55\u5355\u54c1\u64cd\u4f5c\u65e5\u5fd7\u62a5\u9519" + e.getMessage());
                    }
                    this.dealElcSku(uccSkuPoList);
                }
            }
            this.uccCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }

    private void dealElcSku(List<UccSkuPo> uccSkuPos) {
        try {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getApprovalStatus() == null) continue;
                switch (uccSkuPo.getApprovalStatus()) {
                    case 21: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2012", "\u7533\u8bf7\u4e0a\u67b6\u5f85\u5ba1\u6279");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        break;
                    }
                    case 31: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2008", "\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                        break;
                    }
                    case 41: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2002", "\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
                        break;
                    }
                    case 51: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2003", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5f85\u529e\u548c\u5ba1\u6279\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private void cancelWaitDone(Long skuId, Integer objType, String busiCode, String busiName) {
        try {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(objType);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a\uff01");
            }
            try {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setBusiCode(busiCode);
                todoUccWaitAbilityReqBO.setBusiName(busiName);
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setObjId(skuId);
                todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
                UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
                uccDealHandlerReqBO.setHandleName("productApplyHandler");
                this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            }
            catch (Exception e) {
                log.error("taskTodoWaitService error:{}", (Throwable)e);
            }
        }
        catch (Exception ex) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    private void cancelAudit(Long skuId, Integer objType) {
        try {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            uacNoTaskAuditCancelReqBO.setObjId(skuId.toString());
            uacNoTaskAuditCancelReqBO.setObjType(objType);
            uacNoTaskAuditCancelReqBO.setOperDept("sys-mgc");
            uacNoTaskAuditCancelReqBO.setOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelReason("\u6807\u54c1\u89e3\u7ed1\u53d6\u6d88");
            UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
            if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

