/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.config.DuplicateCommitLimit;
import com.tydic.commodity.dao.BrandApplyMainMapper;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.OtherAccessoryMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityReqBo;
import com.tydic.commodity.estore.ability.bo.CceUccCreateBrandApplyAbilityRspBo;
import com.tydic.commodity.estore.ability.bo.CceUccOtherAccessoryBO;
import com.tydic.commodity.estore.busi.api.CceUccCreateBrandApplyBusiService;
import com.tydic.commodity.estore.constants.MmcConstant;
import com.tydic.commodity.po.BrandApplyMainPO;
import com.tydic.commodity.po.BrandApplyPO;
import com.tydic.commodity.po.OtherAccessoryPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CceUccCreateBrandApplyBusiServiceImpl
implements CceUccCreateBrandApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(CceUccCreateBrandApplyBusiServiceImpl.class);
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private BrandApplyMainMapper brandApplyMainMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private OtherAccessoryMapper otherAccessoryMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;

    @Override
    public CceUccCreateBrandApplyAbilityRspBo createBrandApply(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        CceUccCreateBrandApplyAbilityRspBo rspBo = new CceUccCreateBrandApplyAbilityRspBo();
        String checkMsg = this.checkReq(reqBo);
        if (!StringUtils.isEmpty((Object)checkMsg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(checkMsg);
            return rspBo;
        }
        if (reqBo.getBrandApplyOperType().equals(1) || reqBo.getBrandApplyOperType().equals(2)) {
            BrandApplyPO brandApplyPo = new BrandApplyPO();
            brandApplyPo.setBrandId(reqBo.getBrandId());
            brandApplyPo.setCatalogId(reqBo.getCatalogId());
            brandApplyPo.setVendorId(reqBo.getVendorId());
            brandApplyPo.setApplyStatusList(Arrays.asList(1, 3, 4));
            List list = this.brandApplyMapper.getList(brandApplyPo);
            if (!ObjectUtils.isEmpty((Object)list)) {
                throw new ZTBusinessException("\u6d41\u7a0b\u4e2d\u5b58\u5728\u5173\u8054\u5173\u7cfb\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5904\u7406\uff01");
            }
        }
        UccRelCatalogBrandVendorPO vendorPO = (UccRelCatalogBrandVendorPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UccRelCatalogBrandVendorPO.class);
        Long relId = this.uccRelCatalogBrandVendorMapper.checkDiscount(vendorPO);
        log.info("^^^^^^^reqBo{}--^^^^^^^^^^^iiiiiiiii--{}^", (Object)JSON.toJSONString((Object)reqBo), (Object)relId);
        reqBo.setIsApply(Integer.valueOf(1));
        if (reqBo.getBrandApplyOperType() == 3 && reqBo.getConfirmResult() == 1 && ObjectUtils.isEmpty((Object)relId)) {
            String stepId = this.startAudit(reqBo, rspBo);
            reqBo.setExtField2(stepId);
            reqBo.setIsApply(Integer.valueOf(0));
        }
        if (reqBo.getBrandApplyOperType() == 6) {
            this.syncRel(reqBo.getIds(), reqBo);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List<Long> offIds = this.dealMainInfo(reqBo, relId);
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2 || reqBo.getBrandApplyOperType() == 3) {
            this.dealAccessory(reqBo);
        }
        rspBo.setOffIds(offIds);
        rspBo.setId(reqBo.getId());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public CceUccCreateBrandApplyAbilityRspBo updateBrandApply(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        CceUccCreateBrandApplyAbilityRspBo rspBo = new CceUccCreateBrandApplyAbilityRspBo();
        ArrayList<Long> offIds = new ArrayList<Long>();
        if (ObjectUtils.isEmpty((Object)reqBo.getIds())) {
            throw new ZTBusinessException("\u54c1\u724c\u7533\u8bf7id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            BrandApplyPO set = new BrandApplyPO();
            set.setApplyStatus(reqBo.getApplyStatus());
            set.setConfirmRemark(reqBo.getConfirmRemark());
            set.setUpdateTime(new Date());
            set.setConfirmUserCode(reqBo.getOccupation());
            set.setConfirmUserName(reqBo.getName());
            set.setConfirmTime(new Date());
            set.setConfirmResult(Integer.valueOf(0));
            set.setIsApply(Integer.valueOf(1));
            BrandApplyPO where = new BrandApplyPO();
            if (reqBo.getApplyStatus().equals(3)) {
                for (Long id : reqBo.getIds()) {
                    BrandApplyPO po = new BrandApplyPO();
                    po.setId(id);
                    BrandApplyPO modelBy = this.brandApplyMapper.getModelBy(po);
                    UccRelCatalogBrandVendorPO vendorPO = (UccRelCatalogBrandVendorPO)JSON.parseObject((String)JSON.toJSONString((Object)modelBy), UccRelCatalogBrandVendorPO.class);
                    Long relId = this.uccRelCatalogBrandVendorMapper.checkDiscount(vendorPO);
                    CceUccCreateBrandApplyAbilityReqBo brandApply = new CceUccCreateBrandApplyAbilityReqBo();
                    BeanUtils.copyProperties((Object)reqBo, (Object)brandApply);
                    brandApply.setId(id);
                    if (ObjectUtils.isEmpty((Object)relId)) {
                        brandApply.setIds(Arrays.asList(brandApply.getId()));
                        String stepId = this.startAudit(brandApply, rspBo);
                        set.setExtField2(stepId);
                        set.setApplyStatus(reqBo.getApplyStatus());
                        set.setIsApply(Integer.valueOf(0));
                    } else {
                        set.setExtField2(null);
                        set.setApplyStatus(Integer.valueOf(5));
                        set.setIsApply(Integer.valueOf(1));
                        UccRelCatalogBrandVendorPO relSet = new UccRelCatalogBrandVendorPO();
                        relSet.setDiscount(modelBy.getDiscount());
                        relSet.setApplyCode(modelBy.getApplyCode());
                        relSet.setBrandApplyId(modelBy.getId());
                        relSet.setStatus(modelBy.getApplyRelStatus());
                        if (modelBy.getApplyRelStatus() != null && modelBy.getApplyRelStatus() == 0) {
                            offIds.add(modelBy.getId());
                        }
                        UccRelCatalogBrandVendorPO relWhere = new UccRelCatalogBrandVendorPO();
                        relWhere.setRelId(relId);
                        this.uccRelCatalogBrandVendorMapper.updateBy(relSet, relWhere);
                    }
                    where.setId(id);
                    set.setConfirmResult(Integer.valueOf(1));
                    set = this.extractDataList(set, where);
                    this.brandApplyMapper.updateBy(set, where);
                }
            } else {
                where.setIds(reqBo.getIds());
                this.brandApplyMapper.updateBy(set, where);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rspBo.setOffIds(offIds);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> dealMainInfo(CceUccCreateBrandApplyAbilityReqBo reqBo, Long relId) {
        ArrayList<Long> offIds = new ArrayList<Long>();
        BrandApplyPO brandApplyPO = new BrandApplyPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)brandApplyPO);
        BrandApplyPO checkDupPo = new BrandApplyPO();
        checkDupPo.setApplyCode(reqBo.getApplyCode());
        List checkDupList = this.brandApplyMapper.getList(checkDupPo);
        if (reqBo.getBrandApplyOperType() == 1) {
            if (!CollectionUtils.isEmpty((Collection)checkDupList)) {
                throw new ZTBusinessException("\u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
            }
            brandApplyPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            reqBo.setId(brandApplyPO.getId());
            if ("0".equals(reqBo.getIsprofess())) {
                brandApplyPO.setSource(Integer.valueOf(1));
                brandApplyPO.setCreateUserCode(reqBo.getOccupation());
                brandApplyPO.setCreateUserName(reqBo.getName());
            } else {
                brandApplyPO.setSource(Integer.valueOf(0));
                if (reqBo.getSupId() != null) {
                    UccVendorPo uccVendorPo = this.uccVendorMapper.queryVendorByVendorId(reqBo.getSupId());
                    if (uccVendorPo != null) {
                        brandApplyPO.setCreateUserCode(uccVendorPo.getSupplierCode());
                        brandApplyPO.setCreateUserName(uccVendorPo.getVendorName());
                    }
                } else {
                    throw new ZTBusinessException("\u4f9b\u5e94\u5546\u4fe1\u606f\u9519\u8bef");
                }
            }
            brandApplyPO.setCreateUserId("" + reqBo.getUserId());
            brandApplyPO.setCreateCompanyId("" + reqBo.getOrgId());
            brandApplyPO.setCreateCompanyCode(reqBo.getOrgCodeIn());
            brandApplyPO.setCreateCompanyName(reqBo.getOrgName());
            brandApplyPO.setCreateTime(new Date());
        } else if (reqBo.getBrandApplyOperType() == 3) {
            brandApplyPO.setConfirmUserCode(reqBo.getOccupation());
            brandApplyPO.setConfirmUserName(reqBo.getName());
            brandApplyPO.setConfirmTime(new Date());
            if (StringUtils.isEmpty((Object)reqBo.getConfirmRemark())) {
                reqBo.setConfirmRemark(" ");
            }
        }
        brandApplyPO.setUpdateUserId("" + reqBo.getUserId());
        brandApplyPO.setUpdateUserCode(reqBo.getOccupation());
        brandApplyPO.setUpdateUserName(reqBo.getName());
        brandApplyPO.setUpdateTime(new Date());
        if (null != brandApplyPO.getDiscount() && brandApplyPO.getDiscount().scale() > 2) {
            brandApplyPO.setDiscount(brandApplyPO.getDiscount().setScale(2, 4));
        }
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2) {
            if (reqBo.getSaveOrSubmit() == 1) {
                brandApplyPO.setApplyStatus(Integer.valueOf(0));
            } else if (reqBo.getSaveOrSubmit() == 2) {
                brandApplyPO.setApplyStatus(Integer.valueOf(1));
            }
        } else if (reqBo.getBrandApplyOperType() == 3) {
            if (reqBo.getConfirmResult() == 1) {
                if (ObjectUtils.isEmpty((Object)relId)) {
                    brandApplyPO.setApplyStatus(Integer.valueOf(3));
                } else {
                    brandApplyPO.setApplyStatus(Integer.valueOf(5));
                    UccRelCatalogBrandVendorPO set = new UccRelCatalogBrandVendorPO();
                    BeanUtils.copyProperties((Object)reqBo, (Object)set);
                    set.setBrandApplyId(((BrandApplyPO)checkDupList.get(0)).getId());
                    UccRelCatalogBrandVendorPO where = new UccRelCatalogBrandVendorPO();
                    where.setRelId(relId);
                    if (reqBo.getApplyRelStatus() != null) {
                        set.setStatus(reqBo.getApplyRelStatus());
                        if (reqBo.getApplyRelStatus() == 0) {
                            offIds.add(brandApplyPO.getId());
                        }
                    }
                    this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                }
            } else {
                brandApplyPO.setApplyStatus(Integer.valueOf(2));
            }
        } else if (reqBo.getBrandApplyOperType() == 4) {
            brandApplyPO.setApplyStatus(Integer.valueOf(6));
        } else if (reqBo.getBrandApplyOperType() == 5) {
            brandApplyPO.setApplyStatus(Integer.valueOf(7));
        }
        if (reqBo.getBrandApplyOperType() == 1) {
            this.brandApplyMapper.insert(brandApplyPO);
        } else {
            BrandApplyPO where = new BrandApplyPO();
            where.setId(reqBo.getId());
            if (where.getId() == null) {
                throw new ZTBusinessException("\u672a\u4f20\u5165\u4e3b\u952eID");
            }
            brandApplyPO = this.extractData(reqBo, brandApplyPO);
            this.brandApplyMapper.updateBy(brandApplyPO, where);
        }
        return offIds;
    }

    private BrandApplyPO extractData(CceUccCreateBrandApplyAbilityReqBo reqBo, BrandApplyPO brandApplyPO) {
        Date authorizationTimeStart = null;
        Date authorizationTimeEnd = null;
        List accessoryInfo = reqBo.getAccessoryInfo();
        for (CceUccOtherAccessoryBO cceUccOtherAccessoryBO : accessoryInfo) {
            if (!cceUccOtherAccessoryBO.getType().equals(1)) continue;
            authorizationTimeStart = DateUtils.strToDate((String)cceUccOtherAccessoryBO.getAuthorizationTimeStartStr());
            authorizationTimeEnd = DateUtils.strToDate((String)cceUccOtherAccessoryBO.getAuthorizationTimeEndStr());
            break;
        }
        if (brandApplyPO.getApplyStatus().equals(5) && reqBo.getBrandApplyOperType().equals(3)) {
            try {
                BrandApplyPO brandApply = new BrandApplyPO();
                brandApply.setBrandId(brandApplyPO.getBrandId());
                brandApply.setCatalogId(brandApplyPO.getCatalogId());
                brandApply.setVendorId(brandApplyPO.getVendorId());
                brandApply.setApplyStatus(Integer.valueOf(5));
                List list = this.brandApplyMapper.getList(brandApply);
                for (BrandApplyPO po : list) {
                    BrandApplyPO where = new BrandApplyPO();
                    where.setId(po.getId());
                    BrandApplyPO set = new BrandApplyPO();
                    set.setApplyStatus(Integer.valueOf(8));
                    set.setFailureTime(new Date());
                    if (ObjectUtils.isEmpty((Object)po.getApplyVersion())) {
                        set.setApplyVersion(Integer.valueOf(1));
                        brandApplyPO.setApplyVersion(Integer.valueOf(set.getApplyVersion() + 1));
                    } else {
                        brandApplyPO.setApplyVersion(Integer.valueOf(po.getApplyVersion() + 1));
                    }
                    this.brandApplyMapper.updateBy(set, where);
                }
                BrandApplyPO newBrandApplyPO = new BrandApplyPO();
                if (!ObjectUtils.isEmpty((Object)list)) {
                    newBrandApplyPO = (BrandApplyPO)JSONObject.parseObject((String)JSONObject.toJSONString(list.get(0)), BrandApplyPO.class);
                }
                MmcConstant.merge(brandApplyPO, newBrandApplyPO);
                BrandApplyMainPO brandApplyMainPO = new BrandApplyMainPO();
                brandApplyMainPO.setBrandId(brandApplyPO.getBrandId());
                brandApplyMainPO.setCatalogId(brandApplyPO.getCatalogId());
                brandApplyMainPO.setVendorId(brandApplyPO.getVendorId());
                BrandApplyMainPO old = this.brandApplyMainMapper.getModelBy(brandApplyMainPO);
                log.info("^^^^^^^^^^^^^^^^^^^^^^newBrandApplyPOnewBrandApplyPO1111^^^^^{}", (Object)JSONObject.toJSONString((Object)newBrandApplyPO));
                BrandApplyMainPO brandApplyMain = (BrandApplyMainPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)newBrandApplyPO), BrandApplyMainPO.class);
                brandApplyMain.setAuthorizationTimeStart(authorizationTimeStart);
                brandApplyMain.setAuthorizationTimeEnd(authorizationTimeEnd);
                brandApplyMain.setIsValue("1");
                if (ObjectUtils.isEmpty((Object)old)) {
                    this.brandApplyMainMapper.insert(brandApplyMain);
                } else {
                    BrandApplyMainPO where = new BrandApplyMainPO();
                    where.setId(old.getId());
                    this.brandApplyMainMapper.updateBy(brandApplyMain, where);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return brandApplyPO;
    }

    private BrandApplyPO extractDataList(BrandApplyPO set, BrandApplyPO where) {
        BrandApplyPO brandApplyPO = this.brandApplyMapper.getModelBy(where);
        MmcConstant.merge(set, brandApplyPO);
        Date authorizationTimeStart = null;
        Date authorizationTimeEnd = null;
        OtherAccessoryPO otherAccessoryPO = new OtherAccessoryPO();
        otherAccessoryPO.setRelId(where.getId());
        List accessoryInfo = this.otherAccessoryMapper.getList(otherAccessoryPO);
        for (OtherAccessoryPO cceUccOtherAccessoryBO : accessoryInfo) {
            if (!cceUccOtherAccessoryBO.getType().equals(1)) continue;
            authorizationTimeStart = DateUtils.strToDate((String)cceUccOtherAccessoryBO.getAuthorizationTimeStartStr());
            authorizationTimeEnd = DateUtils.strToDate((String)cceUccOtherAccessoryBO.getAuthorizationTimeEndStr());
            break;
        }
        if (set.getApplyStatus().equals(5)) {
            try {
                BrandApplyPO brandApply = new BrandApplyPO();
                brandApply.setBrandId(brandApplyPO.getBrandId());
                brandApply.setCatalogId(brandApplyPO.getCatalogId());
                brandApply.setVendorId(brandApplyPO.getVendorId());
                brandApply.setApplyStatus(Integer.valueOf(5));
                List list = this.brandApplyMapper.getList(brandApply);
                for (BrandApplyPO po : list) {
                    BrandApplyPO where1 = new BrandApplyPO();
                    where1.setId(po.getId());
                    BrandApplyPO set1 = new BrandApplyPO();
                    set1.setApplyStatus(Integer.valueOf(8));
                    set1.setFailureTime(new Date());
                    if (ObjectUtils.isEmpty((Object)po.getApplyVersion())) {
                        set1.setApplyVersion(Integer.valueOf(1));
                        set.setApplyVersion(Integer.valueOf(set1.getApplyVersion() + 1));
                    } else {
                        set.setApplyVersion(Integer.valueOf(po.getApplyVersion() + 1));
                    }
                    this.brandApplyMapper.updateBy(set1, where1);
                }
                BrandApplyMainPO brandApplyMainPO = new BrandApplyMainPO();
                brandApplyMainPO.setBrandId(brandApplyPO.getBrandId());
                brandApplyMainPO.setCatalogId(brandApplyPO.getCatalogId());
                brandApplyMainPO.setVendorId(brandApplyPO.getVendorId());
                BrandApplyMainPO old = this.brandApplyMainMapper.getModelBy(brandApplyMainPO);
                log.info("^^^^^^^^^^^^^^^^^^^^^^brandApplyPObrandApplyPO22222^^^^^{}", (Object)JSONObject.toJSONString((Object)brandApplyPO));
                BrandApplyMainPO brandApplyMain = (BrandApplyMainPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)brandApplyPO), BrandApplyMainPO.class);
                brandApplyMain.setAuthorizationTimeStart(authorizationTimeStart);
                brandApplyMain.setAuthorizationTimeEnd(authorizationTimeEnd);
                brandApplyMain.setIsValue("1");
                if (ObjectUtils.isEmpty((Object)old)) {
                    this.brandApplyMainMapper.insert(brandApplyMain);
                } else {
                    BrandApplyMainPO whereMain = new BrandApplyMainPO();
                    whereMain.setId(old.getId());
                    this.brandApplyMainMapper.updateBy(brandApplyMain, whereMain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return set;
    }

    private void dealAccessory(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        if (reqBo.getId() != null) {
            OtherAccessoryPO otherAccessoryPO = new OtherAccessoryPO();
            otherAccessoryPO.setRelId(reqBo.getId());
            this.otherAccessoryMapper.deleteBy(otherAccessoryPO);
            if (!CollectionUtils.isEmpty((Collection)reqBo.getAccessoryInfo())) {
                List insertAccessoryList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBo.getAccessoryInfo()), OtherAccessoryPO.class);
                insertAccessoryList.forEach(each -> {
                    each.setRelId(reqBo.getId());
                    each.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    each.setAuthorizationTimeStart(DateUtils.strToDate((String)each.getAuthorizationTimeStartStr()));
                    each.setAuthorizationTimeEnd(DateUtils.strToDate((String)each.getAuthorizationTimeEndStr()));
                });
                this.otherAccessoryMapper.insertBatch(insertAccessoryList);
            }
        }
    }

    @DuplicateCommitLimit
    private String startAudit(CceUccCreateBrandApplyAbilityReqBo reqBo, CceUccCreateBrandApplyAbilityRspBo rspBo) {
        UccApproveCreationAtomReqBO uccApproveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
        uccApproveCreationAtomReqBO.setOrgIdIn(reqBo.getOrgId());
        uccApproveCreationAtomReqBO.setAuditAdvice("\u53d1\u8d77\u5ba1\u6279");
        uccApproveCreationAtomReqBO.setProcDefKey(reqBo.getProcDefKey());
        uccApproveCreationAtomReqBO.setOrderId(reqBo.getId());
        uccApproveCreationAtomReqBO.setObjType(Integer.valueOf(1));
        uccApproveCreationAtomReqBO.setObjId((List)Lists.newArrayList((Object[])new Long[]{reqBo.getId()}));
        uccApproveCreationAtomReqBO.setUserId(reqBo.getUserId());
        uccApproveCreationAtomReqBO.setOrgId(reqBo.getOrgId());
        uccApproveCreationAtomReqBO.setName(reqBo.getName());
        uccApproveCreationAtomReqBO.setOrgName(reqBo.getOrgName());
        uccApproveCreationAtomReqBO.setCheckOnAudit(Boolean.valueOf(true));
        UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(uccApproveCreationAtomReqBO);
        if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(uccApproveCreationAtomRspBO.getRespDesc());
        }
        if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue()) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u5ba1\u6279\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)uccApproveCreationAtomRspBO.getStepId())) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u4e0b\u4e00\u6b65\u9aa4\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u56fe");
        }
        try {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setId(reqBo.getId());
            BrandApplyPO brandApplyPOS = this.brandApplyMapper.getModelBy(brandApplyPO);
            TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
            todoUccWaitAbilityReqBO.setBusiCode("2017");
            todoUccWaitAbilityReqBO.setBusiName("\u54c1\u724c\u7533\u8bf7\u4e0a\u67b6\u5ba1\u6279");
            todoUccWaitAbilityReqBO.setCenterCode("commodity");
            todoUccWaitAbilityReqBO.setOperatorType("0");
            todoUccWaitAbilityReqBO.setObjNo(reqBo.getApplyCode());
            todoUccWaitAbilityReqBO.setObjId(reqBo.getId());
            if (Objects.nonNull(brandApplyPOS)) {
                todoUccWaitAbilityReqBO.setObjNo(brandApplyPOS.getApplyCode());
            }
            UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
            uccDealHandlerReqBO.setHandleName("brandHandler");
            this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
        }
        catch (Exception e) {
            log.error("taskTodoWaitService error:{}", (Throwable)e);
        }
        if (!CollectionUtils.isEmpty((Collection)uccApproveCreationAtomRspBO.getAuditNoticeList())) {
            if (CollectionUtils.isEmpty((Collection)rspBo.getAuditNoticeList())) {
                rspBo.setAuditNoticeList(uccApproveCreationAtomRspBO.getAuditNoticeList());
            } else {
                rspBo.getAuditNoticeList().addAll(uccApproveCreationAtomRspBO.getAuditNoticeList());
            }
        }
        return uccApproveCreationAtomRspBO.getStepId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkReq(CceUccCreateBrandApplyAbilityReqBo reqBo) {
        List brandApplyPOS;
        BrandApplyPO brandApplyPO;
        String msg = "";
        if (reqBo.getBrandApplyOperType() == null) {
            return "\u8bf7\u4f20\u5165\u64cd\u4f5c\u7c7b\u578b";
        }
        if (reqBo.getBrandApplyOperType() != 1 && reqBo.getId() == null && CollectionUtils.isEmpty((Collection)reqBo.getIds())) {
            return "\u8bf7\u4f20\u5165\u54c1\u724c\u7533\u8bf7\u4e3b\u952eID";
        }
        if (reqBo.getApplyRelStatus() == null) {
            reqBo.setApplyRelStatus(Integer.valueOf(1));
        }
        if (reqBo.getBrandApplyOperType() == 1 || reqBo.getBrandApplyOperType() == 2) {
            if (reqBo.getSaveOrSubmit() == null) {
                return "\u8bf7\u4f20\u5165\u64cd\u4f5c\u662f\u4fdd\u5b58\u8fd8\u662f\u63d0\u4ea4";
            }
            if (reqBo.getBrandApplyOperType() == 1 && StringUtils.isEmpty((Object)reqBo.getApplyCode())) {
                return "\u8bf7\u4f20\u5165\u7533\u8bf7\u7f16\u7801";
            }
            if (reqBo.getBrandId() == null) {
                return "\u8bf7\u9009\u62e9\u54c1\u724c";
            }
            if (reqBo.getBrandId() == -1L) {
                if (StringUtils.isEmpty((Object)reqBo.getBrandRemark())) {
                    return "\u8bf7\u586b\u5199\u54c1\u724c\u5907\u6ce8";
                }
                if (StringUtils.isEmpty((Object)reqBo.getBelongOrg())) {
                    return "\u8bf7\u586b\u5199\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a";
                }
            }
            if (reqBo.getVendorId() == null) {
                return "\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546";
            }
            if (reqBo.getCatalogId() == null) {
                return "\u8bf7\u9009\u62e9\u5206\u7c7b";
            }
            if (reqBo.getDiscount() == null) {
                return "\u8bf7\u586b\u5199\u6298\u6263\u7387\u6700\u5927\u9650\u503c";
            }
            if (reqBo.getSaveOrSubmit() == 2) {
                if (reqBo.getBrandApplyOperType() == 1) {
                    if (StringUtils.isEmpty((Object)reqBo.getLinkName())) {
                        return "\u8bf7\u586b\u5199\u8054\u7cfb\u4eba";
                    }
                    if (StringUtils.isEmpty((Object)reqBo.getLinkPhone())) {
                        return "\u8bf7\u586b\u5199\u8054\u7cfb\u7535\u8bdd";
                    }
                    if (StringUtils.isEmpty((Object)reqBo.getApplyReason())) {
                        return "\u8bf7\u586b\u5199\u7533\u8bf7\u539f\u56e0";
                    }
                } else {
                    brandApplyPO = new BrandApplyPO();
                    brandApplyPO.setIds(reqBo.getIds());
                    brandApplyPO.setId(reqBo.getId());
                    brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
                    if (CollectionUtils.isEmpty((Collection)brandApplyPOS)) throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6539\u54c1\u724c\u7533\u8bf7\uff0c\u8bf7\u6838\u67e5\u6570\u636e");
                    for (BrandApplyPO applyPO : brandApplyPOS) {
                        if (StringUtils.isEmpty((Object)reqBo.getLinkName()) && StringUtils.isEmpty((Object)applyPO.getLinkName())) {
                            return "\u8bf7\u586b\u5199\u8054\u7cfb\u4eba";
                        }
                        if (StringUtils.isEmpty((Object)reqBo.getLinkPhone()) && StringUtils.isEmpty((Object)applyPO.getLinkPhone())) {
                            return "\u8bf7\u586b\u5199\u8054\u7cfb\u7535\u8bdd";
                        }
                        if (!StringUtils.isEmpty((Object)reqBo.getApplyReason()) || !StringUtils.isEmpty((Object)applyPO.getApplyReason())) continue;
                        return "\u8bf7\u586b\u5199\u7533\u8bf7\u539f\u56e0";
                    }
                }
            }
        }
        if (reqBo.getBrandApplyOperType() != 3) return msg;
        if (reqBo.getConfirmResult() == null) {
            return "\u8bf7\u4f20\u5165\u786e\u8ba4\u7ed3\u679c";
        }
        if (reqBo.getConfirmResult() == 1) {
            if (StringUtils.isEmpty((Object)reqBo.getProcDefKey())) {
                return "\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49Key";
            }
            brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(reqBo.getIds());
            brandApplyPO.setId(reqBo.getId());
            brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            if (CollectionUtils.isEmpty((Collection)brandApplyPOS)) throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6539\u54c1\u724c\u7533\u8bf7\uff0c\u8bf7\u6838\u67e5\u6570\u636e");
            if (reqBo.getBrandId() == null) throw new ZTBusinessException("\u7533\u8bf7\u5355" + reqBo.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
            if (reqBo.getBrandId() == -1L) {
                throw new ZTBusinessException("\u7533\u8bf7\u5355" + reqBo.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
            }
            if (reqBo.getVendorId() == null) {
                throw new ZTBusinessException("\u7533\u8bf7\u5355" + reqBo.getApplyCode() + "\u672a\u9009\u62e9\u4f9b\u5e94\u5546");
            }
            if (reqBo.getCatalogId() != null) return msg;
            throw new ZTBusinessException("\u7533\u8bf7\u5355" + reqBo.getApplyCode() + "\u672a\u9009\u62e9\u5206\u7c7b");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getConfirmRemark())) return msg;
        return "\u8bf7\u586b\u5199\u786e\u8ba4\u610f\u89c1\uff01";
    }

    private void syncRel(List<Long> ids, CceUccCreateBrandApplyAbilityReqBo reqBo) {
        if (!CollectionUtils.isEmpty(ids)) {
            BrandApplyPO brandApplyPO = new BrandApplyPO();
            brandApplyPO.setIds(ids);
            List brandApplyPOS = this.brandApplyMapper.getList(brandApplyPO);
            if (!CollectionUtils.isEmpty((Collection)brandApplyPOS)) {
                HashMap<String, Date> checkDup = new HashMap<String, Date>();
                for (Object applyPO : brandApplyPOS) {
                    if (applyPO.getBrandId() == null || applyPO.getBrandId() == -1L) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u54c1\u724c");
                    }
                    if (applyPO.getVendorId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u4f9b\u5e94\u5546");
                    }
                    if (applyPO.getCatalogId() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u672a\u9009\u62e9\u5206\u7c7b");
                    }
                    if (applyPO.getConfirmTime() == null) {
                        throw new ZTBusinessException("\u7533\u8bf7\u5355" + applyPO.getApplyCode() + "\u6ca1\u6709\u901a\u8fc7\u8fd0\u8425\u786e\u8ba4\uff0c\u8bf7\u6838\u67e5\u6570\u636e");
                    }
                    if (checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())) {
                        if (applyPO.getConfirmTime().getTime() <= ((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).getTime()) continue;
                        checkDup.replace("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                        continue;
                    }
                    checkDup.put("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId(), applyPO.getConfirmTime());
                }
                ArrayList<BrandApplyPO> syncList = new ArrayList<BrandApplyPO>();
                for (BrandApplyPO applyPO : brandApplyPOS) {
                    if (!checkDup.containsKey("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId()) || !((Date)checkDup.get("" + applyPO.getBrandId() + applyPO.getVendorId() + applyPO.getCatalogId())).equals(applyPO.getConfirmTime())) continue;
                    syncList.add(applyPO);
                }
                if (!CollectionUtils.isEmpty(syncList)) {
                    ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
                    for (BrandApplyPO applyPO : syncList) {
                        UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
                        uccRelCatalogBrandVendorPO.setVendorId(applyPO.getVendorId());
                        uccRelCatalogBrandVendorPO.setBrandId(applyPO.getBrandId());
                        uccRelCatalogBrandVendorPO.setCatalogId(applyPO.getCatalogId());
                        List uccRelCatalogBrandVendorPOS = this.uccRelCatalogBrandVendorMapper.getList(uccRelCatalogBrandVendorPO);
                        if (!CollectionUtils.isEmpty((Collection)uccRelCatalogBrandVendorPOS)) {
                            UccRelCatalogBrandVendorPO checkPo = (UccRelCatalogBrandVendorPO)uccRelCatalogBrandVendorPOS.get(0);
                            UccRelCatalogBrandVendorPO set = new UccRelCatalogBrandVendorPO();
                            set.setDiscountFlag(Integer.valueOf(0));
                            set.setDiscount(applyPO.getDiscount());
                            set.setCreateOperId(applyPO.getConfirmUserCode());
                            set.setCreateOperName(applyPO.getConfirmUserName());
                            set.setCreateTime(new Date());
                            set.setUpdateOperId(applyPO.getConfirmUserCode());
                            set.setUpdateOperName(applyPO.getConfirmUserName());
                            set.setUpdateTime(new Date());
                            set.setBrandApplyId(applyPO.getId());
                            set.setApplyCode(applyPO.getApplyCode());
                            UccRelCatalogBrandVendorPO where = new UccRelCatalogBrandVendorPO();
                            where.setCatalogId(checkPo.getCatalogId());
                            where.setVendorId(checkPo.getVendorId());
                            where.setBrandId(checkPo.getBrandId());
                            this.uccRelCatalogBrandVendorMapper.updateBy(set, where);
                            continue;
                        }
                        UccRelCatalogBrandVendorPO insertPo = new UccRelCatalogBrandVendorPO();
                        insertPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
                        insertPo.setVendorId(applyPO.getVendorId());
                        insertPo.setBrandId(applyPO.getBrandId());
                        insertPo.setCatalogId(applyPO.getCatalogId());
                        insertPo.setStatus(Integer.valueOf(1));
                        insertPo.setCreateOperId(applyPO.getConfirmUserCode());
                        insertPo.setCreateOperName(applyPO.getConfirmUserName());
                        insertPo.setCreateTime(new Date());
                        insertPo.setUpdateOperId(applyPO.getConfirmUserCode());
                        insertPo.setUpdateOperName(applyPO.getConfirmUserName());
                        insertPo.setUpdateTime(new Date());
                        insertPo.setDiscountFlag(Integer.valueOf(0));
                        insertPo.setDiscount(applyPO.getDiscount());
                        insertPo.setBrandApplyId(applyPO.getId());
                        insertPo.setApplyCode(applyPO.getApplyCode());
                        insertList.add(insertPo);
                    }
                    if (!CollectionUtils.isEmpty(insertList)) {
                        this.uccRelCatalogBrandVendorMapper.insertBatch(insertList);
                    }
                }
            }
        }
    }
}

