/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.dao.UccStandardComInfoMapper;
import com.tydic.commodity.estore.atom.api.UccGovernMaterialPushAtomService;
import com.tydic.commodity.estore.atom.bo.UccGovernMaterialPushAtomReqBO;
import com.tydic.commodity.estore.busi.api.UccStandardOnShelveValidBusiService;
import com.tydic.commodity.estore.busi.bo.UccStandardOnShelveValidBusiReqBO;
import com.tydic.commodity.estore.busi.bo.UccStandardOnShelveValidBusiRspBO;
import com.tydic.commodity.po.UccStandardComInfoPO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccStandardOnShelveValidBusiServiceImpl
implements UccStandardOnShelveValidBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardOnShelveValidBusiServiceImpl.class);
    @Autowired
    private UccStandardComInfoMapper uccStandardComInfoMapper;
    @Autowired
    private UccGovernMaterialPushAtomService uccGovernMaterialPushAtomService;

    @Override
    public UccStandardOnShelveValidBusiRspBO dealStandardSku(UccStandardOnShelveValidBusiReqBO reqBO) {
        UccStandardOnShelveValidBusiRspBO rspBO = new UccStandardOnShelveValidBusiRspBO();
        rspBO.setRespCode("0000");
        try {
            List standardComInfoPOS;
            List standardIdList = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getStandardComId).distinct().collect(Collectors.toList());
            List onShelveCountList = this.uccStandardComInfoMapper.getOnShelveCountList(standardIdList);
            if (!CollectionUtils.isEmpty((Collection)onShelveCountList) && !CollectionUtils.isEmpty(standardComInfoPOS = onShelveCountList.stream().filter(e -> e.getOnShelveCount() < 1).collect(Collectors.toList()))) {
                UccGovernMaterialPushAtomReqBO atomReqBO = new UccGovernMaterialPushAtomReqBO();
                atomReqBO.setExtStandardComIds(standardComInfoPOS.stream().map(UccStandardComInfoPO::getExtStandardComId).distinct().collect(Collectors.toList()));
                this.uccGovernMaterialPushAtomService.dealGovernMaterialPush(atomReqBO);
            }
            this.uccStandardComInfoMapper.addShelveCount(standardIdList);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u6807\u54c1\u7b2c\u4e00\u6b21\u4e0a\u67b6\u903b\u8f91\u5f02\u5e38 \uff1a" + e2.getMessage());
        }
        return rspBO;
    }
}

