/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.common;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.bo.UccEsCommodityBo;
import com.tydic.commodity.common.ability.bo.UccExprotCodeBo;
import com.tydic.commodity.common.ability.bo.UccSpuCodingexportAbilityRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.estore.ability.bo.UccFreshProductWaitMatchParamBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UccProductQryEsComponent {
    private static final Logger log = LoggerFactory.getLogger(UccProductQryEsComponent.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public UccSpuCodingexportAbilityRspBO searchProductByEs(UccFreshProductWaitMatchParamBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = this.buildEsSql(reqBO);
        String s = this.excuteEsSql(reqBO, boolQueryBuilder);
        String s1 = this.searchInfo(s);
        return this.dealSearchData(s1, reqBO);
    }

    private UccSpuCodingexportAbilityRspBO dealSearchData(String result, UccFreshProductWaitMatchParamBO reqBo) {
        UccSpuCodingexportAbilityRspBO rspBo = new UccSpuCodingexportAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccEsCommodityBo> commodityModels = new ArrayList<UccEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccEsCommodityBo commodity = new UccEsCommodityBo();
                try {
                    commodity = (UccEsCommodityBo)JSON.toJavaObject((JSON)data, UccEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSpuCodingexportAbilityRspBO copyData(List<UccEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSpuCodingexportAbilityRspBO rspBo = new UccSpuCodingexportAbilityRspBO();
        ArrayList<UccExprotCodeBo> uccExprotCodeBoList = new ArrayList<UccExprotCodeBo>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccEsCommodityBo uccEsCommodityBo : commodityModels) {
                    UccExprotCodeBo uccExprotCodeBo = new UccExprotCodeBo();
                    uccExprotCodeBo.setSkuId(Long.valueOf(uccEsCommodityBo.getSku_id()));
                    uccExprotCodeBoList.add(uccExprotCodeBo);
                }
            }
            rspBo.setRows(uccExprotCodeBoList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccFreshProductWaitMatchParamBO reqBo) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        log.info("--------------------\u67e5\u8be2\u53c2\u6570\uff1areqBo");
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)reqBo.getSkuStatus()));
            if (ObjectUtil.isNotEmpty((Object)reqBo.getBrandVerifyResult())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brandVerifyResult", (Object)reqBo.getBrandVerifyResult()));
            }
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccFreshProductWaitMatchParamBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        String sortField = "";
        ArrayList<SortBuilder> fieldSortBuilders = new ArrayList<SortBuilder>();
        fieldSortBuilders.add(SortBuilders.fieldSort((String)"sku_id").order(orderType));
        queryJson.put("sort", (Object)JSONObject.parseArray((String)((Object)fieldSortBuilders).toString()));
        return queryJson.toString();
    }
}

