/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.commodity.dao.XextSkuChangeMapper;
import com.tydic.commodity.estore.ability.api.CceQryMsgAbilityService;
import com.tydic.commodity.estore.ability.bo.CceQryMsgReqBO;
import com.tydic.commodity.estore.ability.bo.CceQryMsgRspBO;
import com.tydic.commodity.estore.ability.bo.XextSkuChangeBO;
import com.tydic.commodity.po.XextSkuChangePo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.CceQryMsgAbilityService"})
public class CceQryMsgAbilityServiceImpl
implements CceQryMsgAbilityService {
    @Autowired
    private XextSkuChangeMapper xextSkuChangeMapper;
    @Value(value="${msg_ability_date:-1}")
    private String msgAbilityDate;

    @PostMapping(value={"qryMsg"})
    public CceQryMsgRspBO qryMsg(@RequestBody CceQryMsgReqBO reqBO) {
        XextSkuChangePo po = new XextSkuChangePo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        this.paramSplit(reqBO, po);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, Integer.parseInt(this.msgAbilityDate));
        Date beforeDate = calendar.getTime();
        po.setExtTime(beforeDate);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtSkuIds()) && reqBO.getExtSkuIds().size() == 1) {
            po.setExtSkuIds(null);
            po.setExtSkuId((String)reqBO.getExtSkuIds().get(0));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtSpuIds()) && reqBO.getExtSpuIds().size() == 1) {
            po.setExtSpuIds(null);
            po.setExtSpuId((String)reqBO.getExtSpuIds().get(0));
        }
        int pageNo = reqBO.getPageNo();
        int pageSize = reqBO.getPageSize();
        int curPage = (pageNo - 1) * pageSize;
        CceQryMsgRspBO rspBO = new CceQryMsgRspBO();
        int a = this.xextSkuChangeMapper.quyMsgListPageCount(po);
        if (a == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        int pageCount = a % pageSize == 0 ? a / pageSize : a / pageSize + 1;
        List list = this.xextSkuChangeMapper.quyMsgListPage(po, curPage, pageSize);
        ArrayList<XextSkuChangeBO> rows = new ArrayList<XextSkuChangeBO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (XextSkuChangePo changePo : list) {
                XextSkuChangeBO x = new XextSkuChangeBO();
                BeanUtils.copyProperties((Object)changePo, (Object)x);
                if (x.getMsgGetType() == 2) {
                    x.setMsgGetTypeStr("\u5546\u54c1\u4ef7\u683c\u53d8\u66f4");
                } else if (x.getMsgGetType() == 4) {
                    x.setMsgGetTypeStr("\u5546\u54c1\u4e0a\u4e0b\u67b6\u53d8\u66f4");
                } else if (x.getMsgGetType() == 6) {
                    x.setMsgGetTypeStr("\u6dfb\u52a0\u3001\u5220\u9664\u5546\u54c1\u6c60\u5185\u5546\u54c1");
                } else if (x.getMsgGetType() == 16) {
                    x.setMsgGetTypeStr("\u5546\u54c1\u4ecb\u7ecd\u53ca\u89c4\u683c\u53c2\u6570\u53d8\u66f4");
                } else if (x.getMsgGetType() == 21) {
                    x.setMsgGetTypeStr("\u6570\u636e\u6cbb\u7406\u9a73\u56de");
                } else if (x.getMsgGetType() == 20) {
                    x.setMsgGetTypeStr("\u5339\u914d\u6807\u51c6\u54c1\u724c\u5931\u8d25");
                }
                if (x.getSkuPoolState() == 1) {
                    x.setSkuPoolStateStr("\u4e0a\u67b6");
                } else {
                    x.setSkuPoolStateStr("\u4e0b\u67b6");
                }
                if (reqBO.getState() == 0) {
                    x.setStateStr("\u672a\u5904\u7406");
                } else {
                    x.setStateStr("\u5931\u8d25");
                }
                rows.add(x);
            }
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(a);
        rspBO.setTotal(pageCount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void paramSplit(CceQryMsgReqBO reqBO, XextSkuChangePo po) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExtSkuId()) && reqBO.getExtSkuId().contains(",")) {
            String[] extSkuIdArr = reqBO.getExtSkuId().split(",");
            ArrayList<String> extSkuIdList = new ArrayList<String>(Arrays.asList(extSkuIdArr));
            po.setExtSkuIds(extSkuIdList);
            po.setExtSkuId(null);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getExtSpuId()) && reqBO.getExtSpuId().contains(",")) {
            String[] extSpuIdArr = reqBO.getExtSpuId().split(",");
            ArrayList<String> extSpuIdList = new ArrayList<String>(Arrays.asList(extSpuIdArr));
            po.setExtSpuIds(extSpuIdList);
            po.setExtSpuId(null);
        }
    }
}

