/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomReqBO;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccCyclePircePercentageMapper;
import com.tydic.commodity.dao.UccIntervalPircePercentageMapper;
import com.tydic.commodity.dao.UccPriceAnomalyItemMapper;
import com.tydic.commodity.dao.UccPricePreventLogMapper;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStandardPriceMapper;
import com.tydic.commodity.estore.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.estore.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.estore.busi.api.UpdateSkuStatusForMarketService;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceReqBo;
import com.tydic.commodity.estore.busi.bo.MqSyncCommdPriceRspBo;
import com.tydic.commodity.estore.busi.bo.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.estore.comb.bo.UccExecuteCommdMsgCombRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.ECommercePriceChangePO;
import com.tydic.commodity.po.UccCyclePircePercentagePO;
import com.tydic.commodity.po.UccIntervalPircePercentagePO;
import com.tydic.commodity.po.UccPriceAnomalyItemPO;
import com.tydic.commodity.po.UccPricePreventPO;
import com.tydic.commodity.po.UccSkuStandardPricePO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.api.XwglRuleGetNoauthDetailAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailReqBo;
import com.tydic.xwgl.ability.bo.XwglRuleGetNoauthDetailRspBo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceBusiServiceImpl
implements UccMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private Sequence coefficientSequence = Sequence.getInstance();
    @Autowired
    private UccIntervalPircePercentageMapper uccIntervalPircePercentageMapper;
    @Autowired
    private UccCyclePircePercentageMapper uccCyclePircePercentageMapper;
    @Autowired
    private UpdateSkuStatusForMarketService batchUpdateCommoStatusForMarket;
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;
    @Autowired
    private UccPricePreventLogMapper uccPricePreventLogMapper;
    @Autowired
    private UccSkuStandardPriceMapper uccSkuStandardPriceMapper;
    @Autowired
    private UccDataGovernPushSkuStateAtomService uccDataGovernPushSkuStateAtomService;
    @Autowired
    private UccPriceAnomalyItemMapper uccPriceAnomalyItemMapper;
    @Autowired
    private XwglRuleGetNoauthDetailAbilityService xwglRuleGetNoauthDetailAbilityService;
    @Autowired
    private XwgLSaveLogAbilityService xwglSaveLogAbilityService;
    @Value(value="${ucc.sku.surpass.listed.ruleNo:YGSC-SP-00010}")
    private String uccSkuSurpassListedRuleNo;
    @Value(value="${ucc.sku.detail.url:http://172.20.175.3/#/index/ecCommodityItemDetail?skuId=}")
    private String uccSkuDetailUrl;

    @Override
    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) throws ZTBusinessException {
        MqSyncCommdPriceRspBo rspBo = new MqSyncCommdPriceRspBo();
        if (CollectionUtils.isEmpty(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            skuPriceBo.setSalePrice(each.getSalePrice());
            skuPriceBo.setAgreementPrice(each.getAgreementPrice());
            skuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        try {
            this.dealUpFloatNew(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList());
        }
        catch (Exception e) {
            log.error("\u4ef7\u683c\u9884\u8b66\u5f02\u5e38\uff1a" + e.getMessage());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccExecuteCommdMsgCombRspBO> dealUpFloatNew(List<MqSyncCommdPriceBo> bos) {
        ArrayList<UccExecuteCommdMsgCombRspBO> listRsp = new ArrayList<UccExecuteCommdMsgCombRspBO>();
        if (!CollectionUtils.isEmpty(bos)) {
            ArrayList<Long> commoditys = new ArrayList<Long>();
            ArrayList<Long> skuIdPrices = new ArrayList<Long>();
            ArrayList<UccPricePreventPO> uccPricePreventPOS = new ArrayList<UccPricePreventPO>();
            ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
            ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
            List skuIds = bos.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            try {
                UccPriceAnomalyItemPO setUccPriceAnomalyItemPo = new UccPriceAnomalyItemPO();
                setUccPriceAnomalyItemPo.setIsDeleted("1");
                UccPriceAnomalyItemPO whereUccPriceAnomalyItemPo = new UccPriceAnomalyItemPO();
                whereUccPriceAnomalyItemPo.setChangePriceTypes(Arrays.asList(UccConstants.WarnType.XY, UccConstants.WarnType.SC));
                whereUccPriceAnomalyItemPo.setSkuIds(skuIds);
                whereUccPriceAnomalyItemPo.setTriggerType(UccConstants.TriggerType.EARLY_WARNING_OR_AUTOMATIC_REMOVAL);
                this.uccPriceAnomalyItemMapper.updateBy(setUccPriceAnomalyItemPo, whereUccPriceAnomalyItemPo);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u65e7\u7684\u4ef7\u683c\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u5220\u9664\u65e7\u7684\u4ef7\u683c\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25");
            }
            HashMap<Long, UccSkuStandardPricePO> skuStandardPricePOMap = new HashMap();
            if (!CollectionUtils.isEmpty(skuIds)) {
                UccSkuStandardPricePO uccSkuStandardPricePO = new UccSkuStandardPricePO();
                uccSkuStandardPricePO.setSkuIds(skuIds);
                List uccSkuStandardPricePOS = this.uccSkuStandardPriceMapper.getList(uccSkuStandardPricePO);
                if (!CollectionUtils.isEmpty((Collection)uccSkuStandardPricePOS)) {
                    skuStandardPricePOMap = uccSkuStandardPricePOS.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b, (first, second) -> first));
                }
            }
            for (MqSyncCommdPriceBo bo : bos) {
                BigDecimal agreementPrice = MoneyUtils.haoToYuan((Long)bo.getAgreementPrice());
                BigDecimal oldAgreementPrice = MoneyUtils.haoToYuan((Long)bo.getOldAgreementPrice());
                this.extracted(bo, uccPricePreventPOS, commoditys, skuIdPrices, eCommercePriceChangePOList, skuStandardPricePOMap, eCommercePriceChangeLogPOS, agreementPrice, oldAgreementPrice, UccConstants.WarnType.XY);
                BigDecimal marketPrice = MoneyUtils.haoToYuan((Long)bo.getMarketPrice());
                BigDecimal oldMarketPrice = MoneyUtils.haoToYuan((Long)bo.getOldMarketPrice());
                this.extracted(bo, uccPricePreventPOS, commoditys, skuIdPrices, eCommercePriceChangePOList, skuStandardPricePOMap, eCommercePriceChangeLogPOS, marketPrice, oldMarketPrice, UccConstants.WarnType.SC);
            }
            if (!CollectionUtils.isEmpty(skuIdPrices)) {
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                Long[] longs = new Long[skuIdPrices.size()];
                for (int i = 0; i < skuIdPrices.size(); ++i) {
                    longs[i] = (Long)skuIdPrices.get(i);
                }
                batchUpdateCommoStatusForMarketBO.setBusinessId(longs);
                batchUpdateCommoStatusForMarketBO.setReason("\u4ef7\u683c\u9884\u8b66\u8d85\u8fc7\u9608\u503c\uff0c\u5546\u54c1\u81ea\u52a8\u4e0b\u67b6");
                RspUccBo rspUccBo = this.batchUpdateCommoStatusForMarket.UpdateSkuStatusForMarket(batchUpdateCommoStatusForMarketBO, SkuStatusEnum.WARN_DOWN_STATUS);
                if ("0000".equals(rspUccBo.getRespCode())) {
                    try {
                        UccDataGovernPushSkuStateAtomReqBO stateAtomReqBO = new UccDataGovernPushSkuStateAtomReqBO();
                        stateAtomReqBO.setSkuIds(skuIdPrices);
                        this.uccDataGovernPushSkuStateAtomService.dealDataGovernPushSkuState(stateAtomReqBO);
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u72b6\u6001\u4fe1\u606f\u5931\u8d25 {}", (Object)e.getMessage());
                    }
                }
            }
            try {
                if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                    for (UccPricePreventPO po : uccPricePreventPOS) {
                        UccPricePreventPO preventPO = new UccPricePreventPO();
                        preventPO.setSkuId(po.getSkuId());
                        po.setPreventLogId(Long.valueOf(this.coefficientSequence.nextId()));
                        preventPO.setChangePriceType(po.getChangePriceType());
                        List list = this.uccPricePreventMapper.getList(preventPO);
                        if (!CollectionUtils.isEmpty((Collection)list)) {
                            this.uccPricePreventMapper.updateBy(po, (UccPricePreventPO)list.get(0));
                            continue;
                        }
                        po.setPreventId(Long.valueOf(this.coefficientSequence.nextId()));
                        this.uccPricePreventMapper.insert(po);
                    }
                    String json = JSONObject.toJSONString(uccPricePreventPOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                    List logPOS = (List)JSON.parseObject((String)json, List.class);
                    this.uccPricePreventLogMapper.insertBatch(logPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u6dfb\u52a0\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                try {
                    ArrayList<UccPriceAnomalyItemPO> uccPriceAnomalyItemPos = new ArrayList<UccPriceAnomalyItemPO>();
                    for (UccPricePreventPO each : uccPricePreventPOS) {
                        UccPriceAnomalyItemPO uccPriceAnomalyItemPo = new UccPriceAnomalyItemPO();
                        uccPriceAnomalyItemPo.setId(Long.valueOf(this.coefficientSequence.nextId()));
                        uccPriceAnomalyItemPo.setSkuId(each.getSkuId());
                        uccPriceAnomalyItemPo.setIsDeleted("0");
                        uccPriceAnomalyItemPo.setChangePriceType(each.getChangePriceType());
                        uccPriceAnomalyItemPo.setFloatingRate(each.getPercentage() == null ? BigDecimal.ZERO : each.getPercentage());
                        uccPriceAnomalyItemPo.setNewPrice(MoneyUtils.haoToYuan((BigDecimal)each.getPrice()));
                        uccPriceAnomalyItemPo.setOldPrice(MoneyUtils.haoToYuan((BigDecimal)each.getBeforePrice()));
                        uccPriceAnomalyItemPo.setCreateTime(new Date());
                        uccPriceAnomalyItemPo.setCreateUserName("\u7cfb\u7edf");
                        uccPriceAnomalyItemPo.setTriggerType(UccConstants.TriggerType.EARLY_WARNING_OR_AUTOMATIC_REMOVAL);
                        uccPriceAnomalyItemPo.setExt1("2");
                        if (uccPriceAnomalyItemPo.getNewPrice().compareTo(uccPriceAnomalyItemPo.getOldPrice()) < 0) {
                            uccPriceAnomalyItemPo.setFloatingRate(uccPriceAnomalyItemPo.getFloatingRate().negate());
                        }
                        uccPriceAnomalyItemPos.add(uccPriceAnomalyItemPo);
                    }
                    this.uccPriceAnomalyItemMapper.insertBatch(uccPriceAnomalyItemPos);
                }
                catch (Exception e) {
                    log.error("\u65b0\u589e\u4ef7\u683c\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                    throw new ZTBusinessException("\u65b0\u589e\u4ef7\u683c\u5f02\u5e38\u8bb0\u5f55\u5931\u8d25");
                }
            }
            try {
                if (eCommercePriceChangePOList.size() > 0) {
                    this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u5931\u8d25");
            }
            try {
                if (eCommercePriceChangeLogPOS.size() > 0) {
                    this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
                }
            }
            catch (Exception e) {
                log.error("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
                throw new ZTBusinessException("\u4e0a\u6d6e\u6bd4\u8d85\u8fc7\u81ea\u52a8\u4e0b\u67b6\u6bd4\uff0c\u6dfb\u52a0\u4ef7\u683c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty(uccPricePreventPOS)) {
                try {
                    this.dealXwgl(uccPricePreventPOS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4e0a\u67b6\u4e0a\u6d6e\u8d85\u8fc7\u9884\u8b66\uff0c\u65b0\u589e\u4e0a\u6d6e\u9884\u8b66\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25sku{}", uccPricePreventPOS.stream().map(UccPricePreventPO::getSkuId).collect(Collectors.toList()));
                }
            }
        }
        UccExecuteCommdMsgCombRspBO rspBO = new UccExecuteCommdMsgCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        listRsp.add(rspBO);
        return listRsp;
    }

    private void dealXwgl(List<UccPricePreventPO> uccPricePreventPOS) {
        List uccSkuPos = this.uccSkuMapper.batchQrySku(uccPricePreventPOS.stream().map(UccPricePreventPO::getSkuId).collect(Collectors.toList()), null);
        if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
            XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.getXwglRuleGetNoauthDetailRspBo();
            ArrayList xwglLogs = new ArrayList();
            XwgLSaveLogReqBo xwgLSaveLogReqBo = new XwgLSaveLogReqBo();
            uccSkuPos.forEach(o -> {
                XwgLSaveLogReqBoXwglLogs x = new XwgLSaveLogReqBoXwglLogs();
                BeanUtils.copyProperties((Object)expRuleRspBo, (Object)x);
                x.setBusinessName(o.getSkuName());
                x.setBusinessId(o.getExtSkuId());
                x.setBusinessCode(o.getSkuCode());
                x.setIsZj(Integer.valueOf(1));
                x.setBusinessUrl(this.uccSkuDetailUrl + o.getSkuId() + "&supplierShopId=" + o.getSupplierShopId());
                x.setRulId(expRuleRspBo.getRuleId());
                if (ObjectUtil.isNotEmpty((Object)o.getCreateOperId())) {
                    x.setManagerId(Long.valueOf(o.getCreateOperId()));
                } else {
                    x.setManagerId(Long.valueOf(1L));
                }
                if (ObjectUtil.isNotEmpty((Object)o.getCreateOperName())) {
                    x.setManagerName(o.getCreateOperName());
                } else {
                    x.setManagerName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                }
                x.setCompanyId(o.getOrgId() + "");
                x.setDeptId(o.getOrgId() + "");
                x.setCompanyName(o.getOrgName());
                x.setDeptName(o.getOrgName());
                xwglLogs.add(x);
            });
            xwgLSaveLogReqBo.setXwglLogs(xwglLogs);
            xwgLSaveLogReqBo.setUserId(Long.valueOf(1L));
            xwgLSaveLogReqBo.setName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            log.debug("UccMqSyncCommdPriceBusiService-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)xwgLSaveLogReqBo));
            XwgLSaveLogRspBo xwgLSaveLogRspBo = this.xwglSaveLogAbilityService.saveXwglLog(xwgLSaveLogReqBo);
            log.debug("UccMqSyncCommdPriceBusiService-\u9884\u8b66\u6821\u9a8c\u4fdd\u5b58\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)xwgLSaveLogRspBo));
        }
    }

    private XwglRuleGetNoauthDetailRspBo getXwglRuleGetNoauthDetailRspBo() {
        XwglRuleGetNoauthDetailReqBo ruleReqBo = new XwglRuleGetNoauthDetailReqBo();
        ruleReqBo.setRuleNo(this.uccSkuSurpassListedRuleNo);
        XwglRuleGetNoauthDetailRspBo expRuleRspBo = this.xwglRuleGetNoauthDetailAbilityService.getNoauthDetail(ruleReqBo);
        log.debug("dealSkuSurpassVpt-\u4ef7\u683c\u9600\u503c\u9884\u8b66\u89c4\u5219\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)expRuleRspBo));
        if (!"0000".equals(expRuleRspBo.getRespCode())) {
            throw new BusinessException(expRuleRspBo.getRespCode(), expRuleRspBo.getRespDesc());
        }
        if (ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleContent()) || ObjectUtil.isEmpty((Object)expRuleRspBo.getRuleName())) {
            throw new BusinessException("8888", "\u89c4\u5219\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
        }
        return expRuleRspBo;
    }

    private void extracted(MqSyncCommdPriceBo bo, List<UccPricePreventPO> uccPricePreventPOS, List<Long> commoditys, List<Long> skuIdPrices, List<ECommercePriceChangePO> eCommercePriceChangePOList, Map<Long, UccSkuStandardPricePO> skuStandardPricePOMap, List<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS, BigDecimal newPrice, BigDecimal oldPrice, Integer warnType) {
        UccIntervalPircePercentagePO skuPercentage = null;
        UccIntervalPircePercentagePO uccIntervalPricePercentagePO = new UccIntervalPircePercentagePO();
        uccIntervalPricePercentagePO.setWarnType(warnType);
        Page page = new Page();
        page.setPageSize(999);
        List pricePercentagePos = this.uccIntervalPircePercentageMapper.getListPage(uccIntervalPricePercentagePO, page);
        boolean flag = false;
        if (!CollectionUtils.isEmpty((Collection)pricePercentagePos)) {
            for (UccIntervalPircePercentagePO intervalPricePercentagePO : pricePercentagePos) {
                BigDecimal maxPrice = intervalPricePercentagePO.getNumEnd();
                BigDecimal minPrice = intervalPricePercentagePO.getNumStart();
                BigDecimal zero = new BigDecimal(0);
                if (maxPrice == null && newPrice.compareTo(minPrice) > 0) {
                    skuPercentage = intervalPricePercentagePO;
                    break;
                }
                if (newPrice.compareTo(minPrice) <= -1 || newPrice.compareTo(maxPrice) >= 1) continue;
                skuPercentage = intervalPricePercentagePO;
                break;
            }
        }
        UccPricePreventPO uccPricePreventPO = new UccPricePreventPO();
        uccPricePreventPO.setBeforePrice(new BigDecimal(MoneyUtils.yuanToHaoToLong((BigDecimal)oldPrice)));
        uccPricePreventPO.setPrice(new BigDecimal(MoneyUtils.yuanToHaoToLong((BigDecimal)newPrice)));
        uccPricePreventPO.setSupplierShopId(bo.getSupplierShopId());
        uccPricePreventPO.setUpdateTime(new Date());
        uccPricePreventPO.setSkuId(bo.getSkuId());
        uccPricePreventPO.setSkuName(bo.getSkuName());
        uccPricePreventPO.setBrandId(bo.getBrandId());
        uccPricePreventPO.setExtSkuId(bo.getExtSkuId());
        uccPricePreventPO.setOnShelveTime(bo.getOnShelveTime());
        uccPricePreventPO.setChangePriceType(warnType);
        if (skuPercentage != null) {
            BigDecimal downPrevent;
            uccPricePreventPO.setIsDown(Integer.valueOf(0));
            if (newPrice.compareTo(oldPrice) < 0 && (downPrevent = oldPrice.subtract(newPrice).divide(oldPrice, 4, 4)).compareTo(skuPercentage.getDownPercentage().divide(new BigDecimal("100"))) > -1) {
                uccPricePreventPO.setPercentage(downPrevent);
                uccPricePreventPOS.add(uccPricePreventPO);
                flag = true;
            }
            if (newPrice.compareTo(oldPrice) > 0) {
                BigDecimal upPrevent = newPrice.subtract(oldPrice).divide(oldPrice, 4, 4);
                if (upPrevent.compareTo(skuPercentage.getUpperPercentage().divide(new BigDecimal("100"))) > -1) {
                    uccPricePreventPO.setPercentage(upPrevent);
                    uccPricePreventPOS.add(uccPricePreventPO);
                    flag = true;
                }
                if (upPrevent.compareTo(skuPercentage.getOffShelfPercentage().divide(new BigDecimal("100"))) > -1) {
                    uccPricePreventPO.setIsDown(Integer.valueOf(1));
                    commoditys.add(bo.getCommodityId());
                    skuIdPrices.add(bo.getSkuId());
                }
            }
        }
        if (!flag) {
            UccCyclePircePercentagePO uccCyclePircePercentagePO = new UccCyclePircePercentagePO();
            uccCyclePircePercentagePO.setWarnType(warnType);
            List uccCyclePircePercentagePos = this.uccCyclePircePercentageMapper.getList(uccCyclePircePercentagePO);
            if (!CollectionUtils.isEmpty((Collection)uccCyclePircePercentagePos)) {
                BigDecimal downPrevent;
                UccCyclePircePercentagePO modelBy = (UccCyclePircePercentagePO)uccCyclePircePercentagePos.get(0);
                ECommercePriceChangeLogPO eCommercePriceChangePO = new ECommercePriceChangeLogPO();
                eCommercePriceChangePO.setSkuId(bo.getSkuId());
                eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
                Calendar calendar1 = Calendar.getInstance();
                calendar1.add(5, 0 - modelBy.getDate());
                Date updateTime = calendar1.getTime();
                eCommercePriceChangePO.setUpdateTime(updateTime);
                eCommercePriceChangePO.setChangePriceType(warnType);
                List poList = this.eCommercePriceChangeLogMapper.queryCountNew(eCommercePriceChangePO);
                if (!CollectionUtils.isEmpty((Collection)poList)) {
                    BigDecimal sum = poList.stream().map(ECommercePriceChangeLogPO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
                    oldPrice = sum.add(((ECommercePriceChangeLogPO)poList.get(0)).getOldPrice()).divide(new BigDecimal(poList.size()).add(new BigDecimal(1)));
                }
                if (newPrice.compareTo(oldPrice) < 0 && (downPrevent = oldPrice.subtract(newPrice).divide(oldPrice, 4, 4)).compareTo(modelBy.getDownPercentage().divide(new BigDecimal("100"))) > -1) {
                    uccPricePreventPO.setPercentage(downPrevent);
                    uccPricePreventPOS.add(uccPricePreventPO);
                    flag = true;
                }
                if (newPrice.compareTo(oldPrice) > 0) {
                    BigDecimal upPrevent = newPrice.subtract(oldPrice).divide(oldPrice, 4, 4);
                    if (upPrevent.compareTo(modelBy.getUpperPercentage().divide(new BigDecimal("100"))) > -1) {
                        uccPricePreventPO.setPercentage(upPrevent);
                        uccPricePreventPOS.add(uccPricePreventPO);
                        flag = true;
                    }
                    if (upPrevent.compareTo(modelBy.getOffShelfPercentage().divide(new BigDecimal("100"))) > -1) {
                        uccPricePreventPO.setIsDown(Integer.valueOf(1));
                        commoditys.add(bo.getCommodityId());
                        skuIdPrices.add(bo.getSkuId());
                    }
                }
            }
        }
        if (newPrice.compareTo(oldPrice) != 0) {
            ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
            eCommercePriceChangePO.setSkuId(bo.getSkuId());
            eCommercePriceChangePO.setSupplierShopId(bo.getSupplierShopId());
            eCommercePriceChangePO.setChangePriceType(warnType);
            List eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
            if (CollectionUtils.isEmpty((Collection)eCommercePriceChangePOS)) {
                eCommercePriceChangePO.setId(Long.valueOf(this.coefficientSequence.nextId()));
                eCommercePriceChangePO.setPrice(newPrice);
                eCommercePriceChangePO.setCurrentPrice(newPrice);
                eCommercePriceChangePO.setOldPrice(oldPrice);
                eCommercePriceChangePO.setAveragePrice(newPrice);
                eCommercePriceChangePO.setUpdateTime(new Date());
                eCommercePriceChangePO.setFrequency(Integer.valueOf(1));
                eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                eCommercePriceChangePOList.add(eCommercePriceChangePO);
            } else {
                eCommercePriceChangePO = (ECommercePriceChangePO)eCommercePriceChangePOS.get(0);
                eCommercePriceChangePO.setPrice(newPrice);
                eCommercePriceChangePO.setCurrentPrice(newPrice);
                eCommercePriceChangePO.setOldPrice(oldPrice);
                BigDecimal avgprice = eCommercePriceChangePO.getAveragePrice().add(bo.getOrgSalePrice()).divide(new BigDecimal(2));
                eCommercePriceChangePO.setAveragePrice(avgprice);
                eCommercePriceChangePO.setUpdateTime(new Date());
                eCommercePriceChangePO.setFrequency(Integer.valueOf(eCommercePriceChangePO.getFrequency() + 1));
                eCommercePriceChangePO.setIsDown(uccPricePreventPO.getIsDown());
                eCommercePriceChangePO.setFloatingRate(uccPricePreventPO.getPercentage());
                eCommercePriceChangePO.setExtSkuId(bo.getExtSkuId());
                this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
            eCommercePriceChangeLogPO.setBatchId(Long.valueOf(this.coefficientSequence.nextId()));
            eCommercePriceChangeLogPO.setId(Long.valueOf(this.coefficientSequence.nextId()));
            eCommercePriceChangeLogPO.setOnShelveTime(bo.getOnShelveTime());
            eCommercePriceChangeLogPO.setMarketPrice(MoneyUtils.haoToYuan((Long)bo.getMarketPrice()));
            eCommercePriceChangeLogPO.setOldPrice(oldPrice);
            if (eCommercePriceChangeLogPO.getSkuId() != null && skuStandardPricePOMap.containsKey(eCommercePriceChangeLogPO.getSkuId())) {
                eCommercePriceChangeLogPO.setStandardPrice(skuStandardPricePOMap.get(eCommercePriceChangeLogPO.getSkuId()).getStandardPrice());
                eCommercePriceChangeLogPO.setFloatingRatio(skuStandardPricePOMap.get(eCommercePriceChangeLogPO.getSkuId()).getUpRatio());
            }
            eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
        }
    }
}

