/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuStandardPriceMapper;
import com.tydic.commodity.estore.ability.bo.SkuPriUpInfoBo;
import com.tydic.commodity.estore.atom.api.UccEstoreDictionaryAtomService;
import com.tydic.commodity.estore.busi.api.UccPriUpDetailsQryBusiService;
import com.tydic.commodity.estore.busi.bo.UccPriUpDetailsQryReqBO;
import com.tydic.commodity.estore.busi.bo.UccPriUpDetailsQryRspBO;
import com.tydic.commodity.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.po.SupplierBusiPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPriceLogPo;
import com.tydic.commodity.po.UccSkuStandardPricePO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccPriUpDetailsQryBusiServiceImpl
implements UccPriUpDetailsQryBusiService {
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPriUpDetailsQryBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccBaseDictionaryAtomService UccBaseDictionaryAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccSkuStandardPriceMapper uccSkuStandardPriceMapper;
    @Autowired
    private UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService;

    @Override
    public UccPriUpDetailsQryRspBO qryPriUpDetails(UccPriUpDetailsQryReqBO reqBO) {
        UccPriUpDetailsQryRspBO rspBO = new UccPriUpDetailsQryRspBO();
        if (reqBO.getSkuId() == null && StringUtils.isEmpty((String)reqBO.getExtSkuId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1id\u548c\u5916\u90e8\u5355\u54c1id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new BusinessException("8888", "\u8bf7\u8f93\u5165\u4f9b\u5e94\u5546ID");
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        ArrayList<SkuPriUpInfoBo> skuPriUpInfoBos = new ArrayList<SkuPriUpInfoBo>();
        Map<String, String> uccPriceWarnTypeDicMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("UCC_PRICE_WARN_TYPE_DIC");
        try {
            List eCommercePriceChangeLogPOS;
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)eCommercePriceChangeLogPO);
            if ("1".equals(reqBO.getIgnoreStandard())) {
                eCommercePriceChangeLogPO.setStandardFlag("1");
            }
            if ((eCommercePriceChangeLogPOS = this.eCommercePriceChangeLogMapper.selectECommercePriceChangeLogPOs(eCommercePriceChangeLogPO, page)) != null && eCommercePriceChangeLogPOS.size() > 0) {
                for (ECommercePriceChangeLogPO eCommercePriceChangeLogPO1 : eCommercePriceChangeLogPOS) {
                    SkuPriUpInfoBo skuPriUpInfoBo;
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    if (eCommercePriceChangeLogPO1.getSkuId() == null) {
                        uccSkuPo.setVendorId(reqBO.getSupplierId());
                        uccSkuPo.setExtSkuId(eCommercePriceChangeLogPO1.getExtSkuId());
                    } else {
                        uccSkuPo.setSkuId(eCommercePriceChangeLogPO1.getSkuId());
                    }
                    uccSkuPo.setSupplierShopId(eCommercePriceChangeLogPO1.getSupplierShopId());
                    List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
                    if (uccSkuPoList != null && uccSkuPoList.size() == 1) {
                        UccCommodityTypePo uccCommodityTypePo;
                        skuPriUpInfoBo = new SkuPriUpInfoBo();
                        UccSkuPo uccSkuPo1 = (UccSkuPo)uccSkuPoList.get(0);
                        BeanUtils.copyProperties((Object)uccSkuPo1, (Object)skuPriUpInfoBo);
                        skuPriUpInfoBo.setId(eCommercePriceChangeLogPO1.getId());
                        skuPriUpInfoBo.setExtSkuCode(uccSkuPo1.getExtSkuId());
                        skuPriUpInfoBo.setBeforePrice(eCommercePriceChangeLogPO1.getOldPrice());
                        skuPriUpInfoBo.setFloatingRate(eCommercePriceChangeLogPO1.getFloatingRate());
                        UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(uccSkuPo1.getCommodityId());
                        skuPriUpInfoBo.setCommodityCode(uccCommodityPo.getCommodityCode());
                        skuPriUpInfoBo.setSupplierId(reqBO.getSupplierId());
                        skuPriUpInfoBo.setCommodityName(uccCommodityPo.getCommodityName());
                        skuPriUpInfoBo.setAveragePrice(eCommercePriceChangeLogPO1.getAveragePrice());
                        skuPriUpInfoBo.setFloatingRate(eCommercePriceChangeLogPO1.getFloatingRate());
                        skuPriUpInfoBo.setFrequency(Integer.valueOf(eCommercePriceChangeLogPO1.getFrequency() == null ? 0 : eCommercePriceChangeLogPO1.getFrequency()));
                        skuPriUpInfoBo.setPrice(eCommercePriceChangeLogPO1.getPrice());
                        if (eCommercePriceChangeLogPO1.getUpdateTime() != null) {
                            skuPriUpInfoBo.setUpdateTime(DateUtils.dateToStr((Date)eCommercePriceChangeLogPO1.getUpdateTime()));
                        }
                        if (eCommercePriceChangeLogPO1.getOnShelveTime() != null) {
                            skuPriUpInfoBo.setOnShelveTime(DateUtils.dateToStr((Date)eCommercePriceChangeLogPO1.getOnShelveTime()));
                        }
                        BigDecimal nowAgreementPrice = eCommercePriceChangeLogPO1.getPrice();
                        BigDecimal nowMarketPrice = eCommercePriceChangeLogPO1.getMarketPrice();
                        if (nowAgreementPrice != null && nowMarketPrice != null && nowMarketPrice.compareTo(BigDecimal.ZERO) != 0) {
                            BigDecimal nowDiscount = nowAgreementPrice.divide(nowMarketPrice, 2, 1);
                            skuPriUpInfoBo.setDiscount(nowDiscount);
                        }
                        Long skuId = uccSkuPo1.getSkuId();
                        BigDecimal oldestDiscount = null;
                        BigDecimal oldestMarketPrice = null;
                        BigDecimal oldestAgreementPrice = null;
                        if (skuId != null) {
                            UccSkuPriceLogPo uccSkuPriceLogPo = new UccSkuPriceLogPo();
                            uccSkuPriceLogPo.setSkuId(skuId);
                            uccSkuPriceLogPo.setOrderBy("CREATE_TIME");
                            List uccSkuPriceLogPos = this.uccSkuPriceLogMapper.conditiQrySkuLog(uccSkuPriceLogPo);
                            if (uccSkuPriceLogPos != null && uccSkuPriceLogPos.size() > 0) {
                                UccSkuPriceLogPo uccSkuPriceLogPo1 = (UccSkuPriceLogPo)uccSkuPriceLogPos.get(0);
                                Long marketPrice = uccSkuPriceLogPo1.getMarketPrice();
                                Long agreementPrice = uccSkuPriceLogPo1.getAgreementPrice();
                                oldestMarketPrice = MoneyUtils.haoToYuan((Long)marketPrice);
                                oldestAgreementPrice = MoneyUtils.haoToYuan((Long)agreementPrice);
                                oldestDiscount = oldestAgreementPrice.divide(oldestMarketPrice, 4, 1);
                            }
                        }
                        skuPriUpInfoBo.setStandardPrice(eCommercePriceChangeLogPO1.getStandardPrice());
                        skuPriUpInfoBo.setMarketPrice(eCommercePriceChangeLogPO1.getMarketPrice());
                        if (nowAgreementPrice != null && eCommercePriceChangeLogPO1.getStandardPrice() != null && eCommercePriceChangeLogPO1.getStandardPrice().compareTo(BigDecimal.ZERO) != 0) {
                            skuPriUpInfoBo.setFloatingRatio(nowAgreementPrice.subtract(eCommercePriceChangeLogPO1.getStandardPrice()).divide(eCommercePriceChangeLogPO1.getStandardPrice(), 2, 4));
                        }
                        skuPriUpInfoBo.setOldestMarketPrice(oldestMarketPrice);
                        skuPriUpInfoBo.setOldestDiscount(oldestDiscount);
                        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(eCommercePriceChangeLogPO1.getSupplierShopId());
                        if (supplierBusiPo != null) {
                            skuPriUpInfoBo.setSupplierName(supplierBusiPo.getSupplierName());
                            skuPriUpInfoBo.setSupplierId(supplierBusiPo.getSupplierId());
                        }
                        if (uccSkuPo1.getCommodityTypeId() != null && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(uccSkuPo1.getCommodityTypeId())) != null) {
                            skuPriUpInfoBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
                        }
                        skuPriUpInfoBo.setIsDown(eCommercePriceChangeLogPO1.getIsDown());
                        skuPriUpInfoBo.setIsDownDesc(eCommercePriceChangeLogPO1.getIsDown() == 1 ? "\u662f" : "\u5426");
                        skuPriUpInfoBo.setChangePriceType(eCommercePriceChangeLogPO1.getChangePriceType());
                        if (skuPriUpInfoBo.getChangePriceType() != null) {
                            skuPriUpInfoBo.setChangePriceTypeStr(uccPriceWarnTypeDicMap.get(skuPriUpInfoBo.getChangePriceType().toString()));
                        } else {
                            skuPriUpInfoBo.setChangePriceType(UccConstants.WarnType.XY);
                            skuPriUpInfoBo.setChangePriceTypeStr("\u534f\u8bae\u4ef7");
                        }
                        skuPriUpInfoBos.add(skuPriUpInfoBo);
                        continue;
                    }
                    skuPriUpInfoBo = new SkuPriUpInfoBo();
                    skuPriUpInfoBo.setId(eCommercePriceChangeLogPO1.getId());
                    UccSkuStandardPricePO uccSkuStandardPricePO = new UccSkuStandardPricePO();
                    uccSkuStandardPricePO.setExtSkuId(eCommercePriceChangeLogPO1.getExtSkuId());
                    uccSkuStandardPricePO.setVendorId(eCommercePriceChangeLogPO1.getSupplierShopId());
                    List uccSkuStandardPricePOS = this.uccSkuStandardPriceMapper.getList(uccSkuStandardPricePO);
                    if (!CollectionUtils.isEmpty((Collection)uccSkuStandardPricePOS)) {
                        skuPriUpInfoBo.setSkuName(((UccSkuStandardPricePO)uccSkuStandardPricePOS.get(0)).getSkuName());
                        skuPriUpInfoBo.setCommodityName(((UccSkuStandardPricePO)uccSkuStandardPricePOS.get(0)).getSkuName());
                    }
                    skuPriUpInfoBo.setExtSkuCode(eCommercePriceChangeLogPO1.getExtSkuId());
                    skuPriUpInfoBo.setExtSkuId(eCommercePriceChangeLogPO1.getExtSkuId());
                    skuPriUpInfoBo.setSupplierShopId(eCommercePriceChangeLogPO1.getSupplierShopId());
                    skuPriUpInfoBo.setSupplierId(eCommercePriceChangeLogPO1.getSupplierShopId());
                    SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(eCommercePriceChangeLogPO1.getSupplierShopId());
                    if (supplierBusiPo != null) {
                        skuPriUpInfoBo.setSupplierName(supplierBusiPo.getSupplierName());
                        skuPriUpInfoBo.setShopName(supplierBusiPo.getSupplierName());
                    }
                    skuPriUpInfoBo.setMarketPrice(eCommercePriceChangeLogPO1.getMarketPrice());
                    BigDecimal nowAgreementPrice = eCommercePriceChangeLogPO1.getPrice();
                    BigDecimal nowMarketPrice = eCommercePriceChangeLogPO1.getMarketPrice();
                    if (nowAgreementPrice != null && nowMarketPrice != null && nowMarketPrice.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal nowDiscount = nowAgreementPrice.divide(nowMarketPrice, 2, 1);
                        skuPriUpInfoBo.setDiscount(nowDiscount);
                    }
                    skuPriUpInfoBo.setStandardPrice(eCommercePriceChangeLogPO1.getStandardPrice());
                    skuPriUpInfoBo.setPrice(nowAgreementPrice);
                    if (nowAgreementPrice != null && eCommercePriceChangeLogPO1.getStandardPrice() != null && eCommercePriceChangeLogPO1.getStandardPrice().compareTo(BigDecimal.ZERO) != 0) {
                        skuPriUpInfoBo.setFloatingRatio(nowAgreementPrice.subtract(eCommercePriceChangeLogPO1.getStandardPrice()).divide(eCommercePriceChangeLogPO1.getStandardPrice(), 2, 4));
                    }
                    if (eCommercePriceChangeLogPO1.getUpdateTime() != null) {
                        skuPriUpInfoBo.setUpdateTime(DateUtils.dateToStr((Date)eCommercePriceChangeLogPO1.getUpdateTime()));
                    }
                    skuPriUpInfoBo.setIsDown(eCommercePriceChangeLogPO1.getIsDown());
                    skuPriUpInfoBo.setIsDownDesc(eCommercePriceChangeLogPO1.getIsDown() == 1 ? "\u662f" : "\u5426");
                    skuPriUpInfoBo.setChangePriceType(eCommercePriceChangeLogPO1.getChangePriceType());
                    if (skuPriUpInfoBo.getChangePriceType() != null) {
                        skuPriUpInfoBo.setChangePriceTypeStr(uccPriceWarnTypeDicMap.get(skuPriUpInfoBo.getChangePriceType().toString()));
                    } else {
                        skuPriUpInfoBo.setChangePriceType(UccConstants.WarnType.XY);
                        skuPriUpInfoBo.setChangePriceTypeStr("\u534f\u8bae\u4ef7");
                    }
                    skuPriUpInfoBos.add(skuPriUpInfoBo);
                }
            }
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(skuPriUpInfoBos)) {
            List<SkuPriUpInfoBo> collect = skuPriUpInfoBos.stream().filter(e -> UccConstants.WarnType.XY.equals(e.getChangePriceType())).collect(Collectors.toList());
            Map<Object, Object> skuPriUpInfoBoMap = new HashMap(16);
            if (!CollectionUtils.isEmpty(collect)) {
                this.getOldPrice(collect);
                skuPriUpInfoBoMap = collect.stream().collect(Collectors.groupingBy(SkuPriUpInfoBo::getId));
            }
            int index = 1;
            for (SkuPriUpInfoBo skuPriUpInfoBo : skuPriUpInfoBos) {
                if (MapUtils.isNotEmpty(skuPriUpInfoBoMap) && !CollectionUtils.isEmpty((Collection)((Collection)skuPriUpInfoBoMap.get(skuPriUpInfoBo.getId())))) {
                    skuPriUpInfoBo.setBeforePrice(((SkuPriUpInfoBo)((List)skuPriUpInfoBoMap.get(skuPriUpInfoBo.getId())).get(0)).getBeforePrice());
                }
                skuPriUpInfoBo.setSerialNumber(Integer.valueOf(index));
                ++index;
            }
        }
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setRows(skuPriUpInfoBos);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    private void getOldPrice(List<SkuPriUpInfoBo> skuPriUpInfoBos) {
        if (!CollectionUtils.isEmpty(skuPriUpInfoBos)) {
            for (int i = skuPriUpInfoBos.size() - 1; i >= 0; --i) {
                if (i == skuPriUpInfoBos.size() - 1) {
                    if (skuPriUpInfoBos.get(i).getSkuId() == null) continue;
                    UccSkuPriceLogPo uccSkuPriceLogPo = new UccSkuPriceLogPo();
                    uccSkuPriceLogPo.setSkuId(skuPriUpInfoBos.get(i).getSkuId());
                    uccSkuPriceLogPo.setOrderBy("UPDATE_TIME,BATCH_ID");
                    List uccSkuPriceLogPos = this.uccSkuPriceLogMapper.conditiQrySkuLog(uccSkuPriceLogPo);
                    if (uccSkuPriceLogPos == null || uccSkuPriceLogPos.size() <= 0) continue;
                    UccSkuPriceLogPo uccSkuPriceLogPo1 = (UccSkuPriceLogPo)uccSkuPriceLogPos.get(0);
                    Long agreementPrice = uccSkuPriceLogPo1.getAgreementPrice();
                    skuPriUpInfoBos.get(i).setBeforePrice(MoneyUtils.haoToYuan((Long)agreementPrice));
                    continue;
                }
                skuPriUpInfoBos.get(i).setBeforePrice(skuPriUpInfoBos.get(i + 1).getPrice());
            }
        }
    }
}

