/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.PCodeConstant;
import com.tydic.commodity.dao.UccMallPriceRangeExtMapper;
import com.tydic.commodity.estore.ability.api.UccMallPriceRangeExtService;
import com.tydic.commodity.estore.ability.bo.DycMallPriceRangeRspBO;
import com.tydic.commodity.estore.ability.bo.MallPriceExtBO;
import com.tydic.commodity.estore.ability.bo.UccMallPriceRangeExtReqBO;
import com.tydic.commodity.estore.ability.bo.UccMallPriceRangeListQueryRspBO;
import com.tydic.commodity.estore.ability.bo.UccMallPriceRangeQueryListInfoBO;
import com.tydic.commodity.estore.ability.bo.UccMallPriceRangeTypeQueryListBo;
import com.tydic.commodity.estore.ability.bo.UccMallPriceRangeTypeQueryListReqBO;
import com.tydic.commodity.estore.atom.api.UccEstoreDictionaryAtomService;
import com.tydic.commodity.po.UccMallPriceRangeExtBo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.estore.ability.api.UccMallPriceRangeExtService"})
public class UccMallPriceRangeExtServiceImpl
implements UccMallPriceRangeExtService {
    private static final Logger log = LoggerFactory.getLogger(UccMallPriceRangeExtServiceImpl.class);
    @Autowired
    private UccMallPriceRangeExtMapper uccMallPriceRangeExtMapper;
    @Autowired
    private UccEstoreDictionaryAtomService uccEstoreDictionaryAtomService;

    @PostMapping(value={"selectMallPriceRangeList"})
    public UccMallPriceRangeListQueryRspBO selectMallPriceRangeList(@RequestBody UccMallPriceRangeExtReqBO reqBO) {
        log.info("\u5f00\u59cb\u67e5\u8be2\u5217\u8868");
        UccMallPriceRangeListQueryRspBO rspBo = new UccMallPriceRangeListQueryRspBO();
        List list = this.uccMallPriceRangeExtMapper.selectMallPriceRangeList(reqBO.getRangeType(), reqBO.getCatalogCode(), reqBO.getCatalogName(), reqBO.getCommodityTypeName());
        log.info("\u67e5\u8be2\u6210\u529f");
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<UccMallPriceRangeQueryListInfoBO> rows = new ArrayList<UccMallPriceRangeQueryListInfoBO>();
        UccMallPriceRangeQueryListInfoBO uccMallPriceRangeExtRspBO = null;
        for (UccMallPriceRangeExtBo uccMallPriceRangeExtBo : list) {
            uccMallPriceRangeExtRspBO = new UccMallPriceRangeQueryListInfoBO();
            BeanUtils.copyProperties((Object)uccMallPriceRangeExtBo, (Object)uccMallPriceRangeExtRspBO);
            rows.add(uccMallPriceRangeExtRspBO);
            typeIds.add(uccMallPriceRangeExtBo.getCommodityTypeId());
        }
        if (!CollectionUtils.isEmpty(typeIds)) {
            Map<String, String> uccPriceWarnTypeDicMap = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap(PCodeConstant.UCC_PRICE_WARN_TYPE_DIC.getCode());
            List list1 = this.uccMallPriceRangeExtMapper.selectMallPriceRangeListByTypeId(typeIds, reqBO.getRangeType());
            for (UccMallPriceRangeQueryListInfoBO row : rows) {
                ArrayList<MallPriceExtBO> objectArrayList = new ArrayList<MallPriceExtBO>();
                if (MapUtil.isNotEmpty(uccPriceWarnTypeDicMap) && row.getRangeType() != null) {
                    row.setRangeTypeDesc(uccPriceWarnTypeDicMap.get(row.getRangeType().toString()));
                }
                for (UccMallPriceRangeExtBo uccMallPriceRangeExtBo : list1) {
                    if (!row.getCommodityTypeId().equals(uccMallPriceRangeExtBo.getCommodityTypeId()) || !uccMallPriceRangeExtBo.getRangeType().equals(row.getRangeType())) continue;
                    MallPriceExtBO mallPriceExtBO = new MallPriceExtBO();
                    BeanUtils.copyProperties((Object)uccMallPriceRangeExtBo, (Object)mallPriceExtBO);
                    objectArrayList.add(mallPriceExtBO);
                    row.setList(objectArrayList);
                }
            }
        }
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"selectMallTypeList"})
    public UccMallPriceRangeTypeQueryListBo selectMallTypeList(@RequestBody UccMallPriceRangeTypeQueryListReqBO reqBO) {
        log.info("\u5f00\u59cb\u67e5\u8be2\u5217\u8868");
        UccMallPriceRangeTypeQueryListBo rspBO = new UccMallPriceRangeTypeQueryListBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccMallPriceRangeExtBo qryBo = new UccMallPriceRangeExtBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryBo);
        List list = this.uccMallPriceRangeExtMapper.selectMallTypeList(qryBo, page);
        log.info("\u67e5\u8be2\u6210\u529f");
        DycMallPriceRangeRspBO dycMallPriceRangeRspBO = null;
        ArrayList<DycMallPriceRangeRspBO> rows = new ArrayList<DycMallPriceRangeRspBO>();
        log.info("\u5c01\u88c5\u8fd4\u56de");
        for (UccMallPriceRangeExtBo uccMallPriceRangeExtBo : list) {
            dycMallPriceRangeRspBO = new DycMallPriceRangeRspBO();
            BeanUtils.copyProperties((Object)uccMallPriceRangeExtBo, (Object)dycMallPriceRangeRspBO);
            System.out.println(dycMallPriceRangeRspBO.toString());
            rows.add(dycMallPriceRangeRspBO);
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalCount());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

