/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccRelCatalogBrandVendorMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.estore.busi.api.MaterialBrandRelationBO;
import com.tydic.commodity.estore.busi.api.UccMaterialBrandRelationService;
import com.tydic.commodity.estore.busi.bo.UccExtSkuAddPriceReqBO;
import com.tydic.commodity.estore.busi.bo.UccExtSkuAddPriceRspBO;
import com.tydic.commodity.estore.utils.ExcelUtils;
import com.tydic.commodity.estore.utils.HttpUtil;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccRelCatalogBrandVendorPO;
import com.tydic.commodity.po.UccVendorPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UccMaterialBrandRelationServiceImpl
implements UccMaterialBrandRelationService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialBrandRelationServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccRelCatalogBrandVendorMapper uccRelCatalogBrandVendorMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    private static final String importType = "UCC_MATERIAL_BRAND_RELATION";

    @Override
    public UccExtSkuAddPriceRspBO importMaterialBrandRelation(UccExtSkuAddPriceReqBO reqBO) {
        UccExtSkuAddPriceRspBO rspBO = new UccExtSkuAddPriceRspBO();
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            String dateString = DateUtils.dateToStrAsFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + dateString + "ccExtSkuAddPrice.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getImportUrl(), file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
                this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
            log.info("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^datadata^{}^^^titletitle--^{}", (Object)JSON.toJSONString((Object)data), (Object)JSON.toJSONString(title));
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.validateTitle(title);
        List<MaterialBrandRelationBO> materialBrandRelationBOS = this.objectData(data);
        if (ObjectUtils.isEmpty(materialBrandRelationBOS)) {
            throw new BusinessException("8888", "\u6a21\u677f\u89e3\u6790\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List<UccRelCatalogBrandVendorPO> insertDatas = this.checkImport(materialBrandRelationBOS, reqBO);
        log.info("###################insertDatainsertData--{}###--------------^^^^^^^^materialBrandRelationBOSmaterialBrandRelationBOS--{}", (Object)JSON.toJSONString(insertDatas), (Object)JSON.toJSONString(materialBrandRelationBOS));
        if (!ObjectUtils.isEmpty(insertDatas)) {
            this.uccRelCatalogBrandVendorMapper.insertBatch(insertDatas);
        }
        Long sucessImportCounts = insertDatas.size();
        Long failedImportCounts = (long)materialBrandRelationBOS.size() - sucessImportCounts;
        List<Map<String, Object>> exportData = this.exportImportResults(materialBrandRelationBOS);
        log.info("------\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString(exportData));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(exportData, reqBO, sucessImportCounts, failedImportCounts);
        rspBO.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        rspBO.setImpType(importType);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, UccExtSkuAddPriceReqBO reqBO, Long sucessImportCounts, Long failedImportCounts) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType(importType);
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }

    private List<Map<String, Object>> exportImportResults(List<MaterialBrandRelationBO> materialBrandRelationBOS) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (MaterialBrandRelationBO materialBrandRelationBO : materialBrandRelationBOS) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *", materialBrandRelationBO.getCatalogCode() != null ? materialBrandRelationBO.getCatalogCode() : "");
            item.put("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *", materialBrandRelationBO.getCatalogName() != null ? materialBrandRelationBO.getCatalogName() : "");
            item.put("\u54c1\u724c\u540d\u79f0 *", materialBrandRelationBO.getBrandName() != null ? materialBrandRelationBO.getBrandName() : "");
            item.put("\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *", materialBrandRelationBO.getBelongOrg() != null ? materialBrandRelationBO.getBelongOrg() : "");
            item.put("\u5173\u8054\u4f9b\u5e94\u5546 *", materialBrandRelationBO.getVendorName() != null ? materialBrandRelationBO.getVendorName() : "");
            item.put("\u5173\u8054\u72b6\u6001 *", materialBrandRelationBO.getStatusStr() != null ? materialBrandRelationBO.getStatusStr() : "");
            item.put("\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09", materialBrandRelationBO.getDiscount() != null ? materialBrandRelationBO.getDiscount() : "");
            if (materialBrandRelationBO.getImpResult() != null && materialBrandRelationBO.getImpResult() == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (materialBrandRelationBO.getImpResult() != null && materialBrandRelationBO.getImpResult() == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", materialBrandRelationBO.getImpRemark());
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    public List<UccRelCatalogBrandVendorPO> checkImport(List<MaterialBrandRelationBO> uccExtSkuAddPriceItmePOS, UccExtSkuAddPriceReqBO reqBO) {
        ArrayList<UccRelCatalogBrandVendorPO> insertList = new ArrayList<UccRelCatalogBrandVendorPO>();
        for (MaterialBrandRelationBO materialBrandRelationBO : uccExtSkuAddPriceItmePOS) {
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getCatalogCode())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getCatalogName())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getBrandName())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getBelongOrg())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getVendorName())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u5173\u8054\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (ObjectUtils.isEmpty((Object)materialBrandRelationBO.getStatusStr())) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u5173\u8054\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
                continue;
            }
            if (materialBrandRelationBO.getImpResult() != 0) continue;
            UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
            uccEMdmCatalogPO.setCatalogCode(materialBrandRelationBO.getCatalogCode());
            uccEMdmCatalogPO.setCatalogName(materialBrandRelationBO.getCatalogName());
            uccEMdmCatalogPO.setCatalogLevel(Integer.valueOf(3));
            uccEMdmCatalogPO.setIsDelete(Integer.valueOf(0));
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
            if (ObjectUtils.isEmpty((Object)uccEMdmCatalogPOS)) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u7269\u6599\u4e0d\u5b58\u5728");
                continue;
            }
            if (1 == ((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getFreezeFlag()) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark("\u8be5\u7269\u6599\u5df2\u7ecf\u505c\u7528");
                continue;
            }
            UccRelCatalogBrandVendorPO uccRelCatalogBrandVendorPO = new UccRelCatalogBrandVendorPO();
            uccRelCatalogBrandVendorPO.setCatalogId(((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getCatalogId());
            uccRelCatalogBrandVendorPO.setBrandName(materialBrandRelationBO.getBrandName());
            uccRelCatalogBrandVendorPO.setBelongOrg(materialBrandRelationBO.getBelongOrg());
            uccRelCatalogBrandVendorPO.setVendorName(materialBrandRelationBO.getVendorName());
            uccRelCatalogBrandVendorPO.setUpdateOperId(reqBO.getUsername());
            uccRelCatalogBrandVendorPO.setUpdateOperName(reqBO.getName());
            int i = this.uccRelCatalogBrandVendorMapper.selectCount(uccRelCatalogBrandVendorPO);
            if (i > 0) {
                uccRelCatalogBrandVendorPO.setStatus(materialBrandRelationBO.getStatus());
                if (!ObjectUtils.isEmpty((Object)materialBrandRelationBO.getDiscount())) {
                    try {
                        uccRelCatalogBrandVendorPO.setDiscount(new BigDecimal(materialBrandRelationBO.getDiscount()));
                    }
                    catch (Exception e) {
                        materialBrandRelationBO.setImpResult(1);
                        materialBrandRelationBO.setImpRemark("\u6298\u6263\u7387\u53ea\u80fd\u662f\u6570\u5b57");
                        continue;
                    }
                }
                this.uccRelCatalogBrandVendorMapper.updateDiscount(uccRelCatalogBrandVendorPO);
                continue;
            }
            UccVendorPo uccVendorPo = new UccVendorPo();
            uccVendorPo.setVendorName(materialBrandRelationBO.getVendorName());
            uccVendorPo.setSupplierType(Integer.valueOf(1));
            List uccVendorPos = this.uccVendorMapper.queryVerdor(uccVendorPo);
            if (ObjectUtils.isEmpty((Object)uccVendorPos)) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark(materialBrandRelationBO.getVendorName() + ",\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
                continue;
            }
            UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
            uccBrandDealPO.setBrandName(materialBrandRelationBO.getBrandName());
            uccBrandDealPO.setBelongOrg(materialBrandRelationBO.getBelongOrg());
            uccBrandDealPO.setBrandType(Integer.valueOf(1));
            uccBrandDealPO.setBrandStatus(Integer.valueOf(1));
            uccBrandDealPO.setAppRanges(Arrays.asList(0, 1));
            List uccBrandDealPOS = this.uccBrandDealMapper.selectBy(uccBrandDealPO);
            if (ObjectUtils.isEmpty((Object)uccBrandDealPOS)) {
                materialBrandRelationBO.setImpResult(1);
                materialBrandRelationBO.setImpRemark(materialBrandRelationBO.getBrandName() + ",\u54c1\u724c\u4e0d\u5b58\u5728");
                continue;
            }
            UccRelCatalogBrandVendorPO vendorPO = new UccRelCatalogBrandVendorPO();
            vendorPO.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
            vendorPO.setVendorId(((UccVendorPo)uccVendorPos.get(0)).getVendorId());
            vendorPO.setBrandId(((UccBrandDealPO)uccBrandDealPOS.get(0)).getBrandId());
            vendorPO.setCatalogId(((UccEMdmCatalogPO)uccEMdmCatalogPOS.get(0)).getCatalogId());
            vendorPO.setStatus(materialBrandRelationBO.getStatus());
            vendorPO.setCreateOperId(reqBO.getUsername());
            vendorPO.setCreateOperName(reqBO.getName());
            vendorPO.setCreateTime(new Date());
            vendorPO.setUpdateOperId(reqBO.getUsername());
            vendorPO.setUpdateOperName(reqBO.getName());
            vendorPO.setUpdateTime(new Date());
            vendorPO.setRemark("\u5bfc\u5165");
            if (!ObjectUtils.isEmpty((Object)materialBrandRelationBO.getDiscount())) {
                try {
                    vendorPO.setDiscount(new BigDecimal(materialBrandRelationBO.getDiscount()));
                }
                catch (Exception e) {
                    materialBrandRelationBO.setImpResult(1);
                    materialBrandRelationBO.setImpRemark("\u6298\u6263\u7387\u53ea\u80fd\u662f\u6570\u5b57");
                    continue;
                }
            }
            vendorPO.setDiscountFlag(Integer.valueOf(0));
            insertList.add(vendorPO);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<UccRelCatalogBrandVendorPO> newVendorPOs = new ArrayList<UccRelCatalogBrandVendorPO>();
        Iterator iterator = insertList.iterator();
        while (iterator.hasNext()) {
            UccRelCatalogBrandVendorPO po = (UccRelCatalogBrandVendorPO)iterator.next();
            String key = "" + po.getCatalogId() + po.getBrandId() + po.getBelongOrg() + po.getVendorId();
            if (treeSet.contains(key)) {
                iterator.remove();
                continue;
            }
            treeSet.add(key);
            newVendorPOs.add(po);
        }
        return newVendorPOs;
    }

    private String deWeight(List<UccRelCatalogBrandVendorPO> insertList) {
        StringBuilder stringBuffer = new StringBuilder();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < insertList.size(); ++i) {
            String key = "" + insertList.get(i).getCatalogId() + insertList.get(i).getBrandId() + insertList.get(i).getBelongOrg() + insertList.get(i).getVendorId();
            if (treeSet.add(key.trim())) continue;
            stringBuffer.append("\u7b2c").append(i + 1).append("\u884c\u6570\u636e\u5b58\u5728\u91cd\u590d\uff01\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u63d0\u4ea4");
            break;
        }
        return stringBuffer.toString();
    }

    List<MaterialBrandRelationBO> objectData(JSONObject data) {
        ArrayList<MaterialBrandRelationBO> materialBrandRelationBOList = new ArrayList<MaterialBrandRelationBO>();
        JSONArray excelJSON = data.getJSONArray("excelJSON");
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            MaterialBrandRelationBO materialBrandRelationBO = new MaterialBrandRelationBO();
            JSONObject next = (JSONObject)iterator.next();
            materialBrandRelationBO.setImpResult(0);
            String catalogCode = next.getString("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *");
            materialBrandRelationBO.setCatalogCode(catalogCode);
            String catalogName = next.getString("\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *");
            materialBrandRelationBO.setCatalogName(catalogName);
            String brandName = next.getString("\u54c1\u724c\u540d\u79f0 *");
            materialBrandRelationBO.setBrandName(brandName);
            String belongOrg = next.getString("\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *");
            materialBrandRelationBO.setBelongOrg(belongOrg);
            String vendorName = next.getString("\u5173\u8054\u4f9b\u5e94\u5546 *");
            materialBrandRelationBO.setVendorName(vendorName);
            String statusStr = next.getString("\u5173\u8054\u72b6\u6001 *");
            materialBrandRelationBO.setStatusStr(statusStr);
            String discount = null;
            if (next != null && next.getString("\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09") != null) {
                discount = next.getString("\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09").replace(",", "");
            }
            materialBrandRelationBO.setDiscount(discount);
            materialBrandRelationBOList.add(materialBrandRelationBO);
        }
        return materialBrandRelationBOList;
    }

    private void validateTitle(List<String> title) {
        String titleTemplate = "\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u7f16\u7801 *|\u5c0f\u7c7b\u7269\u8d44\u5206\u7c7b\u540d\u79f0 *|\u54c1\u724c\u540d\u79f0 *|\u54c1\u724c\u6240\u5c5e\u4f01\u4e1a *|\u5173\u8054\u4f9b\u5e94\u5546 *|\u5173\u8054\u72b6\u6001 *|\u6298\u6263\u7387\u6700\u5927\u9650\u503c\uff08%\uff09|";
        String currentTitile = "";
        for (String s : title) {
            currentTitile = currentTitile + s.trim() + "|";
        }
        if (!titleTemplate.equals(currentTitile)) {
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(6);
            int rowLength = sheet.getLastRowNum();
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                title.add(cell.toString().trim());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 0; i <= rowLength && (row = sheet.getRow(i + 8)) != null; ++i) {
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)UccMaterialBrandRelationServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
            log.info("\u5bfc\u5165\u7269\u8d44\u5206\u7c7b\u4e0e\u54c1\u724c\u5173\u8054\u5173\u7cfb\u8868\u5934" + JSON.toJSONString(title));
            log.info("\u5bfc\u5165\u7269\u8d44\u5206\u7c7b\u4e0e\u54c1\u724c\u5173\u8054\u5173\u7cfb\u6570\u636e" + JSON.toJSONString((Object)jsonArray));
        }
        catch (Exception e) {
            log.error("getExcelDateByImport error\uff1a" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            log.error("getCellValueByCell error\uff1a" + e);
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = BigDecimal.valueOf(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }
}

