/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.estore.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.bo.UccDealHandlerReqBO;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.dao.UccSkuLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.estore.atom.api.UccCommodityAtomService;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuBO;
import com.tydic.commodity.estore.atom.bo.BatchUpdateSkuStatusReqBO;
import com.tydic.commodity.estore.busi.api.UpdateSkuStatusForMarketService;
import com.tydic.commodity.po.UccJoinQuerySkusPo;
import com.tydic.commodity.po.UccSkuLogPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.utils.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateSkuStatusForMarketServiceImpl
implements UpdateSkuStatusForMarketService {
    private static final Logger log = LoggerFactory.getLogger(UpdateSkuStatusForMarketServiceImpl.class);
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private UccSkuLogMapper uccSkuLogMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private UccCommodityAtomService uccCommodityAtomService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public RspUccBo UpdateSkuStatusForMarket(BatchUpdateCommoStatusForMarketBO statusForMarketBO, SkuStatusEnum skuStatusEnum) {
        ValidatorUtil.validator((Object)statusForMarketBO);
        if (statusForMarketBO.getBusinessId() == null || statusForMarketBO.getBusinessId().length == 0) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), "\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList batchUpdateSkuBOS = Lists.newArrayList();
        BatchUpdateSkuStatusReqBO batchUpdateSkuStatusReqBO = new BatchUpdateSkuStatusReqBO();
        ArrayList<UccSkuPo> skuPos = new ArrayList<UccSkuPo>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (int i = 0; i < statusForMarketBO.getBusinessId().length; ++i) {
            UccSkuPo uccSkuPos = this.skuMapper.qryBySkuId(statusForMarketBO.getBusinessId()[i]);
            if (uccSkuPos == null || skuStatusEnum == null) continue;
            BatchUpdateSkuBO batchUpdateSkuBO = new BatchUpdateSkuBO();
            batchUpdateSkuBO.setSkuId(statusForMarketBO.getBusinessId()[i]);
            batchUpdateSkuBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuBO.setSupplierShopId(uccSkuPos.getSupplierShopId());
            batchUpdateSkuBOS.add(batchUpdateSkuBO);
            skuPos.add(uccSkuPos);
            skuIds.add(statusForMarketBO.getBusinessId()[i]);
        }
        if (skuStatusEnum != null) {
            UccJoinQuerySkusPo uccJoinQuerySkusPo = new UccJoinQuerySkusPo();
            uccJoinQuerySkusPo.setCommodityIdArrays(statusForMarketBO.getBusinessId());
            List<UccSkuLogPo> UccSkuLogPo2 = this.cloneUccSkuPo(skuPos);
            batchUpdateSkuStatusReqBO.setStatus(skuStatusEnum.getStatus());
            batchUpdateSkuStatusReqBO.setBoList(batchUpdateSkuBOS);
            batchUpdateSkuStatusReqBO.setType(1);
            this.processUpdateSkuAndLog(batchUpdateSkuStatusReqBO, UccSkuLogPo2, statusForMarketBO);
        }
        if (!CollectionUtils.isEmpty((Collection)batchUpdateSkuBOS)) {
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        }
        log.info("\u5904\u7406\u5546\u54c1\u5355\u54c1\u72b6\u6001\u5b8c\u6210");
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    private List<UccSkuLogPo> cloneUccSkuPo(List<UccSkuPo> skuPos) {
        ArrayList uccSkuLogPos = Lists.newArrayList();
        for (UccSkuPo skuPo : skuPos) {
            Long batchId = this.uccBatchSequence.nextId();
            UccSkuLogPo uccSkuLogPo = new UccSkuLogPo();
            uccSkuLogPo.setBatchId(batchId);
            BeanUtils.copyProperties((Object)skuPo, (Object)uccSkuLogPo);
            uccSkuLogPos.add(uccSkuLogPo);
        }
        return uccSkuLogPos;
    }

    private void processUpdateSkuAndLog(BatchUpdateSkuStatusReqBO reqBO, List<UccSkuLogPo> uccSkuLogPos, BatchUpdateCommoStatusForMarketBO statusForMarketBO) {
        try {
            if (CollectionUtils.isNotEmpty(uccSkuLogPos)) {
                this.uccSkuLogMapper.addSkuLog(uccSkuLogPos);
                List skuIds = uccSkuLogPos.stream().map(UccSkuLogPo::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuIds)) {
                    List uccSkuPoList = this.skuMapper.qeryBatchSkus(skuIds);
                    ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
                    for (UccSkuPo uccSkuPo : uccSkuPoList) {
                        UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                        logRecordAbilityBO.setSkuId(uccSkuPo.getSkuId());
                        logRecordAbilityBO.setCreateOperId("\u7ba1\u7406\u5458");
                        logRecordAbilityBO.setCommodityId(uccSkuPo.getCommodityId());
                        logRecordAbilityBO.setCreateTime(new Date());
                        logRecordAbilityBO.setOperationType(Integer.valueOf(7));
                        logRecordAbilityBO.setRemark("\u5546\u54c1\u4e0b\u67b6-\u9884\u8b66\u4e0b\u67b6");
                        recordAbilityBOS.add(logRecordAbilityBO);
                    }
                    try {
                        if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                            UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                            skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                            this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                        }
                    }
                    catch (Exception e) {
                        log.error("\u8bb0\u5f55\u5355\u54c1\u64cd\u4f5c\u65e5\u5fd7\u62a5\u9519" + e.getMessage());
                    }
                    this.dealElcSku(uccSkuPoList);
                }
            }
            this.uccCommodityAtomService.batchSkuInStatus(reqBO);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new BusinessException("8888", "\u6279\u91cf\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5931\u8d25");
        }
    }

    private void dealElcSku(List<UccSkuPo> uccSkuPos) {
        try {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                if (uccSkuPo.getApprovalStatus() == null) continue;
                switch (uccSkuPo.getApprovalStatus()) {
                    case 21: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF, "2001", "\u7535\u5546\u5546\u54c1\u4e0a\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF);
                        break;
                    }
                    case 31: {
                        Long objId = uccSkuPo.getCommodityId() == null ? uccSkuPo.getSkuId() : uccSkuPo.getCommodityId();
                        this.cancelWaitDone(objId, ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT, "2008", "\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                        break;
                    }
                    case 41: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN, "2002", "\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
                        break;
                    }
                    case 51: {
                        this.cancelWaitDone(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER, "2003", "\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                        this.cancelAudit(uccSkuPo.getSkuId(), ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u5f85\u529e\u548c\u5ba1\u6279\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private void cancelWaitDone(Long skuId, Integer objType, String busiCode, String busiName) {
        try {
            UacQryAuditLogReqBO reqStationBO = new UacQryAuditLogReqBO();
            reqStationBO.setObjType(objType);
            reqStationBO.setObjId(skuId + "");
            UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqStationBO);
            if (!"0000".equals(uacQryAuditLogRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u5f85\u529e\u4e0b\u4e00\u5ba1\u6279\u4eba\u5c97\u4f4d\u4e3a\u7a7a\uff01");
            }
            try {
                TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                todoUccWaitAbilityReqBO.setBusiCode(busiCode);
                todoUccWaitAbilityReqBO.setBusiName(busiName);
                todoUccWaitAbilityReqBO.setCenterCode("commodity");
                todoUccWaitAbilityReqBO.setOperatorType("2");
                todoUccWaitAbilityReqBO.setObjId(skuId);
                todoUccWaitAbilityReqBO.setStationId(uacQryAuditLogRspBO.getLogInfo().getNextStationId());
                UccDealHandlerReqBO uccDealHandlerReqBO = (UccDealHandlerReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoUccWaitAbilityReqBO), UccDealHandlerReqBO.class);
                uccDealHandlerReqBO.setHandleName("handler");
                this.uccDealHandlerService.insertDealHandler(uccDealHandlerReqBO);
            }
            catch (Exception e) {
                log.error("taskTodoWaitService error:{}", (Throwable)e);
            }
        }
        catch (Exception ex) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5f85\u529e\u5931\u8d25\uff1a" + ex.getMessage());
        }
    }

    private void cancelAudit(Long skuId, Integer objType) {
        try {
            UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
            uacNoTaskAuditCancelReqBO.setObjId(skuId.toString());
            uacNoTaskAuditCancelReqBO.setObjType(objType);
            uacNoTaskAuditCancelReqBO.setOperDept("sys-mgc");
            uacNoTaskAuditCancelReqBO.setOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelOperId("sys-mgc");
            uacNoTaskAuditCancelReqBO.setCancelReason("\u6807\u54c1\u89e3\u7ed1\u53d6\u6d88");
            UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
            if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) {
                throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u6cbb\u7406\u89e3\u7ed1\u53d6\u6d88\u5ba1\u6279\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

