/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.mall.busi.api.UccMallUpdateSearchGoodBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallDeleteSearchGoodBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallDeleteSearchGoodBusiRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodBusiRspBO;
import com.tydic.commodity.mall.dao.UccSearchGoodItemMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSearchGoodItemPO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallUpdateSearchGoodBusiServiceImpl
implements UccMallUpdateSearchGoodBusiService {
    @Autowired
    UccSearchGoodItemMapper uccSearchGoodItemMapper;

    @Override
    public UccMallUpdateSearchGoodBusiRspBO updateSearchGood(UccMallUpdateSearchGoodBusiReqBO reqBO) {
        UccMallUpdateSearchGoodBusiRspBO rspBO = new UccMallUpdateSearchGoodBusiRspBO();
        if (Objects.isNull(reqBO.getType()) || Objects.isNull(reqBO.getSearchGoodItemId())) {
            throw new BusinessException("8888", "\u4fee\u6539\u7c7b\u578b[type]\u548c\u6279\u91cf\u641c\u7d22\u5546\u54c1\u540d\u79f0id[searchGoodItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.isNull(reqBO.getSkuId()) && Objects.isNull(reqBO.getRequirement())) {
            throw new BusinessException("8888", "\u9700\u6c42\u63cf\u8ff0[requirement]\u548c\u5355\u54c1id[skuId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        UccSearchGoodItemPO itemPO = new UccSearchGoodItemPO();
        itemPO.setSearchGoodItemId(reqBO.getSearchGoodItemId());
        List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getList(itemPO);
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodItemId:" + JSON.toJSONString((Object)reqBO.getSearchGoodItemId()));
        }
        itemPO.setUpdateOperName(reqBO.getName());
        itemPO.setUpdateOperId(reqBO.getUsername());
        if (reqBO.getType() == 0) {
            itemPO.setRequirement(reqBO.getRequirement());
        } else {
            itemPO.setSkuId(reqBO.getSkuId());
        }
        if (this.uccSearchGoodItemMapper.updateById(itemPO) < 1) {
            throw new BusinessException("8888", "\u4fee\u6539\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01itemPO" + JSON.toJSONString((Object)itemPO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccMallDeleteSearchGoodBusiRspBO deleteSearchGood(UccMallDeleteSearchGoodBusiReqBO reqBO) {
        UccMallDeleteSearchGoodBusiRspBO rspBO = new UccMallDeleteSearchGoodBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getSearchGoodItemIds())) {
            throw new BusinessException("8888", "\u6279\u91cf\u641c\u7d22\u5546\u54c1\u540d\u79f0ids[searchGoodItemIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<UccSearchGoodItemPO> list = this.uccSearchGoodItemMapper.getListBySearchGoodItemId(reqBO.getSearchGoodItemIds());
        if (CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u6279\u91cf\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\uff01searchGoodItemIds:" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
        }
        List<Long> ids = list.stream().map(UccSearchGoodItemPO::getSearchGoodItemId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids) || this.uccSearchGoodItemMapper.deleteByIds(ids, reqBO.getName(), reqBO.getUsername()) < 1) {
            throw new BusinessException("8888", "\u6279\u91cf\u5220\u9664\u641c\u7d22\u5546\u54c1\u660e\u7ec6\u8868\u6570\u636e\u5931\u8d25\uff01searchGoodItemIds" + JSON.toJSONString(reqBO.getSearchGoodItemIds()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

