/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallExpectDeliveryTimeQueryAbilityService;
import com.tydic.commodity.mall.ability.api.UccMallQuerybxGoodsListAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallExpectDeliveryTimeQueryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallExpectDeliveryTimeQueryAbilityRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallQuerybxGoodsListReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallQuerybxGoodsListRspBo;
import com.tydic.commodity.mall.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.mall.constants.SkuEnum;
import com.tydic.commodity.mall.dao.UccDicDictionaryMapper;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSaleNumMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPicMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.DicDictionaryPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccEMdmMaterialPO;
import com.tydic.commodity.mall.po.UccSaleNumPo;
import com.tydic.commodity.mall.po.UccSkuPicPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQuerybxGoodsListAbilityService"})
public class UccMallQuerybxGoodsListAbilityServiceImpl
implements UccMallQuerybxGoodsListAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Autowired
    private UccMallSkuPicMapper uccMallSkuPicMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccMallExpectDeliveryTimeQueryAbilityService uccExpectDeliveryTimeQueryAbilityService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccMallSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;

    @PostMapping(value={"queryBxGoodsList"})
    public UccMallQuerybxGoodsListRspBo queryBxGoodsList(@RequestBody UccMallQuerybxGoodsListReqBo reqBo) {
        if (reqBo.getSkuIds() == null || reqBo.getSkuIds().isEmpty()) {
            throw new BusinessException("8888", "\u5355\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UccSkuPo> skuPos = this.uccMallSkuMapper.qeryBatchSkus(reqBo.getSkuIds());
        UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
        uccSkuPicPo.setSkuIds(reqBo.getSkuIds());
        uccSkuPicPo.setCommodityPicType(1);
        List<UccSkuPicPo> picPos = this.uccMallSkuPicMapper.qeurySkuPic(uccSkuPicPo);
        List<UccSkuPricePo> pricePos = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (UccSkuPo skuPo : skuPos) {
            if (StringUtils.isEmpty((Object)skuPo.getMaterialId())) continue;
            materialIds.add(Long.valueOf(skuPo.getMaterialId()));
        }
        HashMap<Long, UccEMdmMaterialPO> materialPOMap = new HashMap<Long, UccEMdmMaterialPO>();
        if (!materialIds.isEmpty()) {
            List<UccEMdmMaterialPO> materialPOs = this.uccEMdmMaterialMapper.batchQryById(materialIds);
            for (UccEMdmMaterialPO materialPO : materialPOs) {
                materialPOMap.put(materialPO.getMaterialId(), materialPO);
            }
        }
        List<Long> commodityTypeIds = skuPos.stream().map(UccSkuPo::getCommodityTypeId).collect(Collectors.toList());
        List<UccCommodityTypePo> commodityTypePos = this.uccMallCommodityTypeMapper.qryGuideInType(commodityTypeIds);
        Map typePoMap = commodityTypePos.stream().collect(Collectors.toMap(UccCommodityTypePo::getCommodityTypeId, Function.identity(), (a, b) -> a));
        Map imageMap = picPos.stream().collect(Collectors.toMap(UccSkuPicPo::getSkuId, Function.identity(), (a, b) -> a));
        Map priceMap = pricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity(), (a, b) -> a));
        ArrayList<UccMallQuerybxGoodsListRspBo> goodsList = new ArrayList<UccMallQuerybxGoodsListRspBo>();
        for (UccSkuPo skuPo : skuPos) {
            UccEMdmMaterialPO materialPO22;
            UccMallQuerybxGoodsListRspBo goods = new UccMallQuerybxGoodsListRspBo();
            goods.setSkuId(skuPo.getSkuId());
            goods.setCommodityId(skuPo.getCommodityId());
            goods.setSupplierShopId(skuPo.getSupplierShopId());
            UccSkuPicPo picPo = (UccSkuPicPo)imageMap.get(skuPo.getSkuId());
            if (picPo != null) {
                goods.setPic(picPo.getSkuPicUrl());
            }
            if (!StringUtils.isEmpty((Object)skuPo.getMaterialId()) && (materialPO22 = (UccEMdmMaterialPO)materialPOMap.get(Long.valueOf(skuPo.getMaterialId()))) != null) {
                goods.setMaterialCode(materialPO22.getMaterialCode());
            }
            goods.setSkuName(skuPo.getSkuName());
            goods.setSkuCode(skuPo.getSkuCode());
            goods.setBrandName(skuPo.getBrandName());
            goods.setModel(skuPo.getModel());
            goods.setSpec(skuPo.getSpec());
            try {
                goods.setSalePrice(MoneyUtils.Long2BigDecimal((Long)((UccSkuPricePo)priceMap.get(skuPo.getSkuId())).getSalePrice()));
            }
            catch (Exception materialPO22) {
                // empty catch block
            }
            goods.setMeasureName(skuPo.getMeasureName());
            goods.setSaleNum(skuPo.getMoq());
            goods.setTexture(skuPo.getTexture());
            UccCommodityTypePo typePo = (UccCommodityTypePo)typePoMap.get(skuPo.getCommodityTypeId());
            if (typePo != null) {
                goods.setCommodityTypeId(typePo.getCommodityTypeId());
                goods.setCommodityTypeName(typePo.getCommodityTypeName());
            }
            UccMallExpectDeliveryTimeQueryAbilityReqBo uccExpectDeliveryTimeQueryAbilityReqBo = new UccMallExpectDeliveryTimeQueryAbilityReqBo();
            uccExpectDeliveryTimeQueryAbilityReqBo.setSkuId(skuPo.getSkuId());
            uccExpectDeliveryTimeQueryAbilityReqBo.setSupplierShopId(skuPo.getSupplierShopId());
            uccExpectDeliveryTimeQueryAbilityReqBo.setNum("1");
            uccExpectDeliveryTimeQueryAbilityReqBo.setCity(reqBo.getCity().intValue());
            uccExpectDeliveryTimeQueryAbilityReqBo.setCounty(reqBo.getCounty().intValue());
            uccExpectDeliveryTimeQueryAbilityReqBo.setProvince(reqBo.getProvince().intValue());
            uccExpectDeliveryTimeQueryAbilityReqBo.setTown(reqBo.getTown().intValue());
            UccMallExpectDeliveryTimeQueryAbilityRspBo uccExpectDeliveryTimeQueryAbilityRspBo = this.uccExpectDeliveryTimeQueryAbilityService.getExpectDeliveryTime(uccExpectDeliveryTimeQueryAbilityReqBo);
            if ("0000".equals(uccExpectDeliveryTimeQueryAbilityRspBo.getRespCode())) {
                goods.setArrivalTime(uccExpectDeliveryTimeQueryAbilityRspBo.getResult());
            }
            goods.setSupplierName(skuPo.getShopName());
            goods.setSkuStatus(skuPo.getSkuStatus());
            DicDictionaryPo dicDictionaryPo = this.uccDicDictionaryMapper.selectdictionaryByCodeAndCode(String.valueOf(skuPo.getSkuStatus()), SkuEnum.SKU_STATUS.toString());
            if (dicDictionaryPo != null) {
                goods.setSkuStatusDesc(dicDictionaryPo.getTitle());
            }
            goods.setOutSkuId(skuPo.getExtSkuId());
            goods.setSupplierId(skuPo.getSupplierShopId());
            goodsList.add(goods);
        }
        UccMallQuerybxGoodsListRspBo rspBo = new UccMallQuerybxGoodsListRspBo();
        this.getSaleNum(goodsList, reqBo.getSkuIds());
        rspBo.setGoodsList(goodsList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void getSaleNum(List<UccMallQuerybxGoodsListRspBo> bos, List<Long> skuIds) {
        List<UccSaleNumPo> uccSaleNumPos;
        if (!CollectionUtils.isEmpty(bos) && !CollectionUtils.isEmpty(uccSaleNumPos = this.uccSaleNumMapper.qryBySkuIds(skuIds))) {
            for (UccSaleNumPo uccSaleNumPo : uccSaleNumPos) {
                for (UccMallQuerybxGoodsListRspBo uccMallCommdCompareInfoBO : bos) {
                    if (!uccSaleNumPo.getSkuId().equals(uccMallCommdCompareInfoBO.getSkuId())) continue;
                    uccMallCommdCompareInfoBO.setSaleNum(uccSaleNumPo.getSoldNumber());
                }
            }
        }
    }
}

