/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.atom.impl;

import com.tydic.commodity.mall.atom.api.UccMallCatalogSoldNumQryAtomService;
import com.tydic.commodity.mall.atom.api.UccMallQryCommodityTypeIdsAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCatalogSoldNumQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCatalogSoldNumQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallCommdSoldNum;
import com.tydic.commodity.mall.atom.bo.UccMallQryCommodityTypeIdsReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallQryCommodityTypeIdsRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSaleNumMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.UccSaleNumPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCatalogSoldNumQryAtomServiceImpl
implements UccMallCatalogSoldNumQryAtomService {
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallQryCommodityTypeIdsAtomService uccMallQryCommodityTypeIdsAtomService;

    @Override
    public UccMallCatalogSoldNumQryRspBO qrySoldNum(UccMallCatalogSoldNumQryReqBO reqBO) {
        UccMallCatalogSoldNumQryRspBO rspBO = new UccMallCatalogSoldNumQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        if (CollectionUtils.isEmpty(reqBO.getCatalogIds())) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
        }
        UccMallQryCommodityTypeIdsReqBO uccMallQryCommodityTypeIdsReqBO = new UccMallQryCommodityTypeIdsReqBO();
        uccMallQryCommodityTypeIdsReqBO.setCatalogIds(reqBO.getCatalogIds());
        UccMallQryCommodityTypeIdsRspBO uccMallQryCommodityTypeIdsRspBO = this.uccMallQryCommodityTypeIdsAtomService.qryCommodityTypeIds(uccMallQryCommodityTypeIdsReqBO);
        Map<Long, List<Long>> commodityTypeIdMap = uccMallQryCommodityTypeIdsRspBO.getCommodityIds();
        Iterator<Map.Entry<Long, List<Long>>> iterator = commodityTypeIdMap.entrySet().iterator();
        ArrayList<UccMallCommdSoldNum> uccMallsCommdSoldNums = new ArrayList<UccMallCommdSoldNum>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Long>> each = iterator.next();
            Long catalogId = each.getKey();
            List<Long> commodityTypeIds = each.getValue();
            UccMallCommdSoldNum uccMallsCommdSoldNum = new UccMallCommdSoldNum();
            uccMallsCommdSoldNum.setCatalogId(catalogId);
            uccMallsCommdSoldNum.setSoldNum(0L);
            uccMallsCommdSoldNums.add(uccMallsCommdSoldNum);
            List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.querySkuByCommTypeIds(commodityTypeIds);
            if (CollectionUtils.isEmpty(uccSkuPoList)) continue;
            ArrayList<Long> skuIds = new ArrayList<Long>();
            for (UccSkuPo uccSkuPo : uccSkuPoList) {
                skuIds.add(uccSkuPo.getSkuId());
            }
            List<UccSaleNumPo> uccSaleNumPos = this.uccMallSaleNumMapper.qryBySkuIds(skuIds);
            if (CollectionUtils.isEmpty(uccSaleNumPos)) continue;
            BigDecimal soldNum = new BigDecimal(0);
            for (UccSaleNumPo uccSaleNumPo : uccSaleNumPos) {
                soldNum = soldNum.add(uccSaleNumPo.getSoldNumber());
            }
            uccMallsCommdSoldNum.setSoldNum(soldNum.longValue());
        }
        rspBO.setResult(uccMallsCommdSoldNums);
        return rspBO;
    }
}

