/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.mall.ability.api.UccMallIImportSearchGoodAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallImportSearchGoodAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallImportSearchGoodAbilityRspBo;
import com.tydic.commodity.mall.busi.api.UccMallUpdateSearchGoodBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodAndItemsBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallUpdateSearchGoodAndItemsBusiRspBO;
import com.tydic.commodity.mall.enums.SearchGoodExportDeleteStatusEnum;
import com.tydic.commodity.mall.enums.TitleTemplateEnum;
import com.tydic.commodity.mall.po.UccSearchGoodExportItemPO;
import com.tydic.commodity.mall.po.UccSearchGoodExportPO;
import com.tydic.commodity.mall.utils.DateUtils;
import com.tydic.commodity.mall.utils.HttpUtil;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallIImportSearchGoodAbilityService"})
public class UccMallIImportSearchGoodAbilityServiceImpl
implements UccMallIImportSearchGoodAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallIImportSearchGoodAbilityServiceImpl.class);
    @Autowired
    private UccMallUpdateSearchGoodBusiService uccMallUpdateSearchGoodBusiService;
    private Sequence sequence = Sequence.getInstance();
    private static final HashMap<String, String> TITLE = new HashMap(9);

    private static void initialize() {
        TITLE.put("SERIAL_NUMBER", "\u5e8f\u53f7");
        TITLE.put("EXT_SKU_ID", "\u5916\u90e8\u5355\u54c1\u7f16\u7801");
        TITLE.put("MATERIAL_CODE", "\u7269\u6599\u7f16\u7801");
        TITLE.put("SKU_CODE", "\u5355\u54c1\u7f16\u7801");
        TITLE.put("SKU_NAME", "\u5546\u54c1\u540d\u79f0");
        TITLE.put("BRAND_NAME", "\u54c1\u724c");
        TITLE.put("MODEL", "\u578b\u53f7");
        TITLE.put("SPEC", "\u89c4\u683c");
        TITLE.put("PURCHASE_COUNT", "\u6570\u91cf");
    }

    @PostMapping(value={"importSearchGoodList"})
    public UccMallImportSearchGoodAbilityRspBo importSearchGoodList(@RequestBody UccMallImportSearchGoodAbilityReqBO reqBO) {
        UccSearchGoodExportPO uccSearchGoodExport = new UccSearchGoodExportPO();
        UccMallUpdateSearchGoodAndItemsBusiReqBO busiReqBO = new UccMallUpdateSearchGoodAndItemsBusiReqBO();
        busiReqBO.setUccSearchGoodExportPO(uccSearchGoodExport);
        ArrayList<UccSearchGoodExportItemPO> uccSearchGoodItemList = new ArrayList<UccSearchGoodExportItemPO>();
        JSONObject excelJsonObj = this.analysisExcelData(reqBO);
        JSONArray excelJSONArray = excelJsonObj.getJSONArray("excelJSON");
        log.info("\u83b7\u53d6\u5230\u7684excel JSON\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)excelJSONArray));
        HashMap checkMap = new HashMap();
        uccSearchGoodExport.setSearchGoodExportId(this.sequence.nextId());
        uccSearchGoodExport.setCreateOperId(String.valueOf(reqBO.getUserId()));
        uccSearchGoodExport.setCreateOperName(reqBO.getName());
        uccSearchGoodExport.setCreateTime(new Date());
        uccSearchGoodExport.setDelFlag("0");
        if (CollectionUtils.isEmpty((Collection)excelJSONArray)) {
            log.error("\u8868\u5934\u5bf9\u5e94\u7684\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01");
            uccSearchGoodExport.setExportStatus(SearchGoodExportDeleteStatusEnum.FAIL.getValue());
            uccSearchGoodExport.setRemark("\u8868\u5934\u5bf9\u5e94\u7684\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff01");
            busiReqBO.setUccSearchGoodExportPO(uccSearchGoodExport);
        } else {
            if (excelJSONArray.size() == 1 && excelJSONArray.toString().contains("importError")) {
                Iterator j = (JSONObject)excelJSONArray.get(0);
                log.error(String.valueOf(j.get("importError")));
                uccSearchGoodExport.setExportStatus(SearchGoodExportDeleteStatusEnum.FAIL.getValue());
                uccSearchGoodExport.setRemark(String.valueOf(j.get("importError")));
            } else {
                for (Object o : excelJSONArray) {
                    JSONObject j = (JSONObject)o;
                    TITLE.forEach((key, value) -> {
                        if (!"SERIAL_NUMBER".equals(key) && StringUtils.isNotBlank((CharSequence)j.getString(value))) {
                            checkMap.put(key, j.getString(value));
                        }
                    });
                    if (CollectionUtils.isEmpty(checkMap)) {
                        log.error("\u9664\u5e8f\u53f7\u5916\uff0c\u5176\u4ed6\u8868\u5934\u5bf9\u5e94\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        uccSearchGoodExport.setExportStatus(SearchGoodExportDeleteStatusEnum.FAIL.getValue());
                        uccSearchGoodExport.setRemark("\u9664\u5e8f\u53f7\u5916\uff0c\u5176\u4ed6\u8868\u5934\u5bf9\u5e94\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        break;
                    }
                    uccSearchGoodExport.setExportStatus(SearchGoodExportDeleteStatusEnum.SUCCESS.getValue());
                    UccSearchGoodExportItemPO itemPO = new UccSearchGoodExportItemPO();
                    itemPO.setSearchGoodExportItemId(this.sequence.nextId());
                    itemPO.setDelFlag("0");
                    itemPO.setBrandName(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("BRAND_NAME")));
                    itemPO.setModel(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("MODEL")));
                    itemPO.setMaterialCode(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("MATERIAL_CODE")));
                    itemPO.setSkuName(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("SKU_NAME")));
                    itemPO.setSkuCode(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("SKU_CODE")));
                    itemPO.setExtSkuId(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("EXT_SKU_ID")));
                    itemPO.setSpec(StringUtils.isBlank((CharSequence)j.getString(TITLE.get("BRAND_NAME"))) ? "" : j.getString(TITLE.get("SPEC")));
                    itemPO.setExtField1("");
                    itemPO.setExtField2("");
                    itemPO.setExtField3("");
                    itemPO.setExtField4("");
                    itemPO.setExtField5("");
                    String purchaseCount = j.getString(TITLE.get("PURCHASE_COUNT"));
                    if (StringUtils.isNotBlank((CharSequence)purchaseCount)) {
                        try {
                            BigDecimal bigDecimal = new BigDecimal(purchaseCount);
                            itemPO.setPurchaseCount(bigDecimal);
                        }
                        catch (Exception e) {
                            throw new BusinessException("8888", "\u6570\u91cf\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6b63\u5e38\u7684\u6570\u91cf\u503c\uff0c purchaseCount:" + purchaseCount);
                        }
                    }
                    uccSearchGoodItemList.add(itemPO);
                }
            }
            log.info("\u6279\u91cf\u641c\u7d22\u5546\u54c1\u5bfc\u5165\u5165\u5e93\u53c2\u6570----> uccSearchGoodExport:{}\uff0cuccSearchGoodItemList:{}", (Object)JSON.toJSONString((Object)uccSearchGoodExport), (Object)JSON.toJSONString(uccSearchGoodItemList));
            busiReqBO.setUccSearchGoodExportPO(uccSearchGoodExport);
            busiReqBO.setUccSearchGoodExportItemPOList(uccSearchGoodItemList);
        }
        UccMallUpdateSearchGoodAndItemsBusiRspBO rspBO = this.uccMallUpdateSearchGoodBusiService.insertSearchGoodAndItems(busiReqBO);
        return (UccMallImportSearchGoodAbilityRspBo)BeanUtil.copyProperties((Object)((Object)rspBO), UccMallImportSearchGoodAbilityRspBo.class);
    }

    private JSONObject analysisExcelData(UccMallImportSearchGoodAbilityReqBO reqBO) {
        JSONObject excelData = new JSONObject();
        ArrayList<String> titleList = new ArrayList<String>();
        try {
            String dateString = DateUtils.dateToStrAsFormat(new Date(), "yyyyMMddHHmmss");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + dateString + "content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getImportUrl(), file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
                this.getExcelDateByImport((MultipartFile)multipartFile, excelData, titleList);
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e);
        }
        if (CollectionUtils.isEmpty(titleList)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)excelData)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder currentTitle = new StringBuilder();
        for (String s : titleList) {
            currentTitle.append(s).append("|");
        }
        String typeBydesc = TitleTemplateEnum.getTypeBydesc(currentTitle.toString());
        if (StringUtils.isEmpty((CharSequence)typeBydesc)) {
            log.error("\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e,currentTitle:{}", (Object)currentTitle);
            throw new BusinessException("8888", "\u8868\u5934\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u8868\u5934\u662f\u5426\u6b63\u786e");
        }
        return excelData;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> titleList) {
        JSONArray jsonArray = new JSONArray();
        jsonData.put("excelJSON", (Object)jsonArray);
        try {
            ExcelUtils.checkExcelVaild((MultipartFile)multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok((MultipartFile)multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            Row row = sheet.getRow(1);
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) continue;
                titleList.add(cell.toString().trim());
                log.info("\u83b7\u53d6\u5230\u7684\u8868\u5934\uff1a{}", (Object)cell);
            }
            if (rowLength > 101) {
                log.error("\u4ec5\u53ef\u5bfc\u5165100\u884c\u6570\u636e!");
                JSONObject rowJson = new JSONObject();
                rowJson.put("importError", (Object)"\u4ec5\u53ef\u5bfc\u5165100\u884c\u6570\u636e\uff01");
                jsonArray.add((Object)rowJson);
                return;
            }
            for (int i = 2; i <= rowLength; ++i) {
                JSONObject rowJson = new JSONObject();
                row = sheet.getRow(i);
                if (row == null) {
                    jsonArray.clear();
                    int num = i + 1;
                    log.error("\u7b2c" + num + "\u884c\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a!");
                    rowJson.put("importError", (Object)("\u7b2c" + num + "\u884c\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a!"));
                    jsonArray.add((Object)rowJson);
                    return;
                }
                for (int j = 0; j < colLength; ++j) {
                    Cell cell = row.getCell(j);
                    if (titleList.get(j).equals(TITLE.get("PURCHASE_COUNT")) && StringUtils.isBlank((CharSequence)UccMallIImportSearchGoodAbilityServiceImpl.getCellValueByCell(cell))) {
                        jsonArray.clear();
                        rowJson.clear();
                        int num = i + 1;
                        log.error("\u7b2c" + num + "\u884c\u5bfc\u5165\u7684[" + TITLE.get("PURCHASE_COUNT") + "]\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
                        rowJson.put("importError", (Object)("\u7b2c" + num + "\u884c\u5bfc\u5165\u7684[" + TITLE.get("PURCHASE_COUNT") + "]\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
                        jsonArray.add((Object)rowJson);
                        return;
                    }
                    if (cell == null) continue;
                    rowJson.put(titleList.get(j), (Object)UccMallIImportSearchGoodAbilityServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
        }
        catch (Exception e) {
            log.error("getExcelDateByImport error\uff1a" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            log.error("getCellValueByCell error\uff1a" + e1);
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = BigDecimal.valueOf(cell.getNumericCellValue());
                cellValue = bd.toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    static {
        UccMallIImportSearchGoodAbilityServiceImpl.initialize();
    }
}

