/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallJdAppIntroduceQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallJdAppIntroduceQryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallJdAppIntroduceQryAbilityRspBo;
import com.tydic.commodity.mall.atom.api.UccMallJdAppIntroduceQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallJdAppIntroduceQryAtomReqBo;
import com.tydic.commodity.mall.atom.bo.UccMallJdAppIntroduceQryAtomRspBo;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallJdAppIntroduceQryAbilityService"})
public class UccMallJdAppIntroduceQryAbilityServiceImpl
implements UccMallJdAppIntroduceQryAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallJdAppIntroduceQryAtomService uccMallJdAppIntroduceQryAtomService;

    @PostMapping(value={"qryJdAppIntroduce"})
    public UccMallJdAppIntroduceQryAbilityRspBo qryJdAppIntroduce(@RequestBody UccMallJdAppIntroduceQryAbilityReqBo reqBo) {
        UccMallJdAppIntroduceQryAbilityRspBo rspBo = new UccMallJdAppIntroduceQryAbilityRspBo();
        UccSkuPo uccSkuPo1 = new UccSkuPo();
        uccSkuPo1.setSkuId(reqBo.getSkuId());
        uccSkuPo1.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo1);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            rspBo.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBo.setRespDesc("sku_id =" + reqBo.getSkuId() + "\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBo;
        }
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || StringUtils.isEmpty((Object)supplierBusiPo.getSupplierCode())) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        String extSkuId = uccSkuPos.get(0).getExtSkuId();
        UccMallJdAppIntroduceQryAtomReqBo uccMallJdAppIntroduceQryAtomReqBo = new UccMallJdAppIntroduceQryAtomReqBo();
        uccMallJdAppIntroduceQryAtomReqBo.setSkuId(extSkuId);
        uccMallJdAppIntroduceQryAtomReqBo.setSupplierCode(supplierCode);
        UccMallJdAppIntroduceQryAtomRspBo uccMallJdAppIntroduceQryAtomRspBo = this.uccMallJdAppIntroduceQryAtomService.qryJdAppIntroduce(uccMallJdAppIntroduceQryAtomReqBo);
        BeanUtils.copyProperties((Object)((Object)uccMallJdAppIntroduceQryAtomRspBo), (Object)rspBo);
        return rspBo;
    }
}

