/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccCheckSkuCountAbilityService;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountReqBo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountReqBoSkuInfo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountRspBo;
import com.tydic.commodity.mall.ability.bo.UccCheckSkuCountRspBoSkuInfo;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccCheckSkuCountAbilityService"})
public class UccCheckSkuCountAbilityServiceImpl
implements UccCheckSkuCountAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCheckSkuCountAbilityServiceImpl.class);
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Value(value="${sn_cg_stb:100059,428806,}")
    private String snCgStb;
    @Value(value="${gaj_zkh_ofs_xfs_xy:100058,100060,398173,437456,}")
    private String gzoxx;
    @Value(value="${jd_dl:100055,}")
    private String jdDl;

    @PostMapping(value={"checkSkuCount"})
    public UccCheckSkuCountRspBo checkSkuCount(@RequestBody UccCheckSkuCountReqBo reqBo) {
        UccCheckSkuCountRspBo rspBo = new UccCheckSkuCountRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        ArrayList<Long> vendor = new ArrayList<Long>();
        for (UccCheckSkuCountReqBoSkuInfo skuInfo : reqBo.getSkuInfo()) {
            if (vendor.contains(skuInfo.getSupplierShopId())) continue;
            vendor.add(skuInfo.getSupplierShopId());
        }
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setSupplierShopIds(vendor);
        List<UccSkuPo> list = this.uccMallSkuMapper.checkSkuCount(skuPo);
        ArrayList<UccCheckSkuCountRspBoSkuInfo> skuInfo = new ArrayList<UccCheckSkuCountRspBoSkuInfo>();
        Map<Object, Object> supplierShopIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(list)) {
            supplierShopIdMap = list.stream().filter(e -> e.getSupplierShopId() != null).collect(Collectors.toMap(UccSkuPo::getSupplierShopId, UccSkuPo::getCheckSkuCount));
        }
        for (UccCheckSkuCountReqBoSkuInfo info : reqBo.getSkuInfo()) {
            UccCheckSkuCountRspBoSkuInfo boSkuInfo = new UccCheckSkuCountRspBoSkuInfo();
            boSkuInfo.setSkuId(info.getSkuId());
            boSkuInfo.setFlag(Boolean.valueOf(true));
            if (supplierShopIdMap.containsKey(info.getSupplierShopId())) {
                Integer checkSkuCount = (Integer)supplierShopIdMap.get(info.getSupplierShopId());
                boSkuInfo.setZjCount(checkSkuCount);
                try {
                    String[] strings = info.getCount().split("\\|");
                    if (this.snCgStb.contains(info.getSupplierShopId() + ",")) {
                        if (checkSkuCount >= new BigDecimal(strings[0]).intValue()) {
                            boSkuInfo.setFlag(Boolean.valueOf(false));
                            boSkuInfo.setSupplierShopId(info.getSupplierShopId());
                        }
                    } else if (this.gzoxx.contains(info.getSupplierShopId() + ",")) {
                        if (checkSkuCount >= new BigDecimal(strings[1]).intValue()) {
                            boSkuInfo.setFlag(Boolean.valueOf(false));
                            boSkuInfo.setSupplierShopId(info.getSupplierShopId());
                        }
                    } else if (this.jdDl.contains(info.getSupplierShopId() + ",") && checkSkuCount >= new BigDecimal(strings[2]).intValue()) {
                        boSkuInfo.setFlag(Boolean.valueOf(false));
                        boSkuInfo.setSupplierShopId(info.getSupplierShopId());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new ZTBusinessException("\u9884\u8b66\u4e2d\u5fc3\u89c4\u5219\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u9884\u8b66\u4e2d\u5fc3\u8fd0\u7ef4\u56e2\u961f\u3002");
                }
            }
            skuInfo.add(boSkuInfo);
        }
        rspBo.setSkuInfo(skuInfo);
        return rspBo;
    }
}

