/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallAreaAvailableQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableCommdBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallAreaAvailableQryBo;
import com.tydic.commodity.mall.busi.api.UccMallAreaAvailableQryBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallAreaAvailableQryBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallAreaAvailableQryBusiRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallAreaAvailableQryAbilityService"})
public class UccMallAreaAvailableQryAbilityServiceImpl
implements UccMallAreaAvailableQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallAreaAvailableQryAbilityServiceImpl.class);
    @Autowired
    private UccMallAreaAvailableQryBusiService uccMallAreaAvailableQryBusiService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMallAreaAvailableQryAbilityServiceImpl.class);

    @PostMapping(value={"qryAreaAvailable"})
    public UccMallAreaAvailableQryAbilityRspBO qryAreaAvailable(@RequestBody UccMallAreaAvailableQryAbilityReqBO reqBO) {
        UccMallAreaAvailableQryAbilityRspBO rspBO = new UccMallAreaAvailableQryAbilityRspBO();
        Map<Long, UccMallAreaAvailableQryBusiReqBO> skuInfo = this.groupByShopid(reqBO);
        if (skuInfo == null || skuInfo.isEmpty()) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1\u4fe1\u606f");
            return rspBO;
        }
        UccMallAreaAvailableQryBusiRspBO uccMallAreaAvailableQryBusiRspBO = null;
        try {
            ArrayList<UccMallAreaAvailableCommdBO_busi> bo_busis = new ArrayList<UccMallAreaAvailableCommdBO_busi>();
            for (Map.Entry<Long, UccMallAreaAvailableQryBusiReqBO> entry : skuInfo.entrySet()) {
                uccMallAreaAvailableQryBusiRspBO = this.uccMallAreaAvailableQryBusiService.qryUccAreaAvailable(entry.getValue());
                if ("0000".equals(uccMallAreaAvailableQryBusiRspBO.getRespCode())) {
                    bo_busis.addAll(uccMallAreaAvailableQryBusiRspBO.getAreaAvailableCommdInfos());
                    continue;
                }
                BeanUtils.copyProperties((Object)((Object)uccMallAreaAvailableQryBusiRspBO), (Object)rspBO);
                return rspBO;
            }
            for (UccMallAreaAvailableCommdBO_busi boBusi : bo_busis) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(Long.valueOf(boBusi.getSkuId()));
                List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPoList)) continue;
                boBusi.setSkuCode(uccSkuPoList.get(0).getSkuCode());
                boBusi.setExtSkuId(uccSkuPoList.get(0).getExtSkuId());
            }
            rspBO.setAreaAvailableCommdInfos(bo_busis);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef\uff1a {}->" + e.getMessage());
            rspBO.setRespCode(UccMallConstantsEnums.EXTERNAL_AVAILABLE_COMMODITY_FAIL.code());
            rspBO.setRespDesc("\u6279\u91cf\u67e5\u8be2\u53ef\u552e\u4fe1\u606f\u9519\u8bef");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Long, UccMallAreaAvailableQryBusiReqBO> groupByShopid(UccMallAreaAvailableQryAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAreaAvailableSkuInfo())) {
            return null;
        }
        HashedMap result = new HashedMap();
        for (UccMallAreaAvailableQryBo each : reqBO.getAreaAvailableSkuInfo()) {
            if (result.containsKey(each.getSupplierShopId())) {
                ((UccMallAreaAvailableQryBusiReqBO)result.get(each.getSupplierShopId())).getSkuIds().add(each.getSkuId());
                continue;
            }
            UccMallAreaAvailableQryBusiReqBO bo = new UccMallAreaAvailableQryBusiReqBO();
            BeanUtils.copyProperties((Object)each, (Object)bo);
            bo.setSkuIds(new ArrayList<Long>(Arrays.asList(each.getSkuId())));
            result.put(each.getSupplierShopId(), bo);
        }
        return result;
    }
}

