/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccMallCmsSkuDetailAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCmsSkuDetailAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallCmsSkuDetailAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallCmsSkuDetailAbilityRspParam;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPriceMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.exception.BusinessException;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPricePo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallCmsSkuDetailAbilityService"})
public class UccMallCmsSkuDetailAbilityServiceImpl
implements UccMallCmsSkuDetailAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCmsSkuDetailAbilityServiceImpl.class);
    @Resource
    private UccMallSkuMapper uccMallSkuMapper;
    @Resource
    private UccMallSkuPriceMapper uccMallSkuPriceMapper;
    @Resource
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;

    @PostMapping(value={"qryCmsSkuDetail"})
    public UccMallCmsSkuDetailAbilityRspBO qryCmsSkuDetail(@RequestBody UccMallCmsSkuDetailAbilityReqBO reqBO) {
        List<SupplierShopPo> supPOList;
        if (Objects.isNull(reqBO) || CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            throw new BusinessException(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code(), UccMallConstantsEnums.REQUIRED_NON_EMPTY.message());
        }
        UccMallCmsSkuDetailAbilityRspBO rspBO = new UccMallCmsSkuDetailAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<UccSkuPo> skuList = this.uccMallSkuMapper.qryCmsSkuList(reqBO.getSkuIds());
        if (CollectionUtils.isEmpty(skuList)) {
            log.error("\u672a\u67e5\u8be2\u5230CMS\u5bf9\u5e94\u7684\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\uff01");
            return rspBO;
        }
        List<UccSkuPricePo> pricePoList = this.uccMallSkuPriceMapper.batchQryPriBySkuIds(reqBO.getSkuIds(), null);
        Map<Object, Object> priceMap = !CollectionUtils.isEmpty(pricePoList) ? pricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        List<Long> supShopIdList = skuList.stream().map(UccSkuPo::getSupplierShopId).distinct().collect(Collectors.toList());
        Map<Object, Object> supMap = CollectionUtils.isEmpty(supShopIdList) ? new HashMap() : (CollectionUtils.isEmpty(supPOList = this.uccMallSupplierShopMapper.queryPoBySupplierShopIds(supShopIdList)) ? new HashMap() : supPOList.stream().filter(e -> Objects.nonNull(e.getSupplierId())).collect(Collectors.toMap(SupplierShopPo::getSupplierShopId, SupplierShopPo::getSupplierId, (k1, k2) -> k1)));
        ArrayList paramList = new ArrayList();
        skuList.forEach(e -> {
            UccMallCmsSkuDetailAbilityRspParam param = new UccMallCmsSkuDetailAbilityRspParam();
            param.setSkuId(e.getSkuId());
            param.setSkuSource(e.getSkuSource());
            param.setShopId(e.getSupplierShopId());
            param.setCommodityDesc(e.getSkuName());
            param.setExtSkuId(e.getExtSkuId());
            param.setSupplierName(e.getShopName());
            if (!CollectionUtils.isEmpty((Map)priceMap) && priceMap.containsKey(e.getSkuId())) {
                Long salePrice = Objects.isNull(((UccSkuPricePo)priceMap.get(e.getSkuId())).getSalePrice()) ? 0L : ((UccSkuPricePo)priceMap.get(e.getSkuId())).getSalePrice();
                Long marketPrice = Objects.isNull(((UccSkuPricePo)priceMap.get(e.getSkuId())).getMarketPrice()) ? 0L : ((UccSkuPricePo)priceMap.get(e.getSkuId())).getMarketPrice();
                param.setPrice(MoneyUtils.haoToYuan(salePrice).toPlainString());
                param.setMemberPrice(MoneyUtils.haoToYuan(marketPrice).toPlainString());
            }
            if (!CollectionUtils.isEmpty((Map)supMap) && supMap.containsKey(e.getSupplierShopId())) {
                param.setSuperId((Long)supMap.get(e.getSupplierShopId()));
            }
            paramList.add(param);
        });
        rspBO.setParamList(paramList);
        return rspBO;
    }
}

