/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.api.UccSkuOperationLogRecordAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityBO;
import com.tydic.commodity.common.ability.bo.UccSkuOperationLogRecordAbilityReqBO;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQryListSkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQryListSkuStateRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuStateRspBO;
import com.tydic.commodity.mall.atom.api.InterfaceQrySkuStateService;
import com.tydic.commodity.mall.atom.api.UccMallSyncSceneCommodityToEsAtomService;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRsp;
import com.tydic.commodity.mall.atom.bo.InterfaceSkuStateRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSkuPutCirMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccQrySkuStateInfoPO;
import com.tydic.commodity.mall.po.UccSkuPo;
import com.tydic.commodity.mall.po.UccSkuPutCirPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallQrySkuStateAbilityService"})
public class UccMallQrySkuStateAbilityServiceImpl
implements UccMallQrySkuStateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallQrySkuStateAbilityServiceImpl.class);
    @Autowired
    private InterfaceQrySkuStateService interfaceQrySkuStateService;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallSyncSceneCommodityToEsAtomService uccMallSyncSceneCommodityToEsAtomService;
    @Autowired
    private UccMallSkuPutCirMapper uccMallSkuPutCirMapper;
    @Autowired
    private UccSkuOperationLogRecordAbilityService uccSkuOperationLogRecordAbilityService;

    @Transactional
    @PostMapping(value={"qrySkuState"})
    public UccMallQrySkuStateRspBO qrySkuState(@RequestBody UccMallQrySkuStateReqBO reqBo) {
        ArrayList<UccMallQrySkuStateBO> rows;
        UccMallQrySkuStateRspBO rspBo;
        block15: {
            rspBo = new UccMallQrySkuStateRspBO();
            if (null == reqBo || CollectionUtils.isEmpty((Collection)reqBo.getSkuIds()) || null == reqBo.getSupplierShopId()) {
                rspBo.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
                rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBo;
            }
            List<UccSkuPo> skuPoList = this.uccMallSkuMapper.batchQrySku(reqBo.getSkuIds(), reqBo.getSupplierShopId());
            if (CollectionUtils.isEmpty(skuPoList)) {
                rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
                rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
                return rspBo;
            }
            SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
            if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
                return rspBo;
            }
            Long supplierId = supplierShopPo.getSupplierId();
            SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
            if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
                return rspBo;
            }
            String supplierCode = supplierBusiPo.getSupplierCode();
            rows = new ArrayList<UccMallQrySkuStateBO>();
            List onList = skuPoList.stream().filter(po -> po.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())).collect(Collectors.toList());
            skuPoList.removeAll(onList);
            if (!CollectionUtils.isEmpty(onList)) {
                List extSkuIds = onList.stream().map(UccSkuPo::getExtSkuId).collect(Collectors.toList());
                InterfaceSkuStateReqBO uccSkuStateReqBo = new InterfaceSkuStateReqBO();
                uccSkuStateReqBo.setExtSkuIds(extSkuIds);
                uccSkuStateReqBo.setSupplierId(supplierId);
                uccSkuStateReqBo.setSupplierCode(supplierCode);
                InterfaceSkuStateRsp uccSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(uccSkuStateReqBo);
                if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
                    rspBo.setRespCode("8888");
                    rspBo.setRespDesc(uccSkuStateRsp.getRespDesc());
                    return rspBo;
                }
                for (UccSkuPo uccSkuPo : onList) {
                    for (InterfaceSkuStateRspBo skuState : uccSkuStateRsp.getSkuStates()) {
                        if (!uccSkuPo.getExtSkuId().equals(skuState.getSku())) continue;
                        UccMallQrySkuStateBO stateBO = new UccMallQrySkuStateBO();
                        stateBO.setSkuId(uccSkuPo.getSkuId());
                        stateBO.setStatus(skuState.getState().toString());
                        rows.add(stateBO);
                    }
                }
            }
            for (UccSkuPo uccSkuPo : skuPoList) {
                UccMallQrySkuStateBO stateBO = new UccMallQrySkuStateBO();
                stateBO.setSkuId(uccSkuPo.getSkuId());
                stateBO.setStatus("2");
                rows.add(stateBO);
            }
            try {
                List<Long> skuIdList = rows.stream().filter(x -> "0".equals(x.getStatus())).map(UccMallQrySkuStateBO::getSkuId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(skuIdList)) break block15;
                this.uccMallSkuMapper.updateOffSkuStatus(skuIdList);
                skuIdList.forEach(x -> {
                    UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
                    uccSkuPutCirPo.setId(Sequence.getInstance().nextId());
                    uccSkuPutCirPo.setSkuId((Long)x);
                    uccSkuPutCirPo.setState(2);
                    uccSkuPutCirPo.setPreDownTime(new Date());
                    uccSkuPutCirPo.setRealDownTime(new Date());
                    uccSkuPutCirPo.setDownType(2);
                    uccSkuPutCirPo.setRemark("\u7535\u5546\u4e0b\u67b6(\u6d88\u606f\u672a\u63a8,\u5546\u57ce\u6d4b\u4e0b\u67b6)");
                    uccSkuPutCirPo.setSupplierShopId(reqBo.getSupplierShopId());
                    this.uccMallSkuPutCirMapper.addSkuPutCir(uccSkuPutCirPo);
                });
                CompletableFuture.runAsync(() -> {
                    UccMallSyncSceneCommodityToEsReqBO toEsReqBO = new UccMallSyncSceneCommodityToEsReqBO();
                    toEsReqBO.setSkuIds(skuIdList);
                    toEsReqBO.setOperType(2);
                    toEsReqBO.setSyncType(4);
                    toEsReqBO.setSingleType(2);
                    this.uccMallSyncSceneCommodityToEsAtomService.syncSceneCommodityToEs(toEsReqBO);
                });
                List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qryCmsSkuList(skuIdList);
                ArrayList<UccSkuOperationLogRecordAbilityBO> recordAbilityBOS = new ArrayList<UccSkuOperationLogRecordAbilityBO>();
                for (UccSkuPo po2 : uccSkuPos) {
                    UccSkuOperationLogRecordAbilityBO logRecordAbilityBO = new UccSkuOperationLogRecordAbilityBO();
                    logRecordAbilityBO.setSkuId(po2.getSkuId());
                    logRecordAbilityBO.setCreateOperId(reqBo.getName());
                    logRecordAbilityBO.setCommodityId(po2.getCommodityId());
                    logRecordAbilityBO.setCreateTime(new Date());
                    logRecordAbilityBO.setExtField1(reqBo.getUserId().toString());
                    logRecordAbilityBO.setOperationType(Integer.valueOf(20));
                    logRecordAbilityBO.setRemark("\u8be6\u60c5\u89e6\u53d1\u4e0b\u67b6");
                    logRecordAbilityBO.setSkuExtValue("\u5916\u90e8\u7535\u5546\u4e0b\u67b6\u672a\u63a8\u6d88\u606f");
                    recordAbilityBOS.add(logRecordAbilityBO);
                }
                try {
                    if (!CollectionUtils.isEmpty(recordAbilityBOS)) {
                        UccSkuOperationLogRecordAbilityReqBO skuOperationLogRecordAbilityReqBO = new UccSkuOperationLogRecordAbilityReqBO();
                        skuOperationLogRecordAbilityReqBO.setRecordAbilityBOS(recordAbilityBOS);
                        this.uccSkuOperationLogRecordAbilityService.recordUccSkuOperationLog(skuOperationLogRecordAbilityReqBO);
                    }
                }
                catch (Exception e) {
                    log.error("\u8be6\u60c5\u51fa\u53d1\u4e0b\u67b6\u524d\u524d\u524d\u524d\u524d" + e.getMessage());
                }
            }
            catch (Exception e) {
                log.info("\u7535\u5546\u4e0b\u67b6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        rspBo.setRows(rows);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"qryListSkuState"})
    public UccMallQryListSkuStateRspBO qryListSkuState(@RequestBody UccMallQryListSkuStateReqBO reqBo) {
        UccMallQryListSkuStateRspBO rspBo = new UccMallQryListSkuStateRspBO();
        if (null == reqBo || null == reqBo.getListInfo()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List listInfo = reqBo.getListInfo();
        if (null == listInfo || listInfo.size() == 0) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List poList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)listInfo), UccQrySkuStateInfoPO.class);
        List<UccSkuPo> skuPoList = this.uccMallSkuMapper.qerySkuStatusList(poList);
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        HashMap map = new HashMap();
        for (UccMallQrySkuStateInfoBO bo : listInfo) {
            ArrayList<UccSkuPo> newList = new ArrayList<UccSkuPo>();
            for (UccSkuPo po : skuPoList) {
                if (!bo.getSupplierShopId().equals(po.getSupplierShopId())) continue;
                newList.add(po);
            }
            map.put(bo.getSupplierShopId(), newList);
        }
        ArrayList<UccMallQrySkuStateBO> skuStateBOList = new ArrayList<UccMallQrySkuStateBO>();
        UccSkuPo uccSkuPo = null;
        for (Long key : map.keySet()) {
            List skuPoList1 = (List)map.get(key);
            Long supplierId = key;
            InterfaceSkuStateReqBO uccSkuStateReqBo = new InterfaceSkuStateReqBO();
            UccMallQrySkuStateBO skuStateBO = new UccMallQrySkuStateBO();
            ArrayList<String> extSkuIds = new ArrayList<String>();
            String supplierCode = null;
            for (UccSkuPo po : skuPoList1) {
                uccSkuPo = po;
                if (uccSkuPo.getSkuSource() != 2) {
                    if (uccSkuPo.getSkuStatus() != 3) {
                        skuStateBO = new UccMallQrySkuStateBO();
                        skuStateBO.setSkuId(po.getSkuId());
                        skuStateBO.setSupplierShopId(po.getSupplierShopId());
                        skuStateBO.setStatus("2");
                        skuStateBOList.add(skuStateBO);
                        continue;
                    }
                    skuStateBO = new UccMallQrySkuStateBO();
                    skuStateBO.setSkuId(po.getSkuId());
                    skuStateBO.setSupplierShopId(po.getSupplierShopId());
                    skuStateBO.setStatus("1");
                    skuStateBOList.add(skuStateBO);
                    continue;
                }
                if (uccSkuPo.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
                    SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(po.getSupplierShopId());
                    if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
                        rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
                        rspBo.setRespCode("8888");
                        return rspBo;
                    }
                    supplierId = supplierShopPo.getSupplierId();
                    SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
                    if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
                        rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
                        rspBo.setRespCode("8888");
                        return rspBo;
                    }
                    supplierCode = supplierBusiPo.getSupplierCode();
                    if (StringUtils.isEmpty((Object)uccSkuPo.getExtSkuId())) continue;
                    extSkuIds.add(uccSkuPo.getExtSkuId());
                    continue;
                }
                skuStateBO = new UccMallQrySkuStateBO();
                skuStateBO.setSkuId(po.getSkuId());
                skuStateBO.setSupplierShopId(po.getSupplierShopId());
                skuStateBO.setStatus("2");
                skuStateBOList.add(skuStateBO);
            }
            if (CollectionUtils.isEmpty(extSkuIds)) continue;
            uccSkuStateReqBo.setExtSkuIds(extSkuIds);
            uccSkuStateReqBo.setSupplierId(supplierId);
            uccSkuStateReqBo.setSupplierCode(supplierCode);
            InterfaceSkuStateRsp uccSkuStateRsp = this.interfaceQrySkuStateService.qrySkuStatus(uccSkuStateReqBo);
            if (!"0000".equals(uccSkuStateRsp.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc(uccSkuStateRsp.getRespDesc());
                return rspBo;
            }
            List<InterfaceSkuStateRspBo> stateRspBoList = uccSkuStateRsp.getSkuStates();
            for (InterfaceSkuStateRspBo bo : stateRspBoList) {
                for (UccSkuPo po : skuPoList) {
                    if (!bo.getSku().equals(po.getExtSkuId())) continue;
                    skuStateBO = new UccMallQrySkuStateBO();
                    skuStateBO.setSkuId(po.getSkuId());
                    skuStateBO.setSupplierShopId(supplierId);
                    skuStateBO.setStatus(bo.getState().toString());
                    skuStateBOList.add(skuStateBO);
                }
            }
        }
        rspBo.setResult(skuStateBOList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

