/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService"})
public class UccAgrSkuImportCheckAbilityServiceImpl
implements UccAgrSkuImportCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSkuImportCheckAbilityServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;

    @PostMapping(value={"checkInfo"})
    public UccAgrSkuImportCheckAbilityRspBO checkInfo(@RequestBody UccAgrSkuImportCheckAbilityReqBO reqBO) {
        UccAgrSkuImportCheckAbilityRspBO rspBO = new UccAgrSkuImportCheckAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(reqBO.getRows());
        if (reqBO == null && CollectionUtils.isEmpty((Collection)reqBO.getRows())) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), RspConstantEnums.REQUIRED_NON_EMPTY.message());
        }
        List catalogCodes = reqBO.getRows().stream().map(UccAgrSkuImportCheckBO::getCatalogCode).collect(Collectors.toList());
        List materialCodes = reqBO.getRows().stream().map(UccAgrSkuImportCheckBO::getMaterialCode).collect(Collectors.toList());
        List measureNames = reqBO.getRows().stream().map(UccAgrSkuImportCheckBO::getMeasureName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(catalogCodes) || CollectionUtils.isEmpty(materialCodes) || CollectionUtils.isEmpty(measureNames)) {
            throw new BusinessException(RspConstantEnums.REQUIRED_NON_EMPTY.code(), RspConstantEnums.REQUIRED_NON_EMPTY.message());
        }
        List eMdmCatalogPOList = this.uccEMdmCatalogMapper.batchQryCatalogwithType(catalogCodes);
        if (CollectionUtils.isEmpty((Collection)eMdmCatalogPOList)) {
            throw new BusinessException(RspConstantEnums.AGR_CHECK_NOT_EXIST_CATALOG_CODE.code(), RspConstantEnums.AGR_CHECK_NOT_EXIST_CATALOG_CODE.message());
        }
        Map<Object, Object> uccCatalogMap = new HashMap();
        try {
            uccCatalogMap = eMdmCatalogPOList.stream().collect(Collectors.toMap(UccEMdmCatalogPO::getCatalogCode, Function.identity()));
        }
        catch (Exception e) {
            log.error("\u5206\u7c7b\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
            throw new BusinessException(RspConstantEnums.AGR_CHECK_CATALOG_REL_TYPE_EXCEPRION.code(), RspConstantEnums.AGR_CHECK_CATALOG_REL_TYPE_EXCEPRION.message());
        }
        List uccEMdmMaterialPOList = this.uccEMdmMaterialMapper.queryListByCodes(materialCodes, Integer.valueOf(0), Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOList)) {
            throw new BusinessException(RspConstantEnums.AGR_CHECK_NOT_EXIST_MATERIAL_CODE.code(), RspConstantEnums.AGR_CHECK_NOT_EXIST_MATERIAL_CODE.message());
        }
        Map uccMaterialMap = uccEMdmMaterialPOList.stream().collect(Collectors.toMap(UccEMdmMaterialPO::getMaterialCode, Function.identity(), (key1, key2) -> key2));
        UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
        uccCommodityMeasurePo.setIsDelete(Integer.valueOf(0));
        List measurePoList = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
        if (CollectionUtils.isEmpty((Collection)measurePoList)) {
            throw new BusinessException(RspConstantEnums.AGR_CHECK_NOT_EXIST_MEASURENAME.code(), RspConstantEnums.AGR_CHECK_NOT_EXIST_MEASURENAME.message());
        }
        Map<String, Long> measureMap = measurePoList.stream().collect(Collectors.toMap(UccCommodityMeasurePo::getMeasureName, UccCommodityMeasurePo::getMeasureId, (key1, key2) -> key2));
        for (UccAgrSkuImportCheckBO each : rspBO.getRows()) {
            if (uccCatalogMap.containsKey(each.getCatalogCode())) {
                if (!each.getCommodityTypeName().equals(((UccEMdmCatalogPO)uccCatalogMap.get(each.getCatalogCode())).getCommodityTypeName())) {
                    each.setReson("\u5546\u54c1\u7c7b\u578b\u540d\u79f0" + each.getCommodityTypeName() + " \u4e0e\u7269\u6599\u7f16\u7801" + each.getCatalogCode() + " \u4e0d\u5339\u914d");
                    continue;
                }
                each.setPass(true);
                each.setCatalogId(((UccEMdmCatalogPO)uccCatalogMap.get(each.getCatalogCode())).getCatalogId());
                each.setCommodityTypeId(((UccEMdmCatalogPO)uccCatalogMap.get(each.getCatalogCode())).getCommodityTypeId());
                if (uccMaterialMap.containsKey(each.getMaterialCode())) {
                    each.setMaterialId(((UccEMdmMaterialPO)uccMaterialMap.get(each.getMaterialCode())).getMaterialId());
                    if (((UccEMdmMaterialPO)uccMaterialMap.get(each.getMaterialCode())).getCatalogId().compareTo(each.getCatalogId()) != 0) {
                        each.setPass(false);
                        each.setReson("\u7269\u8d44\u7f16\u7801" + each.getMaterialCode() + " \u4e0e\u5206\u7c7b\u7f16\u7801" + each.getCatalogCode() + " \u4e0d\u5339\u914d");
                        continue;
                    }
                } else {
                    each.setPass(false);
                    each.setReson("\u7269\u8d44\u7f16\u7801 " + each.getMaterialCode() + " \u4e0d\u5b58\u5728\u6216\u505c\u7528");
                    continue;
                }
                if (!measureMap.containsKey(each.getMeasureName())) {
                    each.setPass(false);
                    each.setReson("\u8ba1\u91cf\u5355\u4f4d " + each.getMeasureName() + " \u4e0d\u5b58\u5728\u6216\u505c\u7528");
                    continue;
                }
                each.setMeasureId(measureMap.get(each.getMeasureName()));
                continue;
            }
            each.setReson(each.getCatalogCode() + "\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528");
        }
        return rspBO;
    }
}

