/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.UccAgrScopeSyncBO;
import com.tydic.commodity.zone.ability.bo.UccUpdateSaleNumBo;
import com.tydic.commodity.zone.ability.bo.UccUpdateSalesVolumeBO;
import com.tydic.commodity.zone.comb.api.UccDealAgrMessageService;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealAgrMessageServiceImpl
implements UccDealAgrMessageService {
    private static final Logger log = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UccDealAgrMessageServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired(required=true)
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    private static final String allRange = "*";
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;

    @Override
    public RspUccBo dealMessage(AgrMessageBo reqBO) {
        RspUccBo rspBO = new RspUccBo();
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)reqBO));
        if (reqBO.getCommiditySkuStatus() != null) {
            try {
                List uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                    Map<Long, List<UccSkuPo>> supplierShopIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                    for (Map.Entry<Long, List<UccSkuPo>> entry : supplierShopIdMap.entrySet()) {
                        Long supplierShopId = entry.getKey();
                        List<UccSkuPo> pos = entry.getValue();
                        Set skuIds = pos.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
                        if (reqBO.getCommiditySkuStatus().equals(20)) {
                            this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), Lists.newArrayList(skuIds), supplierShopId, reqBO.getCommiditySkuStatus());
                            continue;
                        }
                        this.updateSkuStatus(reqBO.getCommiditySkuStatus(), Lists.newArrayList(skuIds), supplierShopId, null);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getAgrScopeSyncBOs())) {
            List uccOrgSkuWhiteRestrictionPos;
            List agrIds = reqBO.getAgrScopeSyncBOs().stream().map(a -> a.getAgreementId()).collect(Collectors.toList());
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(agrIds) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccOrgSkuWhiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(agrIds, null, Integer.valueOf(1))))) {
                Set orgPaths = uccOrgSkuWhiteRestrictionPos.stream().filter(a -> !StringUtils.isEmpty((String)a.getOrgTreePath())).map(a -> a.getOrgTreePath()).collect(Collectors.toSet());
                this.uccOrgSkuWhiteRestrictionMapper.deleteListByAgr(agrIds, null);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgPaths)) {
                    Object orgPos;
                    List uccOrgSkuWhiteRestrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(null, (List)Lists.newArrayList((Iterable)orgPaths), Integer.valueOf(1));
                    HashMap white = new HashMap();
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccOrgSkuWhiteRestrictionPoList)) {
                        orgPos = uccOrgSkuWhiteRestrictionPoList.stream().filter(a -> a.getAgreementId() != null).collect(Collectors.groupingBy(a -> a.getOrgTreePath()));
                        for (Map.Entry each : orgPos.entrySet()) {
                            List agrIdList = ((List)each.getValue()).stream().filter(a -> a.getAgreementId() != null).map(a -> a.getAgreementId()).collect(Collectors.toList());
                            white.put(each.getKey(), agrIdList);
                        }
                    }
                    orgPos = orgPaths.iterator();
                    while (orgPos.hasNext()) {
                        String key = (String)orgPos.next();
                        if (white.containsKey(key)) {
                            this.cacheClient.set(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString(), white.get(key));
                            continue;
                        }
                        this.cacheClient.delete(new StringBuffer("UCC_ORG_AGR_WHITELIST_RESTRICTION").append(key).toString());
                    }
                }
            }
            this.insertWhiteList(reqBO);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List skuChangePriceBOS = reqBO.getSkuChangePriceBOs();
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            for (SkuChangePriceBO skuChangePriceBO : skuChangePriceBOS) {
                List uccSkuPos;
                if (skuChangePriceBO.getCommiditySkuStatus() != null) {
                    try {
                        List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds((List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementId()}), (List)Lists.newArrayList((Object[])new Long[]{skuChangePriceBO.getAgreementSkuId()}));
                        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuPos2)) continue;
                        Map<Long, List<UccSkuPo>> supplierShopIdMap = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                        for (Map.Entry<Long, List<UccSkuPo>> entry : supplierShopIdMap.entrySet()) {
                            Long supplierShopId = entry.getKey();
                            List<UccSkuPo> pos = entry.getValue();
                            Set skuIds = pos.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
                            this.updateSkuStatus(skuChangePriceBO.getCommiditySkuStatus(), Lists.newArrayList(skuIds), supplierShopId, null);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
                Long agreementId = null;
                String agreementDetailId = null;
                if (skuChangePriceBO.getAgreementId() != null) {
                    agreementId = skuChangePriceBO.getAgreementId();
                }
                if (skuChangePriceBO.getAgreementSkuId() != null) {
                    agreementDetailId = String.valueOf(skuChangePriceBO.getAgreementSkuId());
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailId(agreementId, Long.valueOf(agreementDetailId))))) continue;
                if (skuChangePriceBO.getBuyNumber() != null) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(skuChangePriceBO.getBuyNumber().longValue()));
                    smcsdkStockNumInfoBO.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId().toString());
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    try {
                        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        uccSkuPricePo.setSalePrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        uccSkuPricePo.setAgreementPrice(Long.valueOf(skuChangePriceBO.getBuyPrice().longValue()));
                        this.uccSkuPriceMapper.updateSkuPrice(uccSkuPricePo);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4fe1\u606f\u5931\u8d25");
                    }
                    try {
                        UccSkuPo uccSkuPo1 = new UccSkuPo();
                        uccSkuPo1.setSkuId(uccSkuPo.getSkuId());
                        uccSkuPo1.setSupplierShopId(uccSkuPo.getSupplierShopId());
                        if (skuChangePriceBO.getSalePrice() != null) {
                            uccSkuPo1.setSkuPrice(Long.valueOf(skuChangePriceBO.getSalePrice().longValue()));
                        }
                        this.uccSkuMapper.updateSku(uccSkuPo1);
                        BigDecimal salePrice = skuChangePriceBO.getSalePrice();
                        this.updateLadderPrice(uccSkuPo.getSkuId(), uccSkuPo.getSupplierShopId(), salePrice);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new BusinessException("8888", "\u4fee\u6539\u4ef7\u683c\u4fe1\u606f\u5931\u8d25");
                    }
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                smcsdkOperateStockNumReqBO.setOperateType("11");
                if (((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId() == null) {
                    smcsdkOperateStockNumReqBO.setObjectId("111111");
                } else {
                    smcsdkOperateStockNumReqBO.setObjectId(((SkuChangePriceBO)reqBO.getSkuChangePriceBOs().get(0)).getAgreementId().toString());
                }
                smcsdkOperateStockNumReqBO.setObjectType("20");
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                    }
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
            if (reqBO.getSkuStockInvalidBO() != null && reqBO.getSkuStockInvalidBO().getSkuStatus() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuStockInvalidBO().getAgreementSkuIds())) {
                try {
                    List uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(null, reqBO.getSkuStockInvalidBO().getAgreementSkuIds());
                    if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                        Map<Long, List<UccSkuPo>> supplierShopIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                        for (Map.Entry<Long, List<UccSkuPo>> entry : supplierShopIdMap.entrySet()) {
                            Long supplierShopId = entry.getKey();
                            List<UccSkuPo> pos = entry.getValue();
                            Set skuIds = pos.stream().map(a -> a.getSkuId()).collect(Collectors.toSet());
                            if (reqBO.getSkuStockInvalidBO().getSkuStatus().equals(20)) {
                                log.info("\u534f\u8bae\u53d1\u8d77\u53d8\u66f4\uff0c\u72b6\u6001\u8c03\u6574\u4e3a\u5931\u6548\u65f6\uff0c\u5219\u5c06\u8be5\u660e\u7ec6\u5bf9\u5e94\u7684\u5546\u54c1\u7f6e\u4e3a\u4e0b\u67b6\uff1b");
                                this.updateSkuStatus(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), Lists.newArrayList(skuIds), supplierShopId, reqBO.getSkuStockInvalidBO().getSkuStatus());
                                continue;
                            }
                            this.updateSkuStatus(reqBO.getSkuStockInvalidBO().getSkuStatus(), Lists.newArrayList(skuIds), supplierShopId, null);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        this.dealSkuSyncEs(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u5904\u7406\u6210\u529f");
        LOGGER.info("\u5904\u7406\u534f\u8bae\u4e2d\u5fc3\u6d88\u606f\u6210\u529f");
        return rspBO;
    }

    private void dealSkuSyncEs(AgrMessageBo reqBO) {
        Map<Long, List<UccSkuPo>> shopIdMap;
        List uccSkuPos;
        Map<Object, Object> groupBySupplier = new HashMap();
        if ((org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementIds()) || org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getAgreementSkuIds())) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(reqBO.getAgreementIds(), reqBO.getAgreementSkuIds())))) {
            groupBySupplier = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agreementDetailIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementSkuId).collect(Collectors.toList());
            List agreementIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            List uccSkuPos2 = this.uccSkuMapper.selectByAgreementDetailIds(agreementIds, agreementDetailIds);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uccSkuPos2)) {
                groupBySupplier = uccSkuPos2.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
            }
        }
        if (reqBO.getSkuStockInvalidBO() != null && reqBO.getSkuStockInvalidBO().getSkuStatus() != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getSkuStockInvalidBO().getAgreementSkuIds()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(uccSkuPos = this.uccSkuMapper.selectByAgreementDetailIds(null, reqBO.getSkuStockInvalidBO().getAgreementSkuIds()))) && (shopIdMap = uccSkuPos.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId))) != null) {
            Set<Long> shopIds = shopIdMap.keySet();
            for (Long shopId : shopIds) {
                if (groupBySupplier.keySet().contains(shopId)) {
                    List uccSkuPoList = (List)groupBySupplier.get(shopId);
                    uccSkuPoList.addAll((Collection)shopIdMap.get(shopId));
                    continue;
                }
                groupBySupplier.put(shopId, shopIdMap.get(shopId));
            }
        }
        for (Map.Entry entry : groupBySupplier.entrySet()) {
            ArrayList skuIds = new ArrayList();
            skuIds.addAll(((List)entry.getValue()).stream().map(UccSkuPo::getSkuId).collect(Collectors.toSet()));
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skuIds));
            syncSceneCommodityToEsReqBO.setSupplierId((Long)entry.getKey());
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                LOGGER.error("\u540c\u6b65\u5546\u54c1\u72b6\u6001\u548c\u4ef7\u683c\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
            }
        }
    }

    private void updateLadderPrice(Long skuId, Long supplierShopId, BigDecimal salePrice) {
        List uccLadderPriceList = this.uccLadderPriceMapper.selectBySkuId(skuId, supplierShopId);
        for (UccLadderPricePO uccLadderPrice : uccLadderPriceList) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            BigDecimal discount = uccLadderPrice.getDiscount();
            if (discount == null) continue;
            BigDecimal price = discount.multiply(salePrice);
            uccLadderPricePO.setPrice(Long.valueOf(price.longValue()));
            uccLadderPricePO.setId(uccLadderPrice.getId());
            this.uccLadderPriceMapper.updateByExampleSelective(uccLadderPricePO);
        }
    }

    private void dealStock(UccUpdateSalesVolumeBO uccUpdateSaleNumBo) {
        if (uccUpdateSaleNumBo == null) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccUpdateSaleNumBo.getSaleNumBos())) {
            return;
        }
        Map<Integer, List<UccUpdateSaleNumBo>> map = uccUpdateSaleNumBo.getSaleNumBos().stream().filter(a -> a.getIncOrDec() != null).collect(Collectors.groupingBy(UccUpdateSaleNumBo::getIncOrDec));
        if (!CollectionUtils.isEmpty(map)) {
            for (Map.Entry<Integer, List<UccUpdateSaleNumBo>> each : map.entrySet()) {
                List<UccUpdateSaleNumBo> uccUpdateSaleNumBos = each.getValue();
                ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
                for (UccUpdateSaleNumBo uccUpdateSaleNumBo1 : uccUpdateSaleNumBos) {
                    SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
                    smcsdkStockNumInfoBO.setSkuId(uccUpdateSaleNumBo1.getSkuId().toString());
                    smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(uccUpdateSaleNumBo1.getSoldNumber().longValue()));
                    smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
                }
                SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
                smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
                if (each.getKey() == 1) {
                    smcsdkOperateStockNumReqBO.setOperateType("40");
                } else if (each.getKey() == 0) {
                    smcsdkOperateStockNumReqBO.setOperateType("11");
                }
                try {
                    log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                    SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                    if ("0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                        log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                        continue;
                    }
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
                }
            }
        }
    }

    private void insertWhiteList(AgrMessageBo reqBO) {
        ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
        ArrayList agrASpu = new ArrayList();
        for (UccAgrScopeSyncBO uccAgrScopeSyncBO : reqBO.getAgrScopeSyncBOs()) {
            if (allRange.equals(uccAgrScopeSyncBO.getScopeCodes())) continue;
            List list = JSONObject.parseArray((String)uccAgrScopeSyncBO.getScopeCodes(), String.class);
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId().toString());
            List commodityPoList = this.uccCommodityMapper.qryCommodity(uccCommodityPo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)commodityPoList)) continue;
            agrASpu.addAll(commodityPoList);
            for (String each : list) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(uccAgrScopeSyncBO.getAgreementId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId("message sync");
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.uccBatchSequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(Long.valueOf(each));
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each);
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
        }
        if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
            return;
        }
        UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
        uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
        try {
            this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        if (!CollectionUtils.isEmpty(agrASpu)) {
            Map<Long, List<UccCommodityPo>> agrSpu = agrASpu.stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId));
            for (Long shopId : agrSpu.keySet()) {
                List spuIds = agrSpu.get(shopId).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(spuIds);
                syncSceneCommodityToEsReqBO.setSupplierId(shopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                if (log.isDebugEnabled()) {
                    LOGGER.debug("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                }
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    LOGGER.error("\u540c\u6b65\u767d\u540d\u5355\u5931\u8d25\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                }
            }
        }
    }

    private void updateSkuStatus(Integer newStatus, List<Long> skus, Long supplierShopId, Integer msgNewStatus) {
        Object uccSkuPos;
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        Map<Object, Object> skuStatusMap = new HashMap();
        Map<Object, Object> skuOldStatusMap = new HashMap();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(skus) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.batchQrySku(skus, null)))) {
            skuStatusMap = uccSkuPos.stream().collect(Collectors.toMap(a -> a.getSkuId(), b -> b.getSkuStatus(), (first, second) -> first));
            skuOldStatusMap = uccSkuPos.stream().filter(a -> a.getAgrOldSkuStatus() != null).collect(Collectors.toMap(a -> a.getSkuId(), b -> b.getAgrOldSkuStatus(), (first, second) -> first));
        }
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_FREEZE == newStatus) {
                bo.setAgrOldSkuStatus((Integer)skuStatusMap.get(each));
            }
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF == newStatus && skuStatusMap.containsKey(each) && ModelRuleConstant.SKU_STATUS_FREEZE == skuStatusMap.get(each) && skuOldStatusMap.containsKey(each)) {
                bo.setSkuStatus((Integer)skuOldStatusMap.get(each));
            }
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setMsgNewStatus(msgNewStatus);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

