/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSpuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.UccCommodityeditorsupdateAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccGoodsinbulktosubmitBusiService;
import com.tydic.commodity.busibase.busi.bo.UccGoodsinbulktosubmitBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccGoodsinbulktosubmitBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrGoodsinbulktosubmitAbilityService;
import com.tydic.commodity.zone.ability.api.UccAgrIteminbulkApplyAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsinbulktosubmitAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrGoodsinbulktosubmitAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkApplyAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkApplyAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrGoodsinbulktosubmitAbilityService"})
public class UccAgrGoodsinbulktosubmitAbilityServiceImpl
implements UccAgrGoodsinbulktosubmitAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrGoodsinbulktosubmitAbilityServiceImpl.class);
    @Autowired
    private UccGoodsinbulktosubmitBusiService uccGoodsinbulktosubmitBusiService;
    @Autowired
    private UccAgrIteminbulkApplyAbilityService uccAgrIteminbulkApplyAbilityService;
    @Value(value="${ARG_EDIT_PROCESS_DEF_ID}")
    private String process;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccCommodityeditorsupdateAtomService uccCommodityeditorsupdateAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;

    @PostMapping(value={"dealAgrGoodsinbulktosubmit"})
    public UccAgrGoodsinbulktosubmitAbilityRspBO dealAgrGoodsinbulktosubmit(@RequestBody UccAgrGoodsinbulktosubmitAbilityReqBO reqBO) {
        UccAgrGoodsinbulktosubmitAbilityRspBO rspBO = new UccAgrGoodsinbulktosubmitAbilityRspBO();
        UccGoodsinbulktosubmitBusiReqBO busiReqBO = new UccGoodsinbulktosubmitBusiReqBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBatchSpuList())) {
            BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
            if (reqBO.getIsSupermarketStaff() != null && reqBO.getIsSupermarketStaff() == 1) {
                busiReqBO.setProcess("M001005");
            } else {
                busiReqBO.setProcess(this.process);
            }
            UccGoodsinbulktosubmitBusiRspBO busiRspBO = null;
            try {
                busiRspBO = this.uccGoodsinbulktosubmitBusiService.dealAgrGoodsinbulktosubmit(busiReqBO);
                BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
            }
            catch (Exception e) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            if (!CollectionUtils.isEmpty((Collection)busiRspBO.getBatchSkuList())) {
                UccAgrIteminbulkApplyAbilityReqBO uccAgrIteminbulkApplyAbilityReqBO = new UccAgrIteminbulkApplyAbilityReqBO();
                uccAgrIteminbulkApplyAbilityReqBO.setBatchSkuList(busiRspBO.getBatchSkuList());
                uccAgrIteminbulkApplyAbilityReqBO.setSameLevel(Integer.valueOf(0));
                uccAgrIteminbulkApplyAbilityReqBO.setIsSupermarketStaff(reqBO.getIsSupermarketStaff());
                UccAgrIteminbulkApplyAbilityRspBO uccAgrIteminbulkApplyAbilityRspBO = this.uccAgrIteminbulkApplyAbilityService.dealPutOnSelf(uccAgrIteminbulkApplyAbilityReqBO);
                if (!"0000".equals(uccAgrIteminbulkApplyAbilityRspBO.getRespCode())) {
                    BeanUtils.copyProperties((Object)uccAgrIteminbulkApplyAbilityRspBO, (Object)rspBO);
                    return rspBO;
                }
            }
            Map<Long, List<UccBatchSpuBO>> mapSpu = reqBO.getBatchSpuList().stream().collect(Collectors.groupingBy(UccBatchSpuBO::getSupplierShopId));
            for (Long supplierShopId : mapSpu.keySet()) {
                List spuId = mapSpu.get(supplierShopId).stream().map(UccBatchSpuBO::getCommodityId).collect(Collectors.toList());
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                syncSceneCommodityToEsReqBO.setCommodityIds(spuId);
                syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                try {
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                }
            }
            if ("0000".equals(busiRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)busiRspBO.getSendNoticeList())) {
                List supIds = busiRspBO.getSendNoticeList();
                UccSendNotificationExtAtomReqBO notificationExtAtomReqBO = new UccSendNotificationExtAtomReqBO();
                notificationExtAtomReqBO.setUserId(reqBO.getUserId());
                notificationExtAtomReqBO.setObjIds(supIds);
                notificationExtAtomReqBO.setFinish(Boolean.valueOf(false));
                notificationExtAtomReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                notificationExtAtomReqBO.setNotificationType(UccConstants.UCC_NOTIFICATION_TYPE.XY_COMMODITY_UPDATE);
                log.debug("\u9700\u8981\u53d1\u9001\u7684\u4ee3\u529e\u5355\u636e\u4e3a{}", (Object)notificationExtAtomReqBO);
                this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSONObject.toJSONString((Object)notificationExtAtomReqBO)));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccAgrGoodsinbulktosubmitAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

