/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrIteminbulkOffApplyAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkOffApplyAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrIteminbulkOffApplyAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrIteminbulkOffApplyAbilityService"})
public class UccAgrIteminbulkOffApplyAbilityServiceImpl
implements UccAgrIteminbulkOffApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrIteminbulkOffApplyAbilityServiceImpl.class);
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Value(value="${ARG_OFF_SHELF_PROCESS}")
    private String process;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;

    @PostMapping(value={"dealAgrOffShelfApply"})
    public UccAgrIteminbulkOffApplyAbilityRspBO dealAgrOffShelfApply(@RequestBody UccAgrIteminbulkOffApplyAbilityReqBO reqBO) {
        List uccSkuPos;
        List skuIds;
        UccAgrIteminbulkOffApplyAbilityRspBO rspBO = new UccAgrIteminbulkOffApplyAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u4e0b\u67b6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSameLevel() == 1) {
            List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            ArrayList<Integer> excludeApprovalStatus = new ArrayList<Integer>();
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO);
            List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, null, skuStatus, null, (List)excludeApprovalStatus);
            if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                sameLevelOtrherSku.stream().forEach(a -> {
                    UccBatchSkuBO bo = new UccBatchSkuBO();
                    bo.setSkuId(a.getSkuId());
                    bo.setSupplierShopId(a.getSupplierShopId());
                    reqBO.getBatchSkuList().add(bo);
                });
            }
        }
        if (!CollectionUtils.isEmpty(skuIds = reqBO.getBatchSkuList().stream().map(a -> a.getSkuId()).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.getSkuForOffShelf(skuIds)))) {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
                    if (!uccBatchSkuBO.getSkuId().equals(uccSkuPo.getSkuId())) continue;
                    uccBatchSkuBO.setIsSupermarketStaff(uccSkuPo.getIsSupermarketStaff());
                    uccBatchSkuBO.setTradeMode(uccSkuPo.getTradeMode());
                }
            }
        }
        ArrayList<UccBatchSkuBO> superMarketSkuList = new ArrayList<UccBatchSkuBO>();
        ArrayList<UccBatchSkuBO> tradeModeSkuList = new ArrayList<UccBatchSkuBO>();
        ArrayList<UccBatchSkuBO> otherSkuList = new ArrayList<UccBatchSkuBO>();
        for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
            if (uccBatchSkuBO.getIsSupermarketStaff() != null && uccBatchSkuBO.getIsSupermarketStaff() == 1) {
                superMarketSkuList.add(uccBatchSkuBO);
                continue;
            }
            if (uccBatchSkuBO.getTradeMode() != null && uccBatchSkuBO.getTradeMode() == 2) {
                tradeModeSkuList.add(uccBatchSkuBO);
                continue;
            }
            otherSkuList.add(uccBatchSkuBO);
        }
        rspBO = this.dealSkuOffShelf(reqBO, superMarketSkuList, "M001007");
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO = this.dealSkuOffShelf(reqBO, tradeModeSkuList, "M001011");
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO = this.dealSkuOffShelf(reqBO, otherSkuList, this.process);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccAgrIteminbulkOffApplyAbilityRspBO dealSkuOffShelf(UccAgrIteminbulkOffApplyAbilityReqBO reqBO, List<UccBatchSkuBO> batchSkuList, String reqProcess) {
        UccAgrIteminbulkOffApplyAbilityRspBO rspBO = new UccAgrIteminbulkOffApplyAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty(batchSkuList)) {
            UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
            UccUpAndOffApplyAbilityRspBO busiRspBO = new UccUpAndOffApplyAbilityRspBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
            busiReqBO.setBatchSkuList(batchSkuList);
            ExtReqBO extReqBO = new ExtReqBO();
            extReqBO.setProcess(reqProcess);
            extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN);
            ArrayList<Integer> oldStatus = new ArrayList<Integer>();
            oldStatus.add(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            extReqBO.setStatusOld(oldStatus);
            extReqBO.setStatusApproval(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            extReqBO.setStatusApply(SkuStatusEnum.FROZEN_STATUS.getStatus());
            extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.toString());
            extReqBO.setOperate(Integer.valueOf(1));
            extReqBO.setRemark("\u624b\u5de5\u4e0b\u67b6");
            try {
                busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
                BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
            }
            catch (Exception e) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            try {
                if ("0000".equals(busiRspBO.getRespCode()) && null != busiRspBO.getUccSendNotificationExtAtomReqBO() && !CollectionUtils.isEmpty((Collection)busiRspBO.getUccSendNotificationExtAtomReqBO().getObjIds())) {
                    this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSONObject.toJSONString((Object)busiRspBO.getUccSendNotificationExtAtomReqBO())));
                }
            }
            catch (Exception e) {
                log.info("\u4ee3\u529e\u901a\u77e5\u53d1\u9001\u5931\u8d25" + e);
            }
        }
        return rspBO;
    }
}

