/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.bo.UccDealHandlerTaskJobAbilityReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerTaskJobBusiService;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccBrandSkuOnCheckAbilityService;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccBrandSkuOnCheckAbilityRspBo;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccAgrItemBatchBackonApplyAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrItemBatchBackonApplyAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrItemBatchBackonApplyAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccAgrItemBatchBackonApplyAbilityService"})
public class UccAgrItemBatchBackonApplyAbilityServiceImpl
implements UccAgrItemBatchBackonApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrItemBatchBackonApplyAbilityServiceImpl.class);
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Value(value="${ARG_REINSTATE_PROCESS}")
    private String process;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccBrandSkuOnCheckAbilityService uccBrandSkuOnCheckAbilityService;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;
    @Autowired
    private UccDealHandlerTaskJobBusiService uccDealHandlerTaskJobBusiService;

    @PostMapping(value={"dealAgrBackonApply"})
    public UccAgrItemBatchBackonApplyAbilityRspBO dealAgrBackonApply(@RequestBody UccAgrItemBatchBackonApplyAbilityReqBO reqBO) {
        List uccSkuPos;
        List skuIds;
        UccAgrItemBatchBackonApplyAbilityRspBO rspBO = new UccAgrItemBatchBackonApplyAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u6062\u590d\u4e0a\u67b6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        UccBrandSkuOnCheckAbilityReqBo uccBrandSkuOnCheckAbilityReqBo = new UccBrandSkuOnCheckAbilityReqBo();
        uccBrandSkuOnCheckAbilityReqBo.setSkuIds(reqBO.getBatchSkuList().stream().map(a -> a.getSkuId()).collect(Collectors.toList()));
        UccBrandSkuOnCheckAbilityRspBo uccBrandSkuOnCheckAbilityRspBo = this.uccBrandSkuOnCheckAbilityService.checkSkuOn(uccBrandSkuOnCheckAbilityReqBo);
        if (!"0000".equals(uccBrandSkuOnCheckAbilityRspBo.getRespCode())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(uccBrandSkuOnCheckAbilityRspBo.getRespDesc());
            return rspBO;
        }
        if (reqBO.getSameLevel() == 1) {
            List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            skuStatus.add(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
            ArrayList excludeApprovalStatus = new ArrayList();
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO);
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO);
            List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, null, skuStatus, null, (List)excludeApprovalStatus);
            if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                sameLevelOtrherSku.stream().forEach(a -> {
                    UccBatchSkuBO bo = new UccBatchSkuBO();
                    bo.setSkuId(a.getSkuId());
                    bo.setSupplierShopId(a.getSupplierShopId());
                    reqBO.getBatchSkuList().add(bo);
                });
            }
        }
        if (!CollectionUtils.isEmpty(skuIds = reqBO.getBatchSkuList().stream().map(a -> a.getSkuId()).collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(uccSkuPos = this.uccSkuMapper.getSkuForOffShelf(skuIds)))) {
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
                    if (!uccBatchSkuBO.getSkuId().equals(uccSkuPo.getSkuId())) continue;
                    uccBatchSkuBO.setIsSupermarketStaff(uccSkuPo.getIsSupermarketStaff());
                    uccBatchSkuBO.setTradeMode(uccSkuPo.getTradeMode());
                }
            }
        }
        ArrayList<UccBatchSkuBO> superMarketSkuList = new ArrayList<UccBatchSkuBO>();
        ArrayList<UccBatchSkuBO> tradeModeSkuList = new ArrayList<UccBatchSkuBO>();
        ArrayList<UccBatchSkuBO> otherSkuList = new ArrayList<UccBatchSkuBO>();
        for (UccBatchSkuBO uccBatchSkuBO : reqBO.getBatchSkuList()) {
            if (uccBatchSkuBO.getIsSupermarketStaff() != null && uccBatchSkuBO.getIsSupermarketStaff() == 1) {
                superMarketSkuList.add(uccBatchSkuBO);
                continue;
            }
            if (uccBatchSkuBO.getTradeMode() != null && uccBatchSkuBO.getTradeMode() == 2) {
                tradeModeSkuList.add(uccBatchSkuBO);
                continue;
            }
            otherSkuList.add(uccBatchSkuBO);
        }
        rspBO = this.dealSkuOffShelf(reqBO, superMarketSkuList, "M001008");
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO = this.dealSkuOffShelf(reqBO, tradeModeSkuList, "M001012");
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        rspBO = this.dealSkuOffShelf(reqBO, otherSkuList, this.process);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        for (Long supplierShopId : mapSku.keySet()) {
            List skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
            try {
                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
            }
            catch (Exception e) {
                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }

    private UccAgrItemBatchBackonApplyAbilityRspBO dealSkuOffShelf(UccAgrItemBatchBackonApplyAbilityReqBO reqBO, List<UccBatchSkuBO> batchSkuList, String reqProcess) {
        UccAgrItemBatchBackonApplyAbilityRspBO rspBO = new UccAgrItemBatchBackonApplyAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty(batchSkuList)) {
            UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
            UccUpAndOffApplyAbilityRspBO busiRspBO = new UccUpAndOffApplyAbilityRspBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
            busiReqBO.setBatchSkuList(batchSkuList);
            ExtReqBO extReqBO = new ExtReqBO();
            extReqBO.setProcess(reqProcess);
            extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
            ArrayList<Integer> oldStatus = new ArrayList<Integer>();
            oldStatus.add(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            oldStatus.add(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
            extReqBO.setStatusOld(oldStatus);
            extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            extReqBO.setStatusApply(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.toString());
            extReqBO.setRemark("\u6062\u590d\u4e0a\u67b6");
            try {
                busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
                BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
                UccDealHandlerTaskJobAbilityReqBO abilityReqBO = new UccDealHandlerTaskJobAbilityReqBO();
                abilityReqBO.setAbPush(Boolean.valueOf(true));
                this.uccDealHandlerTaskJobBusiService.dealHandlerTaskJob(abilityReqBO);
            }
            catch (Exception e) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            try {
                if ("0000".equals(busiRspBO.getRespCode()) && null != busiRspBO.getUccSendNotificationExtAtomReqBO() && !CollectionUtils.isEmpty((Collection)busiRspBO.getUccSendNotificationExtAtomReqBO().getObjIds())) {
                    this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSONObject.toJSONString((Object)busiRspBO.getUccSendNotificationExtAtomReqBO())));
                }
            }
            catch (Exception e) {
                log.info("\u4ee3\u529e\u901a\u77e5\u53d1\u9001\u5931\u8d25" + e);
            }
        }
        return rspBO;
    }
}

