/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.general.ability.bo;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cpcn.dsp.institution.api.codec.Base64;
import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.tx.TxBaseRequest;
import cpcn.dsp.institution.api.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BankCardRequestReqBo
extends TxBaseRequest {
    private static final Logger log = LoggerFactory.getLogger(BankCardRequestReqBo.class);
    private String institutionID;
    private String txSN;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String accountNumber;
    private String phoneNumber;
    private String transCode;
    private String scName;
    private String scUsageScenarios;
    private String scUsePurpose;
    private String protocolVerNm;
    private String serialNm;
    private String remark;
    private String txCode = "2123";
    protected String TxCode;
    protected String InstitutionID;
    protected String TxSN;
    protected String Name;
    protected String IdentificationType;
    protected String IdentificationNumber;
    protected String PhoneNumber;
    protected String requestMessage;
    protected String requestSignature;
    protected String requestDgtlEnvlp;
    protected String requestSignSN;
    protected String requestEncryptSN;

    public void process() throws Exception {
        JSONObject json = new JSONObject();
        json.put("InstitutionID", (Object)this.institutionID);
        json.put("TxCode", (Object)this.txCode);
        json.put("TxSN", (Object)this.txSN);
        json.put("IdentificationType", (Object)this.identificationType);
        json.put("IdentificationNumber", (Object)this.identificationNumber);
        json.put("Remark", (Object)this.remark);
        json.put("Name", (Object)this.name);
        if (!StringUtils.isEmpty((Object)this.phoneNumber)) {
            json.put("PhoneNumber", (Object)this.phoneNumber);
        }
        log.error("\u62a5\u6587\u5904\u7406\u8f6c\u6362\u6210json++++++++++++++++++++++++:" + json.toJSONString());
        this.postProcess(json);
    }

    public Map<String, String> getSendParamMap() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String jsonStr = null;
        ObjectMapper objectMapper = new ObjectMapper();
        paramMap.put("TxCode", this.TxCode);
        paramMap.put("InstitutionID", this.InstitutionID);
        paramMap.put("TxSN", this.TxSN);
        paramMap.put("Name", this.Name);
        paramMap.put("IdentificationType", this.IdentificationType);
        paramMap.put("IdentificationNumber", this.IdentificationNumber);
        paramMap.put("PhoneNumber", this.PhoneNumber);
        paramMap.put("message", this.requestMessage);
        paramMap.put("signature", this.requestSignature);
        paramMap.put("dgtlenvlp", this.requestDgtlEnvlp);
        paramMap.put("signSN", this.requestSignSN);
        paramMap.put("encryptSN", this.requestEncryptSN);
        paramMap.put("institutionID", this.institutionID);
        try {
            jsonStr = objectMapper.writeValueAsString(paramMap);
            log.error("\u62a5\u6587\u5904\u7406\u8f6c\u6362\u6210MAP++++++++++++++++++++++++:" + jsonStr);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error("\u62a5\u6587\u5904\u7406\u8f6c\u6362\u6210MAP\u9519\u8bef++++++++++++++++++++++++:" + jsonStr);
        }
        return paramMap;
    }

    protected void postProcess(JSONObject jsonObject) throws Exception {
        this.TxCode = jsonObject.getString("TxCode");
        this.InstitutionID = jsonObject.getString("InstitutionID");
        this.TxSN = jsonObject.getString("TxSN");
        this.Name = jsonObject.getString("Name");
        this.IdentificationType = jsonObject.getString("IdentificationType");
        this.IdentificationNumber = jsonObject.getString("IdentificationNumber");
        this.PhoneNumber = jsonObject.getString("PhoneNumber");
        this.remark = jsonObject.getString("Remark");
        this.requestPlainText = jsonObject.toString();
        byte[] data = this.requestPlainText.getBytes("UTF-8");
        if ("10".equals(DSPInstitutionEnvironment.msgEncryptType)) {
            this.requestMessage = new String(Base64.encode((byte[])data));
            this.requestEncryptSN = SignatureFactory.getVerifier().getSN();
        } else if ("20".equals(DSPInstitutionEnvironment.msgEncryptType) || "30".equals(DSPInstitutionEnvironment.msgEncryptType)) {
            this.requestSignSN = SignatureFactory.getSigner().getSN();
            this.requestEncryptSN = SignatureFactory.getVerifier().getSN();
            String randomKeyData = SignatureFactory.getSigner().getSymmetricCipher();
            byte[] randomKey = randomKeyData.getBytes("UTF-8");
            this.requestDgtlEnvlp = SignatureFactory.getVerifier((String)this.requestEncryptSN).asymmetricEncrypt(randomKey);
            this.requestMessage = SignatureFactory.getVerifier((String)this.requestEncryptSN).symmetricEncrypt(this.requestPlainText, randomKeyData);
        }
        byte[] signature = SignatureFactory.getSigner().sign(data);
        this.requestSignature = StringUtil.bytes2hex((byte[])signature);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public void setInstitutionID(String institutionID) {
        this.institutionID = institutionID;
    }

    public String getTxSN() {
        return this.txSN;
    }

    public void setTxSN(String txSN) {
        this.txSN = txSN;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getTransCode() {
        return this.transCode;
    }

    public void setTransCode(String transCode) {
        this.transCode = transCode;
    }

    public String getScName() {
        return this.scName;
    }

    public void setScName(String scName) {
        this.scName = scName;
    }

    public String getScUsageScenarios() {
        return this.scUsageScenarios;
    }

    public void setScUsageScenarios(String scUsageScenarios) {
        this.scUsageScenarios = scUsageScenarios;
    }

    public String getScUsePurpose() {
        return this.scUsePurpose;
    }

    public void setScUsePurpose(String scUsePurpose) {
        this.scUsePurpose = scUsePurpose;
    }

    public String getProtocolVerNm() {
        return this.protocolVerNm;
    }

    public void setProtocolVerNm(String protocolVerNm) {
        this.protocolVerNm = protocolVerNm;
    }

    public String getSerialNm() {
        return this.serialNm;
    }

    public void setSerialNm(String serialNm) {
        this.serialNm = serialNm;
    }

    public String getTxCode() {
        return this.txCode;
    }

    public void setTxCode(String txCode) {
        this.txCode = txCode;
    }

    public String getRequestPlainText() {
        return this.requestPlainText;
    }

    public void setRequestPlainText(String requestPlainText) {
        this.requestPlainText = requestPlainText;
    }

    public String getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public void setRequestSignature(String requestSignature) {
        this.requestSignature = requestSignature;
    }

    public String getRequestDgtlEnvlp() {
        return this.requestDgtlEnvlp;
    }

    public void setRequestDgtlEnvlp(String requestDgtlEnvlp) {
        this.requestDgtlEnvlp = requestDgtlEnvlp;
    }

    public String getRequestSignSN() {
        return this.requestSignSN;
    }

    public void setRequestSignSN(String requestSignSN) {
        this.requestSignSN = requestSignSN;
    }

    public String getRequestEncryptSN() {
        return this.requestEncryptSN;
    }

    public void setRequestEncryptSN(String requestEncryptSN) {
        this.requestEncryptSN = requestEncryptSN;
    }
}

