/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.auth.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.umc.security.auth.filter.ExtRspBO;
import com.tydic.umc.security.util.IpAddressUtil;
import com.tydic.umc.security.util.RegexUtils;
import com.tydic.umc.security.util.SSLClient;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class ExtTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(ExtTokenAuthenticationFilter.class);
    @Value(value="${AUTH_INTF_URL:http://39.96.39.0/auth/getUserInfo}")
    private String URL;
    @Value(value="${NOAUTH_URI:/**/noauth/**}")
    private String NOAUTH;
    private static final String RSP_CODE_SUCCESS = "0";
    private static final String RSP_DESC_SUCCESS = "\u9274\u6743\u6210\u529f";
    private static final String RSP_CODE_FAILUR = "1";
    private static final String RSP_DESC_FAILUR = "\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
    private final String TOKEN_KEY = "auth-token";
    private final Long ERR_USER_ID = 0L;
    @Value(value="${noauth.url.resources:127.0.0.1}")
    private String noauthUrlResources;
    @Value(value="${noauth.url.path.resources:url}")
    private String noauthUrlPathResources;
    @Value(value="${noauth.url.enable:true}")
    private String noauthUrlEnable;

    public void attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        ExtRspBO extRspBO;
        String result;
        Cookie[] cookies;
        String token = request.getHeader("auth-token");
        if (StringUtils.isBlank((CharSequence)token) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("auth-token")) continue;
                token = cookies[i].getValue();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5f53\u524dtoken:{}", (Object)token);
        }
        JSONObject rspJson = new JSONObject();
        rspJson.put("code", (Object)RSP_CODE_FAILUR);
        rspJson.put("message", (Object)RSP_DESC_FAILUR);
        if (!StringUtils.isBlank((CharSequence)token) && !StringUtils.isBlank((CharSequence)(result = SSLClient.doPost(this.URL, token))) && RSP_CODE_SUCCESS.equals((extRspBO = (ExtRspBO)JSON.parseObject((String)result, ExtRspBO.class)).getCode()) && null != extRspBO.getData() && !this.ERR_USER_ID.equals(extRspBO.getData().getUserId())) {
            return;
        }
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(401);
        PrintWriter out = response.getWriter();
        String rspJsonStr = JSON.toJSONString((Object)rspJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(rspJsonStr);
        out.close();
        if (log.isDebugEnabled()) {
            log.debug("\u7ed3\u679c:{}", (Object)rspJsonStr);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String url = request.getRequestURI();
        boolean needToken = true;
        if (RegexUtils.wildcardEquals("**" + this.NOAUTH, url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**" + this.NOAUTH, url)) {
            needToken = false;
        }
        if (StringUtils.isNotBlank((CharSequence)this.noauthUrlPathResources)) {
            String[] split;
            Boolean checkBool = false;
            for (String path : split = this.noauthUrlPathResources.split(";")) {
                if (!path.equals(url)) continue;
                checkBool = true;
            }
            if (checkBool.booleanValue()) {
                this.checkNoauthIp(request);
            }
        }
        if (needToken) {
            this.attemptAuthentication(request, response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void checkNoauthIp(HttpServletRequest request) {
        if (!this.noauthUrlEnable.equals("true")) {
            return;
        }
        String ipAddress = IpAddressUtil.getIpAddress(request);
        boolean noauthBool = true;
        if (StringUtils.isNotBlank((CharSequence)this.noauthUrlResources)) {
            String[] split;
            for (String staticResource : split = this.noauthUrlResources.split(";")) {
                if (!staticResource.equals(ipAddress)) continue;
                noauthBool = false;
            }
            if (noauthBool) {
                throw new RuntimeException("\u975e\u6cd5\u6765\u6e90ip\u8bbf\u95ee:" + ipAddress);
            }
        }
    }
}

