/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.util;

import java.util.regex.Pattern;

public class RegexUtils {
    public static String getRegPath(String path) {
        char[] chars = path.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean preX = false;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '*') {
                if (preX) {
                    sb.append(".*");
                    preX = false;
                    continue;
                }
                if (i + 1 == len) {
                    sb.append("[^/]*");
                    continue;
                }
                preX = true;
                continue;
            }
            if (preX) {
                sb.append("[^/]*");
                preX = false;
            }
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static boolean wildcardEquals(String whitePath, String reqPath) {
        String regPath = RegexUtils.getRegPath(whitePath);
        return Pattern.compile(regPath).matcher(reqPath).matches();
    }
}

