/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils;

import com.tydic.uoc.base.utils.EncryptUtil;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLClient
extends DefaultHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SSLClient.class);

    public SSLClient() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                log.debug("");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                log.debug("");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = this.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> map, Map<String, String> headers) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity httpEntity;
            CloseableHttpResponse response;
            httpClient = SSLClient.createHttpClient();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (!list.isEmpty()) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                httpPost.setHeader("stamp", EncryptUtil.getStamp());
                if (headers != null && !headers.isEmpty()) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (httpEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
        finally {
            try {
                assert (httpClient != null);
                httpClient.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostTimeOut(String url, Map<String, String> map, Map<String, String> headers, Integer timeOut) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity httpEntity;
            CloseableHttpResponse response;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeOut.intValue()).setSocketTimeout(timeOut.intValue()).build();
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (!list.isEmpty()) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                httpPost.setHeader("stamp", EncryptUtil.getStamp());
                if (headers != null && !headers.isEmpty()) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (httpEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
        finally {
            try {
                assert (httpClient != null);
                httpClient.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(500000).setSocketTimeout(100000).build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, String> map) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = SSLClient.createHttpClient();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (String string : map.keySet()) {
                pairs.add(new BasicNameValuePair(string, map.get(string)));
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(pairs);
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (closeableHttpResponse != null && (resEntity = closeableHttpResponse.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
        finally {
            try {
                assert (httpClient != null);
                httpClient.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

