/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils.http;

import com.tydic.uoc.base.utils.http.HsnObjectPoolBean;
import com.tydic.uoc.base.utils.http.HttpClientPoolableObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;

public class HSNHttpPoolHelper {
    private static final Log log = LogFactory.getLog(HSNHttpPoolHelper.class);
    public static final HsnObjectPoolBean hsnHttpObjectPoolBean;
    public static final HsnObjectPoolBean hsnHttpsObjectPoolBean;
    private static IdleConnectionEvictor idleConnEvictor;
    private static final long minIdleTime = 60000L;
    private static final int maxConn = 1000;
    private static final int maxActive = 1000;

    public static void shutdownTask() {
        try {
            idleConnEvictor.interrupt();
        }
        catch (Exception var2) {
            log.error((Object)("\u5173\u95edidleConnEvictor\u65f6\u51fa\u9519\uff1a" + var2.getMessage()), (Throwable)var2);
        }
        try {
            hsnHttpsObjectPoolBean.shutDownConnManager();
            hsnHttpObjectPoolBean.shutDownConnManager();
        }
        catch (Exception var1) {
            log.error((Object)("\u5173\u95edClientConnectionManager\u65f6\u51fa\u9519\uff1a" + var1.getMessage()), (Throwable)var1);
        }
    }

    public static void setMaxConnPerRoute(int maxConnPerRoute) {
        hsnHttpObjectPoolBean.setMaxConnPerRoute(maxConnPerRoute);
    }

    public static void reConfigHttpClientConnManager() {
        hsnHttpsObjectPoolBean.reConfigHttpClientConnManager();
        hsnHttpObjectPoolBean.reConfigHttpClientConnManager();
    }

    public static long getHttpClientPoolNumActive() {
        return hsnHttpObjectPoolBean.getHttpClientPool().getNumActive();
    }

    public static long getHttpClientPoolMaxNum() {
        return 1000L;
    }

    private static GenericObjectPool.Config getObjectPoolConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = 1000;
        config.maxIdle = -1;
        config.minIdle = 100;
        config.testOnBorrow = false;
        config.testOnReturn = false;
        config.testWhileIdle = false;
        config.whenExhaustedAction = (byte)2;
        config.minEvictableIdleTimeMillis = 60000L;
        config.timeBetweenEvictionRunsMillis = 60000L;
        config.numTestsPerEvictionRun = 10;
        return config;
    }

    static {
        idleConnEvictor = null;
        GenericObjectPool.Config config = HSNHttpPoolHelper.getObjectPoolConfig();
        HttpClientPoolableObjectFactory httpClientPoolableObjectFactory = new HttpClientPoolableObjectFactory(false);
        GenericObjectPool httpClientPool = (GenericObjectPool)new GenericObjectPoolFactory((PoolableObjectFactory)httpClientPoolableObjectFactory, config).createPool();
        hsnHttpObjectPoolBean = new HsnObjectPoolBean((ObjectPool)httpClientPool, httpClientPoolableObjectFactory.getConnMng(), false);
        HttpClientPoolableObjectFactory httpsClientPoolableObjectFactory = new HttpClientPoolableObjectFactory(true);
        GenericObjectPool httpsClientPool = (GenericObjectPool)new GenericObjectPoolFactory((PoolableObjectFactory)httpsClientPoolableObjectFactory, config).createPool();
        hsnHttpsObjectPoolBean = new HsnObjectPoolBean((ObjectPool)httpsClientPool, httpsClientPoolableObjectFactory.getConnMng(), true);
        idleConnEvictor = new IdleConnectionEvictor();
        idleConnEvictor.start();
    }

    public static class IdleConnectionEvictor
    extends Thread {
        private static final int INTERVAL = 5000;
        private volatile boolean isRunning = true;

        public IdleConnectionEvictor() {
            super("HttpClient_IdleConnectionEvictor");
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.isRunning = false;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    Thread.sleep(5000L);
                    this.safelyCloseConnections(hsnHttpsObjectPoolBean);
                    this.safelyCloseConnections(hsnHttpObjectPoolBean);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.info((Object)"IdleConnectionEvictor\u88ab\u4e2d\u65ad\uff0c\u4efb\u52a1\u5373\u5c06\u7ed3\u675f...");
                    return;
                }
                catch (Exception e) {
                    log.error((Object)"\u5173\u95ed\u8fde\u63a5\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
            }
            log.info((Object)"IdleConnectionEvictor\u4efb\u52a1\u7ed3\u675f");
        }

        private void safelyCloseConnections(HsnObjectPoolBean poolBean) {
            if (poolBean != null) {
                poolBean.closeExpiredAndIdleConnections(60000L);
            }
        }
    }
}

