/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.base.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MoneyUtil {
    public static BigDecimal l4B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal l2B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal b2B(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(fee.divide(new BigDecimal("10000"), 10, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal b8B(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return fee.setScale(8, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public static Long b2L(BigDecimal fee) {
        if (fee == null) {
            return 0L;
        }
        return fee.multiply(new BigDecimal("10000")).longValue();
    }

    public static BigDecimal b2b(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return fee.stripTrailingZeros().setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal b4b(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return fee.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public static BigDecimal coverTwo(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return fee.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public static String l4BToString(Long fee) {
        if (fee == null) {
            return "0";
        }
        return new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }
}

