/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfSubmitOrderFromBusiService;
import com.tydic.uoc.busibase.busi.bo.SubmitOrderCommonReqBO;
import com.tydic.uoc.busibase.busi.bo.SubmitOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.SubmitOrderRspBO;
import com.tydic.uoc.busibase.busi.bo.SubmitOrderVO;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfSubmitOrderFromBusiService")
public class PebIntfSubmitOrderFromBusiServiceImpl
implements PebIntfSubmitOrderFromBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfSubmitOrderFromBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;

    @Override
    public SubmitOrderRspBO submitOrder(SubmitOrderReqBO submitOrderReqBO) {
        SubmitOrderRspBO resolveRsp;
        try {
            String reqStr = this.initPostStr(submitOrderReqBO);
            String callUrl = null;
            callUrl = OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(submitOrderReqBO.getSupplierId().toString()) || this.jdIdFl.equals(submitOrderReqBO.getSupplierId().toString()) ? OrderPropertiesUtil.getProperty((String)"ESB_JD_SUBMIT_ORDER_URL") : OrderPropertiesUtil.getProperty((String)"ESB_SUBMIT_ORDER_URL");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(callUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102000", "\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_SUBMIT_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            resolveRsp = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
            throw new UocProBusinessException("106000", "\u9884\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u8c03\u7528ESB\u7edf\u4e00\u4e0b\u5355\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return resolveRsp;
    }

    private String initPostStr(SubmitOrderReqBO submitOrderReqBO) {
        String esbReqParam;
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + submitOrderReqBO.getSupplierId()));
        if (OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(submitOrderReqBO.getSupplierId().toString()) || this.jdIdFl.equals(submitOrderReqBO.getSupplierId().toString())) {
            esbReqParam = ESBParamUtil.getEsbReqParam((Object)submitOrderReqBO, (String)hsn, (String)"BUSINESS_ORDER");
        } else {
            if (OrderPropertiesUtil.getProperty((String)"SUPPLIER_QST_ID").equals(submitOrderReqBO.getSupplierId().toString())) {
                submitOrderReqBO.setSubmitOrg(submitOrderReqBO.getPurchaseName());
            }
            SubmitOrderCommonReqBO submitOrderCommonReqBO = new SubmitOrderCommonReqBO();
            SubmitOrderCommonReqBO transformation = submitOrderCommonReqBO.transformation(submitOrderReqBO);
            esbReqParam = ESBParamUtil.getEsbReqParam((Object)transformation, (String)hsn, (String)"BUSINESS_ORDER");
        }
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u9884\u8ba2\u5355\u751f\u6210ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private SubmitOrderRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u9884\u8ba2\u5355\u751f\u6210ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        SubmitOrderRspBO submitOrderRsp = new SubmitOrderRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            SubmitOrderVO submitOrder = (SubmitOrderVO)JSON.parseObject((String)jsonObject.toJSONString(), SubmitOrderVO.class);
            submitOrderRsp.setResult(submitOrder);
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
        submitOrderRsp.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        return submitOrderRsp;
    }
}

