/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfgetJDAddressFromAddressService;
import com.tydic.uoc.busibase.busi.bo.PebIntfgetJDAddressFromAddressReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfgetJDAddressFromAddressRspBO;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebIntfgetJDAddressFromAddressServiceImpl
implements PebIntfgetJDAddressFromAddressService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfgetJDAddressFromAddressServiceImpl.class);

    @Override
    public PebIntfgetJDAddressFromAddressRspBO getAddr(PebIntfgetJDAddressFromAddressReqBO reqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        reqBO.setHsn(hsn);
        try {
            String reqStr = JSONObject.toJSONString((Object)reqBO);
            String callUrl = OrderPropertiesUtil.getProperty((String)"ESB_JD_ADDR_URL");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(callUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102000", "\u67e5\u8be2\u4eac\u4e1c\u5730\u5740[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_JD_ADDR_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740:" + e.getMessage());
            throw new UocProBusinessException("106000", "\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u62a5\u9519" + e);
        }
    }

    private PebIntfgetJDAddressFromAddressRspBO resolveRsp(String returnString) {
        log.info("\u67e5\u8be2\u4eac\u4e1c\u5730\u5740\u8fd4\u56de\u6570\u636e" + returnString);
        PebIntfgetJDAddressFromAddressRspBO addr = new PebIntfgetJDAddressFromAddressRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            addr = (PebIntfgetJDAddressFromAddressRspBO)((Object)JSON.parseObject((String)jsonObject.toJSONString(), PebIntfgetJDAddressFromAddressRspBO.class));
            addr.setRespCode("0000");
            addr.setRespDesc("\u6210\u529f");
            return addr;
        }
        addr.setRespCode((String)rspJsonObject.get((Object)"resultCode"));
        addr.setRespDesc((String)rspJsonObject.get((Object)"resultMessage"));
        return addr;
    }
}

