/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfGetMsgPushBusiService;
import com.tydic.uoc.busibase.busi.bo.BusiGetMsgReqBO;
import com.tydic.uoc.busibase.busi.bo.BusiGetMsgRspBO;
import com.tydic.uoc.common.ability.bo.Result;
import com.tydic.uoc.common.ability.bo.ResultBO;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfGetMsgPushBusiService")
public class PebIntfGetMsgPushBusiServiceImpl
implements PebIntfGetMsgPushBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfGetMsgPushBusiServiceImpl.class);

    @Override
    public BusiGetMsgRspBO getMsg(BusiGetMsgReqBO busiGetMsgReq) {
        try {
            String reqStr = this.initReqStr(busiGetMsgReq);
            String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + busiGetMsgReq.getSupplierId()));
            String reqEsbStr = ESBParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)"BUSINESS_ORDER");
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5730\u5740{},\u53c2\u6570{}", (Object)OrderPropertiesUtil.getProperty((String)"ESB_QRY_MSG_URL"), (Object)reqEsbStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_QRY_MSG_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_QRY_MSG_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiGetMsgRspBO resolveRsp = PebIntfGetMsgPushBusiServiceImpl.resolveRsp(returnString, busiGetMsgReq.getIsAnalysis());
            List<ResultBO> resultList = resolveRsp.getResult();
            if (null != resultList) {
                for (ResultBO resultBO : resultList) {
                    if (null == resultBO.getResult()) continue;
                }
            }
            return resolveRsp;
        }
        catch (Exception e) {
            throw new UocProBusinessException("106000", "\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
        }
    }

    private String initReqStr(BusiGetMsgReqBO busiQryMsgReqBO) {
        return "{\"type\":" + busiQryMsgReqBO.getType() + "}";
    }

    public static void main(String[] args) {
        String s = "{\n    \"result\": [\n        {\n            \"result\": [\n                {\n                    \"orderId\": \"10000295578901\",\n                    \"cancelType\": 1,\n                    \"cancelReason\": \"\u82cf\u5b81\u5ba2\u670d\u5236\u9000\"\n                }\n            ],\n            \"time\": \"2022-08-23 15:41:47\",\n            \"id\": \"100000445887\",\n            \"type\": \"10\"\n        }\n    ],\n    \"success\": \"true\",\n    \"resultCode\": \"0000\",\n    \"resultMessage\": \"\u6210\u529f\"\n}";
        BusiGetMsgRspBO resolveRsp = PebIntfGetMsgPushBusiServiceImpl.resolveRsp(s, true);
        List<ResultBO> resultList = resolveRsp.getResult();
        if (null != resultList) {
            for (ResultBO resultBO : resultList) {
                if (null == resultBO.getResult()) continue;
                System.out.println(JSONObject.toJSONString((Object)resultBO.getResult()));
            }
        }
    }

    private static BusiGetMsgRspBO resolveRsp(String returnString, boolean isAnalysis) {
        BusiGetMsgRspBO busiQryMsgRspBO = new BusiGetMsgRspBO();
        ArrayList<ResultBO> list = new ArrayList<ResultBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(rspJsonObject.getBoolean("success"));
            busiQryMsgRspBO.setResultCode(Integer.parseInt((String)rspJsonObject.get((Object)"resultCode")));
            busiQryMsgRspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (Object singleObject : object) {
                    JSONObject obj = (JSONObject)singleObject;
                    if (!isAnalysis) {
                        String id = obj.getString("id");
                        Long type = obj.getLong("type");
                        Date time = obj.getDate("time");
                        String result = obj.getString("result");
                        ResultBO temp = new ResultBO();
                        temp.setId(id);
                        temp.setTime(time);
                        temp.setType(type);
                        temp.setResultString(result);
                        temp.setResult(new Result());
                        list.add(temp);
                        continue;
                    }
                    System.out.println(JSONObject.toJSONString((Object)obj));
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    ResultBO jsonStringToJavaBean = (ResultBO)JSON.parseObject((String)jsonStr, ResultBO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return busiQryMsgRspBO;
    }
}

