/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfQryInOrderService;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderLine;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PebIntfQryInOrderServiceImpl
implements PebIntfQryInOrderService {
    private static final Logger log = LoggerFactory.getLogger(PebIntfQryInOrderServiceImpl.class);

    @Override
    public PebIntfQryInOrderRspBO qryErpInOrder(PebIntfQryInOrderReqBO reqBO) {
        PebIntfQryInOrderRspBO retBo;
        try {
            String reqStr = this.getReqStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"QRY_ORDER_IN_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u67e5\u8be2\u5165\u5e93\u5355[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"QRY_ORDER_IN_URL") + "]");
            }
            String resultStr = httpRetBean.getStr();
            retBo = this.parseResult(resultStr);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5165\u5e93\u5355" + e);
            throw new UocProBusinessException("106000", "\u67e5\u8be2\u5165\u5e93\u5355");
        }
        return retBo;
    }

    private PebIntfQryInOrderRspBO parseResult(String resultStr) {
        PebIntfQryInOrderRspBO rspBO = new PebIntfQryInOrderRspBO();
        log.debug("\u5165\u5e93\u5355\u67e5\u8be2\u7ed3\u679c" + resultStr);
        JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
        if (!"S".equals(jsonObject.getString("ERP_STATUS"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(jsonObject.getString("ERP_MSG"));
            return rspBO;
        }
        ArrayList<PebIntfQryInOrderLine> lines = new ArrayList<PebIntfQryInOrderLine>();
        try {
            JSONArray jsonArray = jsonObject.getJSONArray("DATA");
            for (Object o : jsonArray) {
                this.get(lines, (JSONObject)o);
            }
        }
        catch (Exception e) {
            JSONObject object = jsonObject.getJSONObject("DATA");
            this.get(lines, object);
        }
        rspBO.setLines(lines);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void get(List<PebIntfQryInOrderLine> lines, JSONObject jsonObject) {
        PebIntfQryInOrderLine orderLine = new PebIntfQryInOrderLine();
        orderLine.setTransactionId(jsonObject.getLong("TRANSACTION_ID"));
        orderLine.setPoHeaderId(jsonObject.getLong("PO_HEADER_ID"));
        orderLine.setExt1(String.valueOf(jsonObject.getLong("PO_LINE_ID")));
        orderLine.setPoNum(jsonObject.getString("PO_NUM"));
        orderLine.setOrgId(jsonObject.getLong("ORG_ID"));
        orderLine.setOrgName(jsonObject.getString("ORG_NAME"));
        orderLine.setOrdItemId(jsonObject.getLong("ATTRIBUTE4"));
        orderLine.setTransactionType(jsonObject.getString("TRANSACTION_TYPE"));
        orderLine.setQuantity(jsonObject.getBigDecimal("QUANTITY"));
        orderLine.setTransactionDate(jsonObject.getDate("TRANSACTION_DATE"));
        orderLine.setCreationDate(jsonObject.getDate("CREATION_DATE"));
        orderLine.setCreatedBy(jsonObject.getLong("CREATED_BY"));
        orderLine.setUserName(jsonObject.getString("USER_NAME"));
        orderLine.setFullName(jsonObject.getString("FULL_NAME"));
        orderLine.setReceiveNum(jsonObject.getString("RECEIVE_NUM"));
        orderLine.setReceiptNum(jsonObject.getString("RECEIPT_NUM"));
        orderLine.setLastUpdateDate(jsonObject.getDate("LAST_UPDATE_DATE"));
        orderLine.setParentTransactionId(jsonObject.getLong("PARENT_TRANSACTION_ID"));
        orderLine.setLineLocationId(jsonObject.getLong("LINE_LOCATION_ID"));
        orderLine.setDeliverToLocationId(jsonObject.getString("DELIVER_TO_LOCATION_ID"));
        orderLine.setLocationCode(jsonObject.getString("LOCATION_CODE"));
        orderLine.setCodeCombinationId(jsonObject.getString("CODE_COMBINATION_ID"));
        orderLine.setCodeCombinationDesc(jsonObject.getString("CODE_COMBINATION_DESC"));
        lines.add(orderLine);
    }

    private String getReqStr(PebIntfQryInOrderReqBO reqBo) {
        Gson gson = new Gson();
        String esbReqParam = gson.toJson((Object)reqBo);
        log.debug("\u91c7\u8d2d\u8ba2\u5355\u7ec8\u6b62\u8ba2\u5355\u5165\u53c2\u62a5\u6587\u4e3a\uff1a" + esbReqParam);
        return esbReqParam;
    }
}

