/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebPushDeliveryOrderNoBusiService;
import com.tydic.uoc.busibase.busi.bo.PebPushDeliveryOrderNoBO;
import com.tydic.uoc.busibase.busi.bo.PebPushDeliveryOrderNoBusiReqBO;
import com.tydic.uoc.busibase.busi.bo.PebPushDeliveryOrderNoBusiRspBO;
import java.net.URI;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PebPushDeliveryOrderNoBusiServiceImpl
implements PebPushDeliveryOrderNoBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebPushDeliveryOrderNoBusiServiceImpl.class);
    @Value(value="${SUPPLIER_JD_ID}")
    private String jdId;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Value(value="${uoc.sup.jd.delivery}")
    private String jdUrl;
    @Value(value="${uoc.sup.sn.delivery}")
    private String snUrl;

    @Override
    public PebPushDeliveryOrderNoBusiRspBO pushDeliveryOrder(PebPushDeliveryOrderNoBusiReqBO reqBO) {
        reqBO.getRspBOList().forEach(obj -> {
            try {
                String reqStr = this.jdInitPostStr((PebPushDeliveryOrderNoBO)obj, reqBO.getSupNo());
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.jdUrl), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
                log.info("\u8c03\u7528\u540c\u6b65\u914d\u9001\u5b50\u5355\u53f7\u4fe1\u606fESB\u63a5\u53e3\u54cd\u5e94\u62a5\u6587" + JSON.toJSONString((Object)httpRetBean));
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u8c03\u7528\u540c\u6b65\u914d\u9001\u5b50\u5355\u53f7\u4fe1\u606fESB\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.jdUrl + "]");
                }
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new UocProBusinessException("102001", "\u8c03\u7528\u540c\u6b65\u914d\u9001\u5b50\u5355\u53f7\u4fe1\u606fESB\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                JSONObject jsonObject = JSONObject.parseObject((String)returnString);
                if (!"true".equals(jsonObject.getString("success"))) {
                    throw new ZTBusinessException(jsonObject.getString("resultMessage"));
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u540c\u6b65\u914d\u9001\u5b50\u5355\u53f7\u4fe1\u606fESB\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
            }
        });
        return new PebPushDeliveryOrderNoBusiRspBO();
    }

    private String jdInitPostStr(PebPushDeliveryOrderNoBO obj, String supNo) {
        JSONObject jsonObject = new JSONObject();
        if (this.jdId.equals(supNo) || this.jdIdFl.equals(supNo)) {
            jsonObject.put("jdOrderId", (Object)obj.getOutorderId());
        } else {
            jsonObject.put("snOrderId", (Object)obj.getOutorderId());
        }
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("relErpPo", (Object)obj.getSaleVoucherNO());
        jsonObject.put("customOrderExt", (Object)jsonObject1.toJSONString());
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + supNo));
        String esbReqParam = ESBParamUtil.getEsbReqStr((String)jsonObject.toJSONString(), (String)hsn, (String)"BUSINESS_ORDER");
        log.info("\u8c03\u7528\u540c\u6b65\u914d\u9001\u5b50\u5355\u53f7\u4fe1\u606fESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        return esbReqParam;
    }
}

