/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.ESBParamUtil;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrderInfoBusiService;
import com.tydic.uoc.busibase.busi.bo.ChildSaleOrderBO;
import com.tydic.uoc.busibase.busi.bo.ParentSaleOrderBO;
import com.tydic.uoc.busibase.busi.bo.QryOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrderRspBO;
import com.tydic.uoc.busibase.busi.bo.SaleOrderBO;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pebIntfQryOrderInfoBusiService")
public class PebIntfQryOrderInfoBusiServiceImpl
implements PebIntfQryOrderInfoBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PebIntfQryOrderInfoBusiServiceImpl.class);
    private final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();

    @Override
    public QryOrderRspBO selectOrderInfo(QryOrderReqBO qryOrderReqBO) {
        QryOrderRspBO rspBO;
        try {
            String reqStr = this.initPostStr(qryOrderReqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528ESB\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + OrderPropertiesUtil.getProperty((String)"ESB_QRY_ORDER_URL") + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528ESB\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBO = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528ESB\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u8c03\u7528ESB\u8ba2\u5355\u67e5\u8be2\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private String initPostStr(QryOrderReqBO qryOrderReqBO) {
        String hsn = OrderPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + qryOrderReqBO.getSupplierId()));
        String esbReqParam = ESBParamUtil.getEsbReqParam((Object)qryOrderReqBO, (String)hsn, (String)"BUSINESS_ORDER");
        if (this.IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u8ba2\u5355\u67e5\u8be2ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a" + esbReqParam);
        }
        return esbReqParam;
    }

    private QryOrderRspBO resolveRsp(String returnString) {
        LOGGER.debug("\u8c03\u7528\u8ba2\u5355\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        QryOrderRspBO rspBO = new QryOrderRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
            JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
            Object object = jsonObj.get((Object)"cOrder");
            if (object == null) {
                SaleOrderBO saleOrderRspBO = (SaleOrderBO)JSON.parseObject((String)jsonStr, SaleOrderBO.class);
                rspBO.setSaleOrderRspBO(saleOrderRspBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u83b7\u53d6\u65e0\u62c6\u5355\u8ba2\u5355\u4fe1\u606f\u6210\u529f!");
                return rspBO;
            }
            String pOrder = JSONObject.toJSONString((Object)jsonObj.get((Object)"pOrder"));
            ParentSaleOrderBO parentSaleOrderRsp = (ParentSaleOrderBO)JSON.parseObject((String)pOrder, ParentSaleOrderBO.class);
            rspBO.setParentSaleOrderRspBO(parentSaleOrderRsp);
            ArrayList<ChildSaleOrderBO> childList = new ArrayList<ChildSaleOrderBO>();
            String cOrder = JSONObject.toJSONString((Object)jsonObj.get((Object)"cOrder"));
            JSONArray array = JSONArray.parseArray((String)cOrder);
            for (Object singleObject : array) {
                String obj = JSONObject.toJSONString(singleObject);
                ChildSaleOrderBO child = (ChildSaleOrderBO)JSON.parseObject((String)obj, ChildSaleOrderBO.class);
                childList.add(child);
            }
            rspBO.setChildSaleOrderList(childList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u83b7\u53d6\u62c6\u5355\u540e\u7684\u7236\u5b50\u8ba2\u5355\u4fe1\u606f\u6210\u529f!");
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

