/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocOrderRelUpdateAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateReqBo;
import com.tydic.uoc.common.ability.bo.UocOrderRelUpdateRspBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.UocOrderRelUpdateBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocOrderRelUpdateAbilityService"})
public class UocOrderRelUpdateAbilityServiceImpl
implements UocOrderRelUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrderRelUpdateAbilityServiceImpl.class);
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String topic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String tag;
    @Autowired
    private UocOrderRelUpdateBusiService uocOrderRelUpdateBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"dealRelUpdate"})
    public UocOrderRelUpdateRspBo dealRelUpdate(@RequestBody UocOrderRelUpdateReqBo reqBo) {
        this.validateArgs(reqBo);
        UocOrderRelUpdateRspBo rspBo = this.uocOrderRelUpdateBusiService.dealRelUpdate(reqBo);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInspectionVoucherId())) {
            this.syncInspection(reqBo.getOrderId(), reqBo.getInspectionVoucherId());
        } else {
            this.syncSale(reqBo);
        }
        return rspBo;
    }

    private void validateArgs(UocOrderRelUpdateReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelType())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[relType]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRelState())) {
            throw new UocProBusinessException("104021", "\u5165\u53c2\u5bf9\u8c61[relState]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncInspection(Long orderId, Long objId) {
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(orderId);
        pebOrdIdxSyncReqBO.setObjId(objId);
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.INSPECTION);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }

    private void syncSale(UocOrderRelUpdateReqBo reqBo) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBo.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        UocPebOrdIdxSyncReqBO pebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
        pebOrdIdxSyncReqBO.setOrderId(salePO.getOrderId());
        pebOrdIdxSyncReqBO.setObjId(salePO.getSaleVoucherId());
        pebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)pebOrdIdxSyncReqBO)));
    }
}

