/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.busibase.busi.api.PebIntfZmCreatePurchaseOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.DisData;
import com.tydic.uoc.busibase.busi.bo.HeaderDataBO;
import com.tydic.uoc.busibase.busi.bo.LineInfoBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmCreatePurchaseOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmCreatePurchaseOrderRspBO;
import com.tydic.uoc.common.ability.bo.PebPushErpReqBO;
import com.tydic.uoc.common.ability.bo.PebPushErpRspBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.PebPushErpBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrgSubCodeMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrgSubCodePO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebPushErpBusiServiceImpl
implements PebPushErpBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private PebIntfZmCreatePurchaseOrderAbilityService pebIntfZmCreatePurchaseOrderAbilityService;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Value(value="${needDate:30}")
    private Long needDate;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Value(value="${ATTRIBUTE_CATEGORY:\u4e00\u4f53\u5316\u8ba2\u5355}")
    private String ATTRIBUTE_CATEGORY;
    @Autowired
    private UocOrgSubCodeMapper uocOrgSubCodeMapper;

    @Override
    public PebPushErpRspBO dealPushErp(PebPushErpReqBO reqBO) {
        PebPushErpRspBO rspBO = new PebPushErpRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
        OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(reqBO.getOrderId());
        List goodsPOS = this.ordGoodsMapper.getList(ordGoodsPO);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(reqBO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        if (!PebExtConstant.YES.equals(zmInfoPO.getIsPushErp())) {
            rspBO.setRespCode("102001");
            rspBO.setRespDesc("\u8be5\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u9001erp");
            return rspBO;
        }
        if (PebExtConstant.YES.equals(zmInfoPO.getErpStatus())) {
            rspBO.setSaleId(ordSalePO.getSaleVoucherId());
            return rspBO;
        }
        PebIntfZmCreatePurchaseOrderReqBO purchaseOrderReqBO = new PebIntfZmCreatePurchaseOrderReqBO();
        purchaseOrderReqBO.setPBATCH_ID(reqBO.getOrderId().toString());
        ArrayList<HeaderDataBO> headerDataBOS = new ArrayList<HeaderDataBO>();
        HeaderDataBO headerDataBO = new HeaderDataBO();
        headerDataBO.setHEADER_UUID(reqBO.getOrderId().toString());
        headerDataBO.setORG_ID(zmInfoPO.getBuynerErpNo());
        headerDataBO.setVENDOR_CODE(zmInfoPO.getSupplierErpNo());
        headerDataBO.setVENDOR_NAME(zmInfoPO.getSupplierName());
        headerDataBO.setATTRIBUTE_CATEGORY(this.ATTRIBUTE_CATEGORY);
        if (zmInfoPO.getVendorSiteId() != null) {
            headerDataBO.setVENDOR_SITE_ID(zmInfoPO.getVendorSiteId().toString());
        }
        headerDataBO.setVENDOR_SITE_NAME(zmInfoPO.getVendorSiteName());
        if (zmInfoPO.getAgentId() != null) {
            headerDataBO.setAGENT_ID(zmInfoPO.getAgentId().toString());
        }
        headerDataBO.setCURRENCY_CODE("CNY");
        headerDataBO.setUSER_NAME(zmInfoPO.getErpUserName());
        headerDataBO.setB2BSITE_ID(zmInfoPO.getB2bsiteId());
        headerDataBO.setDOC_TYPE("STANDARD");
        headerDataBO.setDOC_NUM(ordSalePO.getSaleVoucherNo());
        headerDataBO.setAUTO_APPROVE("Y");
        headerDataBO.setSHIP_TO_LOC_ID(zmInfoPO.getAcquirerId());
        headerDataBO.setBILL_TO_LOC_ID(zmInfoPO.getConsigneeId());
        headerDataBO.setATTRIBUTE1(zmInfoPO.getTaxrate().toString());
        headerDataBO.setATTRIBUTE2(zmInfoPO.getSourcesOfFundsId());
        headerDataBO.setATTRIBUTE3(zmInfoPO.getUseDeptId());
        headerDataBO.setATTRIBUTE4(zmInfoPO.getDemandTrackingNo());
        headerDataBO.setATTRIBUTE5(zmInfoPO.getEnDeliveryDate());
        headerDataBO.setATTRIBUTE6(zmInfoPO.getEnglishPaymentTerms());
        headerDataBO.setATTRIBUTE7(zmInfoPO.getEnVersionPriceTerm());
        headerDataBO.setATTRIBUTE8(zmInfoPO.getEnVersionShipment());
        headerDataBO.setATTRIBUTE9(zmInfoPO.getEnPortDestination());
        if (PebExtConstant.YES.equals(zmInfoPO.getIsWaiWei())) {
            headerDataBO.setATTRIBUTE10("Y");
        } else {
            headerDataBO.setATTRIBUTE10("N");
        }
        headerDataBO.setATTRIBUTE11(zmInfoPO.getWaiWeiId());
        if (PebExtConstant.YES.equals(zmInfoPO.getIsFixedAsset())) {
            headerDataBO.setATTRIBUTE12("Y");
        } else {
            headerDataBO.setATTRIBUTE12("N");
        }
        if (PebExtConstant.YES.equals(zmInfoPO.getIsJsXy())) {
            headerDataBO.setATTRIBUTE13("Y");
        } else {
            headerDataBO.setATTRIBUTE13("N");
        }
        headerDataBO.setATTRIBUTE14(zmInfoPO.getDaTunRemark());
        headerDataBO.setATTRIBUTE15(zmInfoPO.getPurType());
        ArrayList<LineInfoBO> lineInfoBOS = new ArrayList<LineInfoBO>();
        headerDataBO.setLINE_DATA(lineInfoBOS);
        Map<Long, OrdGoodsPO> map = goodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, i -> i));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OrdItemPO itemPO : list) {
            if (!StringUtils.isNotBlank((CharSequence)itemPO.getOrganizationId())) continue;
            ids.add(Long.valueOf(itemPO.getOrganizationId()));
        }
        List subCodePOS = new ArrayList();
        if (ids.size() > 0) {
            UocOrgSubCodePO codePO = new UocOrgSubCodePO();
            codePO.setBfOrgIdList(ids);
            subCodePOS = this.uocOrgSubCodeMapper.selectByCondition(codePO);
        }
        int i2 = 0;
        for (OrdItemPO itemPO : list) {
            ++i2;
            OrdGoodsPO goodsPO = map.get(itemPO.getOrdItemId());
            LineInfoBO infoBO = new LineInfoBO();
            infoBO.setITEM_NO(goodsPO.getSkuMaterialId());
            infoBO.setITEM_DESC(itemPO.getExtField2());
            infoBO.setUNIT_OF_MEASURE(itemPO.getUnitName());
            infoBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)new Date(System.currentTimeMillis() + this.needDate * 24L * 60L * 60L * 1000L)));
            infoBO.setQUANTITY(itemPO.getPurchaseCount().toString());
            try {
                BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0.16) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f);
                BigDecimal djs = new BigDecimal(itemPO.getSalePrice()).divide(new BigDecimal(10000));
                BigDecimal taxA = price.add(BigDecimal.ONE);
                BigDecimal bud = djs.multiply(price).divide(taxA, 6, RoundingMode.HALF_UP);
                infoBO.setUNIT_PRICE(djs.subtract(bud) + "");
            }
            catch (Exception price) {
                // empty catch block
            }
            if (itemPO.getPlanItemId() != null) {
                infoBO.setSHIPMENT_ATR15(itemPO.getPlanItemId().toString());
            }
            infoBO.setUSER_NAME(zmInfoPO.getErpUserName());
            infoBO.setLINE_NUM(String.valueOf(i2));
            infoBO.setORGANIZATION_ID(itemPO.getOrganizationId());
            infoBO.setLINE_ATTRIBUTE4(itemPO.getOrdItemId().toString());
            infoBO.setLINE_ATTRIBUTE5(itemPO.getTax().toString());
            ArrayList<DisData> disDatas = new ArrayList<DisData>();
            DisData disData = new DisData();
            disData.setQUANTITY_ORDERED(itemPO.getPurchaseCount().toString());
            disData.setDIS_NUM("1");
            disData.setUPDATESTATUS("0");
            if (itemPO.getPlanId() != null) {
                Long yes = 1L;
                if (yes.equals(itemPO.getPreFee())) {
                    disData.setSCH_LINE_ID(itemPO.getPlanItemId().toString());
                    disData.setUPDATESTATUS("1");
                } else {
                    disData.setUPDATESTATUS("0");
                }
            }
            disData.setUSER_NAME(zmInfoPO.getErpUserName());
            if (CollectionUtils.isNotEmpty(subCodePOS)) {
                for (UocOrgSubCodePO codePO : subCodePOS) {
                    if (!codePO.getBfOrgId().toString().equals(itemPO.getOrganizationId())) continue;
                    disData.setORGANIZATION_ID(codePO.getAfsOrgId().toString());
                    disData.setDESTINATION_SUBINVENTORY(codePO.getSubCode());
                    break;
                }
            }
            if (StringUtils.isBlank((CharSequence)disData.getORGANIZATION_ID())) {
                disData.setORGANIZATION_ID(itemPO.getOrganizationId());
            }
            infoBO.setORGANIZATION_ID(disData.getORGANIZATION_ID());
            if (StringUtils.isBlank((CharSequence)disData.getDESTINATION_SUBINVENTORY())) {
                disData.setDESTINATION_SUBINVENTORY("");
            }
            disDatas.add(disData);
            infoBO.setDIS_DATA(disDatas);
            lineInfoBOS.add(infoBO);
        }
        headerDataBOS.add(headerDataBO);
        purchaseOrderReqBO.setHEADER_DATA(headerDataBOS);
        PebIntfZmCreatePurchaseOrderRspBO purchaseOrderRspBO = this.pebIntfZmCreatePurchaseOrderAbilityService.puchaserOrder(purchaseOrderReqBO);
        rspBO.setRespCode(purchaseOrderRspBO.getRespCode());
        rspBO.setRespDesc(purchaseOrderRspBO.getRespDesc());
        rspBO.setSaleId(ordSalePO.getSaleVoucherId());
        if ("0000".equals(purchaseOrderRspBO.getRespCode())) {
            UocOrdZmInfoPO update = new UocOrdZmInfoPO();
            update.setOrderId(reqBO.getOrderId());
            update.setErpStatus(Integer.valueOf(1));
            this.uocOrdZmInfoMapper.update(update);
        }
        this.saveLog(reqBO.getOrderId(), purchaseOrderRspBO, purchaseOrderReqBO);
        return rspBO;
    }

    private void saveLog(Long orderId, PebIntfZmCreatePurchaseOrderRspBO purchaseOrderRspBO, PebIntfZmCreatePurchaseOrderReqBO purchaseOrderReqBO) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setErrDetail("1");
        logBO.setFlowFlag(1);
        logBO.setInContent(JSON.toJSONString((Object)purchaseOrderReqBO));
        logBO.setInterCode("pushErp");
        logBO.setInterSn("1");
        logBO.setCallCount(1);
        logBO.setCallState("1");
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(purchaseOrderRspBO.getRespCode());
        logBO.setOutContent(purchaseOrderRspBO.getReturnString());
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

