/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.busi.api.PebUpdateSaleStatusBusiService;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdPayConfMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdPayConfPO;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebUpdateSaleStatusBusiServiceImpl
implements PebUpdateSaleStatusBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdPayConfMapper uocOrdPayConfMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;

    @Override
    public void dealUpdate(PebDealOrderBO reqBO) {
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setSaleState(UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER);
        ordSalePO.setOrderId(reqBO.getOrderId());
        ordSalePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        this.ordSaleMapper.updateById(ordSalePO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List list = this.ordItemMapper.getList(ordItemPO);
        for (OrdItemPO itemPO : list) {
            if (itemPO.getPlanId() == null) {
                return;
            }
            try {
                OrdItemPO update = new OrdItemPO();
                update.setSendCount(itemPO.getPurchaseCount().negate());
                update.setOrdItemId(Long.valueOf(itemPO.getLmOrderId()));
                this.ordItemMapper.updateCounts(update);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updatePayConfig(PebDealOrderBO reqBO) {
        UocOrdPayConfPO uocOrdPayConfPO = new UocOrdPayConfPO();
        uocOrdPayConfPO.setOrderId(reqBO.getPorderId());
        List list = this.uocOrdPayConfMapper.selectByCondition(uocOrdPayConfPO);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        uocOrdPayConfPO = (UocOrdPayConfPO)list.get(0);
        if (uocOrdPayConfPO.getPrePayFee() == null || uocOrdPayConfPO.getPrePayFee() == 0L) {
            return;
        }
        UocOrdPayConfPO confPO = new UocOrdPayConfPO();
        confPO.setOrderId(reqBO.getPorderId());
        List childs = this.uocOrdPayConfMapper.selectByPorder(confPO);
        if (CollectionUtils.isEmpty((Collection)childs)) {
            return;
        }
        long total = 0L;
        for (UocOrdPayConfPO payConfPO : childs) {
            if (UocConstant.SALE_ORDER_STATUS.SPLIT_ORDER.equals(payConfPO.getSaleState()) || payConfPO.getPrePayFee() == null || payConfPO.getPrePayFee() == 0L) continue;
            if (total + payConfPO.getPrePayFee() > uocOrdPayConfPO.getPrePayFee()) {
                UocOrdPayConfPO update = new UocOrdPayConfPO();
                update.setPrePayFee(Long.valueOf(uocOrdPayConfPO.getPrePayFee() - total));
                update.setId(payConfPO.getId());
                update.setOrderId(payConfPO.getOrderId());
                this.uocOrdPayConfMapper.update(update);
                break;
            }
            total += payConfPO.getPrePayFee().longValue();
        }
    }
}

