/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocProShouldPayOrDeductDealAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocProShouldPayOrDeductDealAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocPebApproveBusiService;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocPebApproveBusiRspBO;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdPayConfMapper;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocPebApproveBusiServiceImpl
implements UocPebApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebApproveBusiServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Value(value="${SUPPLIER_JD_ID}")
    private String jdId;
    @Autowired
    UocOrdPayConfMapper uocOrdPayConfMapper;
    @Autowired
    private UocProShouldPayOrDeductDealAtomService uocProShouldPayOrDeductDealAtomService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;

    @Override
    public UocPebApproveBusiRspBO dealPebApprove(UocPebApproveBusiReqBO reqBO) {
        UocPebApproveBusiRspBO rsp = new UocPebApproveBusiRspBO();
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        try {
            salePO = this.ordSaleMapper.getModelBy(salePO);
            rsp.setOrderId(salePO.getOrderId());
            rsp.setSaleId(salePO.getSaleVoucherId());
        }
        catch (Exception e) {
            throw new UocProBusinessException("102049", "\u67e5\u8be2\u9500\u552e\u5355\u5931\u8d25");
        }
        if (!UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(salePO.getSaleState())) {
            throw new UocProBusinessException("102049", "\u8ba2\u5355\u4e0d\u5728\u5f85\u5ba1\u6279\u72b6\u6001");
        }
        try {
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getStepId())) {
                uacNoTaskAuditOrderAuditReqBO.setStepId(reqBO.getStepId());
            } else {
                uacNoTaskAuditOrderAuditReqBO.setStepId(salePO.getTbOrderId());
            }
            if (reqBO.getFlag().equals("1")) {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(Integer.parseInt("0")));
            } else {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(Integer.parseInt("1")));
            }
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOrgName());
            uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getUsername());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getDealDesc());
            uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.APPROVAL_OBJ_TYPE.ACTPEB007);
            ArrayList<Long> objIds = new ArrayList<Long>();
            objIds.add(salePO.getSaleVoucherId());
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException("102049", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            if (uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                if ("1".equals(reqBO.getFlag())) {
                    this.run(salePO, reqBO, rsp);
                    try {
                        this.checkJD(salePO, reqBO);
                    }
                    catch (Exception e) {
                        log.info("\u4eac\u4e1c\u8ba2\u5355\u4e00\u79cd\u5546\u54c1\u8d70\u4e00\u904d\u72b6\u6001\u673a\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
            } else {
                OrdSalePO update = new OrdSalePO();
                update.setOrderId(salePO.getOrderId());
                update.setSaleVoucherId(salePO.getSaleVoucherId());
                update.setTbOrderId(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId());
                this.ordSaleMapper.updateById(update);
            }
            rsp.setPay(reqBO.getPay());
            rsp.setFinish(uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u6210\u529f\uff01");
            return rsp;
        }
        catch (Exception e) {
            throw new UocProBusinessException("102049", "\u5ba1\u6279\u7ec4\u5408\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void run(OrdSalePO saleRspBO, UocPebApproveBusiReqBO reqBO, UocPebApproveBusiRspBO rsp) {
        UocProShouldPayOrDeductDealAtomRspBo shouldPayOrDeductDealAtomRspBo;
        UocProShouldPayOrDeductDealAtomReqBo uocProShouldPayOrDeductDealAtomReqBo;
        OrdPayConfPO confPO = new OrdPayConfPO();
        confPO.setOrderId(saleRspBO.getOrderId());
        confPO.setUserType(Integer.valueOf(1));
        List list = this.ordPayConfMapper.selectByCondition(confPO);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("payFlag", "1");
        confPO = (OrdPayConfPO)list.get(0);
        if ("2".equals(confPO.getPayType().toString())) {
            variables.put("payFlag", "2");
            uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
            uocProShouldPayOrDeductDealAtomReqBo.setOrderId(saleRspBO.getOrderId());
            uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            uocProShouldPayOrDeductDealAtomReqBo.setIsToBePaid(true);
            uocProShouldPayOrDeductDealAtomReqBo.setObjId(saleRspBO.getSaleVoucherId());
            uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT);
            shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
            rsp.setPay("2");
            if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
            }
        } else {
            uocProShouldPayOrDeductDealAtomReqBo = new UocProShouldPayOrDeductDealAtomReqBo();
            uocProShouldPayOrDeductDealAtomReqBo.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            uocProShouldPayOrDeductDealAtomReqBo.setOrderId(saleRspBO.getOrderId());
            uocProShouldPayOrDeductDealAtomReqBo.setObjId(saleRspBO.getSaleVoucherId());
            uocProShouldPayOrDeductDealAtomReqBo.setPaymentStage(UocCoreConstant.PaymentStage.ENTER_PENDING_PAYMENT_NOW);
            uocProShouldPayOrDeductDealAtomReqBo.setObjDate(this.orderMapper.getModelById(saleRspBO.getOrderId().longValue()).getCreateTime());
            shouldPayOrDeductDealAtomRspBo = this.uocProShouldPayOrDeductDealAtomService.dealShouldPayOrDeduct(uocProShouldPayOrDeductDealAtomReqBo);
            if (!"0000".equals(shouldPayOrDeductDealAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(shouldPayOrDeductDealAtomRspBo.getRespCode(), shouldPayOrDeductDealAtomRspBo.getRespDesc());
            }
        }
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
        processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        processRunReqBO.setOrderId(saleRspBO.getOrderId());
        processRunReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        processRunReqBO.setVariables(variables);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102049", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void checkJD(OrdSalePO saleRspBO, UocPebApproveBusiReqBO reqBO) {
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(reqBO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        if (null == ordStakeholderPO) {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u4e09\u65b9\u4fe1\u606f");
        }
        if (this.jdId.equals(ordStakeholderPO.getSupNo())) {
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(saleRspBO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(saleRspBO.getOrderId());
            processRunReqBO.setOperId(String.valueOf(reqBO.getUserId()));
            UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102049", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
            }
        }
    }
}

