/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocProOrderPaymentCallbackAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitReqBO;
import com.tydic.uoc.common.ability.bo.UocPebPreOrderSubmitRspBO;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentCallbackAbilityReqBo;
import com.tydic.uoc.common.ability.bo.UocProOrderPaymentCallbackAbilityRspBo;
import com.tydic.uoc.common.busi.api.UocPebPreOrderSubmitBsuiService;
import com.tydic.uoc.common.busi.api.UocProOrderPaymentCallbackBusiService;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.UocProOrderPaymentCallbackAbilityService"})
public class UocProOrderPaymentCallbackAbilityServiceImpl
implements UocProOrderPaymentCallbackAbilityService {
    @Autowired
    private UocProOrderPaymentCallbackBusiService uocProOrderPaymentCallbackBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private UocPebPreOrderSubmitBsuiService uocPebPreOrderSubmitBsuiService;

    @PostMapping(value={"dealOrderPaymentCallback"})
    public UocProOrderPaymentCallbackAbilityRspBo dealOrderPaymentCallback(@RequestBody UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UocProOrderPaymentCallbackAbilityRspBo rspBo = this.uocProOrderPaymentCallbackBusiService.dealOrderPaymentCallback(reqBo);
        if (null != rspBo.getIsRunPay() && rspBo.getIsRunPay().booleanValue()) {
            if ("2".equals(rspBo.getOrderSource())) {
                UocPebPreOrderSubmitReqBO submitReqBO = new UocPebPreOrderSubmitReqBO();
                submitReqBO.setOrderId(reqBo.getOrderId());
                submitReqBO.setSaleVoucherId(rspBo.getSaleVoucherId());
                UocPebPreOrderSubmitRspBO submit = this.uocPebPreOrderSubmitBsuiService.submit(submitReqBO);
                this.syncSale(rspBo, reqBo);
                if (!"0000".equals(submit.getRespCode())) {
                    throw new UocProBusinessException("104044", "\u7535\u5546\u8ba2\u5355\u5931\u8d25" + submit.getRespDesc());
                }
            }
            this.syncSale(rspBo, reqBo);
        } else if (null != rspBo.getSaleVoucherId()) {
            this.syncSale(rspBo, reqBo);
        }
        return rspBo;
    }

    private void validateArgs(UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getIsOrderCallback() || !reqBo.getIsOrderCallback().booleanValue()) {
            if (ObjectUtil.isEmpty((Object)reqBo.getObjectId())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[objectId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getFscShouldPayId())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[fscShouldPayId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getShouldPayMoney())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getShouldPayMoney().compareTo(BigDecimal.ZERO) <= 0) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[shouldPayMoney]\u5c5e\u6027\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPayMod())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[payMod]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPayResult())) {
                throw new UocProBusinessException("104044", "\u5165\u53c2\u5bf9\u8c61[payResult]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void syncSale(UocProOrderPaymentCallbackAbilityRspBo rspBo, UocProOrderPaymentCallbackAbilityReqBo reqBo) {
        UocOrdIdxSyncReqBO uocOrdSaleIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdSaleIdxSyncReqBO.setObjId(rspBo.getSaleVoucherId());
        uocOrdSaleIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        uocOrdSaleIdxSyncReqBO.setOrderId(reqBo.getOrderId());
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdSaleIdxSyncReqBO)));
    }
}

