/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfCancelOrderAbilityService;
import com.tydic.uoc.busibase.busi.bo.CancelOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.CancelOrderRspBO;
import com.tydic.uoc.common.atom.api.UocPebEBCancelOrderAtomService;
import com.tydic.uoc.common.atom.bo.AtomUocPebCommCallIntfRspBO;
import com.tydic.uoc.common.atom.bo.UnicallInterfaceDefBO;
import com.tydic.uoc.common.atom.bo.UocPebCommCallIntfReqAtomBO;
import com.tydic.uoc.common.atom.impl.InterfaceLogBase;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdQueryIndexPO;
import com.tydic.uoc.po.OrdStakeholderPO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uocPebEBCancelOrderAtomService")
public class UocPebEBCancelOrderAtomServiceImpl
extends InterfaceLogBase
implements UocPebEBCancelOrderAtomService {
    public static final Integer IS_ALLOW_EXCEPTION_YES = 1;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;
    @Autowired
    private PebIntfCancelOrderAbilityService pebIntfCancelOrderAbilityService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;

    @Override
    public AtomUocPebCommCallIntfRspBO dealEBCancelOrder(UocPebCommCallIntfReqAtomBO atomReqBO) {
        AtomUocPebCommCallIntfRspBO rsp = new AtomUocPebCommCallIntfRspBO();
        this.validateParam(atomReqBO);
        String reqContentJson = atomReqBO.getReqContentJson();
        CancelOrderReqBO cancelOrderReqBO = StringUtils.isBlank((CharSequence)reqContentJson) ? this.initSubmitOrderReqBOWithOutInParm(atomReqBO) : (CancelOrderReqBO)JSONObject.parseObject((String)reqContentJson, CancelOrderReqBO.class);
        if (cancelOrderReqBO == null) {
            if (atomReqBO.getInterfaceDef().getIsAllowException().intValue() == IS_ALLOW_EXCEPTION_YES.intValue()) {
                rsp.setRespCode("101056");
                rsp.setRespDesc("\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a\u8bf7\u68c0\u67e5!");
                return rsp;
            }
            throw new UocProBusinessException("101056", "\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a\u8bf7\u68c0\u67e5!");
        }
        this.callIntfLogBegin(atomReqBO, cancelOrderReqBO);
        if (OrderPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(cancelOrderReqBO.toString())) {
            String orderId = cancelOrderReqBO.getOrderId();
            cancelOrderReqBO.setJdOrderId(orderId);
            cancelOrderReqBO.setOrderId(null);
        }
        OrdExtMapPO mapPO = new OrdExtMapPO();
        mapPO.setOrderId(atomReqBO.getOrderId());
        mapPO.setFieldCode("jdOrgId");
        mapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        mapPO = this.ordExtMapMapper.getModelBy(mapPO);
        if (mapPO != null) {
            cancelOrderReqBO.setOrgId(mapPO.getFieldValue());
        }
        CancelOrderRspBO cancelOrderRspBO = this.pebIntfCancelOrderAbilityService.cancelOrder(cancelOrderReqBO);
        this.insertCallIntfLog(cancelOrderRspBO.getRespCode(), cancelOrderRspBO);
        if (!"0000".equals(cancelOrderRspBO.getRespCode())) {
            if (atomReqBO.getInterfaceDef().getIsAllowException().intValue() == IS_ALLOW_EXCEPTION_YES.intValue()) {
                rsp.setRespCode(cancelOrderRspBO.getRespCode());
                rsp.setRespDesc(cancelOrderRspBO.getRespDesc());
                rsp.setCallResult(String.valueOf(cancelOrderRspBO.getRespDesc()));
                return rsp;
            }
            throw new UocProBusinessException("101056", "\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + cancelOrderRspBO.getRespDesc());
        }
        rsp.setRespDesc("\u8c03\u7528\u4eac\u4e1c\u53d6\u6d88\u672a\u786e\u8ba4\u8ba2\u5355\u6210\u529f\uff01");
        rsp.setRespCode("0000");
        rsp.setCallResult(String.valueOf(cancelOrderRspBO.getResult()));
        return rsp;
    }

    private CancelOrderReqBO initSubmitOrderReqBOWithOutInParm(UocPebCommCallIntfReqAtomBO atomReqBO) {
        CancelOrderReqBO cancelOrderReqBO = new CancelOrderReqBO();
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(atomReqBO.getOrderId().longValue());
            cancelOrderReqBO.setSupplierId(Long.valueOf(ordStakeholderPO.getSupNo()));
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u4eac\u4e1c\u53d6\u6d88\u672a\u786e\u8ba4\u8ba2\u5355BO\u5165\u53c2\u51fa\u9519");
        }
        OrdQueryIndexPO ordQueryIndexModel = new OrdQueryIndexPO();
        ordQueryIndexModel.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        ordQueryIndexModel.setOrderId(atomReqBO.getOrderId());
        OrdQueryIndexPO result = null;
        try {
            result = this.ordQueryIndexMapper.getModelBy(ordQueryIndexModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("101056", "\u67e5\u8be2\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u8868\u5931\u8d25");
        }
        if (result == null) {
            throw new UocProBusinessException("101056", "\u6ca1\u6709\u67e5\u8be2\u5230\u5185\u5916\u90e8\u8ba2\u5355\u5173\u8054\u4fe1\u606f");
        }
        if (this.isActivationTemp) {
            String outOrderNo = result.getOutOrderNo();
            if (outOrderNo != null && outOrderNo.indexOf("_") > 0) {
                cancelOrderReqBO.setOrderId(outOrderNo.substring(0, outOrderNo.lastIndexOf("_")));
            }
        } else {
            cancelOrderReqBO.setOrderId(result.getOutOrderNo());
        }
        return cancelOrderReqBO;
    }

    private void validateParam(UocPebCommCallIntfReqAtomBO atomReqBO) {
        UnicallInterfaceDefBO interfaceDef = atomReqBO.getInterfaceDef();
        if (atomReqBO == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (atomReqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (atomReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (interfaceDef == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u63a5\u53e3BO\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (interfaceDef.getInterCode() == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u63a5\u53e3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

