/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.PebExtOrdBusiOperRecordRspBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderFlowInfoQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderFlowInfoQueryRspBO;
import com.tydic.uoc.common.busi.api.PebExtOrderFlowInfoQueryBusiService;
import com.tydic.uoc.dao.OrdBusiOperRecordMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdBusiOperRecordPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PebExtOrderFlowInfoQueryBusiServiceImpl
implements PebExtOrderFlowInfoQueryBusiService {
    private final OrdBusiOperRecordMapper ordBusiOperRecordMapper;
    private final OrderMapper orderMapper;

    @Autowired
    public PebExtOrderFlowInfoQueryBusiServiceImpl(OrdBusiOperRecordMapper ordBusiOperRecordMapper, OrderMapper orderMapper) {
        this.ordBusiOperRecordMapper = ordBusiOperRecordMapper;
        this.orderMapper = orderMapper;
    }

    @Override
    public PebExtOrderFlowInfoQueryRspBO getOrderFlowInfoQuery(PebExtOrderFlowInfoQueryReqBO reqBO) {
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (null == orderPO) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a" + reqBO.getOrderId());
        }
        if (null != orderPO.getUpperOrderId() && 0L != orderPO.getUpperOrderId()) {
            PebExtOrderFlowInfoQueryRspBO rspBO = new PebExtOrderFlowInfoQueryRspBO();
            rspBO.setRespCode("0000");
            Page page = new Page();
            page.setPageNo(reqBO.getPageNo());
            page.setPageSize(reqBO.getPageSize());
            OrdBusiOperRecordPO ordBusiOperRecordModel = new OrdBusiOperRecordPO();
            ordBusiOperRecordModel.setOrderId(orderPO.getUpperOrderId());
            ordBusiOperRecordModel.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
            ArrayList<OrdBusiOperRecordPO> ordBusiOperRecordPOS = this.ordBusiOperRecordMapper.getListPage(page, ordBusiOperRecordModel);
            if (CollectionUtils.isEmpty((Collection)ordBusiOperRecordPOS) || ordBusiOperRecordPOS.size() < reqBO.getPageSize()) {
                List operRecordPOS;
                int remainingAmount = reqBO.getPageSize();
                if (null != ordBusiOperRecordPOS) {
                    remainingAmount = reqBO.getPageSize() - ordBusiOperRecordPOS.size();
                } else {
                    ordBusiOperRecordPOS = new ArrayList<OrdBusiOperRecordPO>();
                }
                OrdBusiOperRecordPO ordBusiOperRecordPO = new OrdBusiOperRecordPO();
                ordBusiOperRecordPO.setOrderId(reqBO.getOrderId());
                ordBusiOperRecordPO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
                List busiOperRecordPOS = this.ordBusiOperRecordMapper.getList(ordBusiOperRecordPO);
                int start = (reqBO.getPageNo() - 1) * reqBO.getPageSize() - page.getTotalCount() + ordBusiOperRecordPOS.size();
                int end = start + remainingAmount;
                if (end > busiOperRecordPOS.size()) {
                    end = busiOperRecordPOS.size();
                }
                if (CollectionUtils.isNotEmpty(operRecordPOS = busiOperRecordPOS.subList(start, end))) {
                    ordBusiOperRecordPOS.addAll(operRecordPOS);
                }
                page.setTotalCount(page.getTotalCount() + busiOperRecordPOS.size());
                page.setTotalPages(page.getTotalCount() % page.getPageSize() == 0 ? page.getTotalCount() / page.getPageSize() : page.getTotalCount() / page.getPageSize() + 1);
                this.buildRspBO(ordBusiOperRecordPOS, (Page<Map<String, Object>>)page, rspBO);
                return rspBO;
            }
            this.buildRspBO((List<OrdBusiOperRecordPO>)ordBusiOperRecordPOS, (Page<Map<String, Object>>)page, rspBO);
            return rspBO;
        }
        PebExtOrderFlowInfoQueryRspBO rspBO = new PebExtOrderFlowInfoQueryRspBO();
        rspBO.setRespCode("0000");
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        OrdBusiOperRecordPO ordBusiOperRecordModel = new OrdBusiOperRecordPO();
        ordBusiOperRecordModel.setOrderId(reqBO.getOrderId());
        ordBusiOperRecordModel.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        List ordBusiOperRecordPOS = this.ordBusiOperRecordMapper.getListPage(page, ordBusiOperRecordModel);
        this.buildRspBO(ordBusiOperRecordPOS, (Page<Map<String, Object>>)page, rspBO);
        return rspBO;
    }

    private void buildRspBO(List<OrdBusiOperRecordPO> ordBusiOperRecordPOS, Page<Map<String, Object>> page, PebExtOrderFlowInfoQueryRspBO rspBO) {
        if (CollectionUtils.isEmpty(ordBusiOperRecordPOS)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u7684\u6d41\u8f6c\u4fe1\u606f");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
            return;
        }
        ArrayList<PebExtOrdBusiOperRecordRspBO> operRecordRspBOS = new ArrayList<PebExtOrdBusiOperRecordRspBO>();
        for (OrdBusiOperRecordPO ordBusiOperRecordPO : ordBusiOperRecordPOS) {
            PebExtOrdBusiOperRecordRspBO pebExtOrdBusiOperRecordRspBO = new PebExtOrdBusiOperRecordRspBO();
            BeanUtils.copyProperties((Object)ordBusiOperRecordPO, (Object)pebExtOrdBusiOperRecordRspBO);
            if (null != pebExtOrdBusiOperRecordRspBO.getDealPostName() && !"".equals(pebExtOrdBusiOperRecordRspBO.getDealPostName())) {
                if (pebExtOrdBusiOperRecordRspBO.getDealPostName().contains(",")) {
                    String[] split = pebExtOrdBusiOperRecordRspBO.getDealPostName().split(",");
                    if (split.length > 0) {
                        ArrayList<String> dealPostNameList = new ArrayList<String>(split.length);
                        dealPostNameList.addAll(Arrays.asList(split));
                        pebExtOrdBusiOperRecordRspBO.setDealPostNameList(dealPostNameList);
                        pebExtOrdBusiOperRecordRspBO.setDealPostName(split[0]);
                    }
                } else {
                    pebExtOrdBusiOperRecordRspBO.setDealPostNameList(Collections.singletonList(ordBusiOperRecordPO.getDealPostName()));
                }
            }
            operRecordRspBOS.add(pebExtOrdBusiOperRecordRspBO);
        }
        rspBO.setRespDesc("\u67e5\u8be2\u5230\u5f53\u524d\u8ba2\u5355\u6d41\u8f6c\u4fe1\u606f\u6210\u529f");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(operRecordRspBOS);
    }
}

