/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.busi.api.UocCoreCreateOutOrderQueryBusiService;
import com.tydic.uoc.common.busi.bo.UocCorCreateOutOrderQueryReqBO;
import com.tydic.uoc.common.busi.bo.UocCorCreateOutOrderQueryRspBO;
import com.tydic.uoc.dao.OrdQueryIndexMapper;
import com.tydic.uoc.po.OrdQueryIndexPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocCoreCreateOutOrderQueryBusiService")
public class UocCoreCreateOutOrderQueryBusiServiceImpl
implements UocCoreCreateOutOrderQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocCoreCreateOutOrderQueryBusiServiceImpl.class);
    @Autowired
    private OrdQueryIndexMapper ordQueryIndexMapper;
    @Autowired
    private OrderGenerateIdUtil sequence;

    @Override
    public UocCorCreateOutOrderQueryRspBO createOutOrderQuery(UocCorCreateOutOrderQueryReqBO busiReqBO) {
        UocCorCreateOutOrderQueryRspBO rsp = new UocCorCreateOutOrderQueryRspBO();
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\uff1a" + busiReqBO.toString());
        this.validateParam(busiReqBO);
        try {
            OrdQueryIndexPO ordQueryIndexPO = new OrdQueryIndexPO();
            ordQueryIndexPO.setOrderId(busiReqBO.getOrderId());
            ordQueryIndexPO.setOutOrderNo(busiReqBO.getOutOrderNo());
            ordQueryIndexPO.setOrderSystem(busiReqBO.getOrderSystem());
            ordQueryIndexPO.setObjType(Integer.valueOf(busiReqBO.getObjType()));
            OrdQueryIndexPO ordQueryIndex = this.ordQueryIndexMapper.getModelBy(ordQueryIndexPO);
            if (null != ordQueryIndex) {
                if (!UocConstant.ORDER_TYPE.COR_ORDER.equals(busiReqBO.getObjType())) {
                    ordQueryIndex.setObjId(busiReqBO.getObjId());
                    int isUpdate = this.ordQueryIndexMapper.updateById(ordQueryIndex);
                    if (isUpdate < 1) {
                        rsp.setRespCode("102006");
                        rsp.setRespDesc("\u66f4\u65b0\u7d22\u5f15\u8868\u5931\u8d25\uff01");
                    } else {
                        rsp.setRespCode("0000");
                        rsp.setRespDesc("\u66f4\u65b0\u7d22\u5f15\u8868\u6210\u529f\uff01");
                    }
                } else {
                    rsp.setRespCode("0000");
                    rsp.setRespDesc("\u7d22\u5f15\u8868\u66f4\u65b0\u5931\u8d25\uff0c\u8ba2\u5355\u7c7b\u578b\u4e3a\u6838\u5fc3\u8ba2\u5355\uff0c\u65e0\u9700\u66f4\u65b0ObjId\uff01");
                }
            } else {
                if (!UocConstant.ORDER_TYPE.COR_ORDER.equals(busiReqBO.getObjType())) {
                    ordQueryIndexPO.setObjId(busiReqBO.getObjId());
                }
                ordQueryIndexPO.setId(Long.valueOf(this.sequence.nextId()));
                int isInsert = this.ordQueryIndexMapper.insert(ordQueryIndexPO);
                if (isInsert < 1) {
                    rsp.setRespCode("102006");
                    rsp.setRespDesc("\u63d2\u5165\u7d22\u5f15\u8868\u5931\u8d25");
                } else {
                    rsp.setRespCode("0000");
                    rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            log.error("\u63d2\u5165UOC_ORD_QUERY_INDEX\uff08\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u8868\uff09\u5f02\u5e38", (Throwable)e);
            rsp.setRespCode("102006");
            rsp.setRespDesc("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u5f02\u5e38");
        }
        log.info("\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1-\u51fa\u53c2\uff1a" + rsp.toString());
        return rsp;
    }

    private void validateParam(UocCorCreateOutOrderQueryReqBO busiReqBO) {
        if (busiReqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiReqBO.getOrderId() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)busiReqBO.getOutOrderNo())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OutOrderNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)busiReqBO.getOrderSystem())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OrderSystem\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiReqBO.getObjType() == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010ObjType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (busiReqBO.getObjId() == null && !UocConstant.ORDER_TYPE.COR_ORDER.equals(busiReqBO.getObjType())) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u521b\u5efa\u5916\u90e8\u8ba2\u5355\u67e5\u8be2\u7d22\u5f15\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5f53\u3010ObjType\u3011\u4e0d\u4e3a\u8ba2\u5355\u7c7b\u578b\u65f6\uff0c\u3010ObjId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

