/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.busibase.busi.api.PebIntfQryInOrderService;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderData;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderLine;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfQryInOrderRspBO;
import com.tydic.uoc.common.ability.api.PebInOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebInOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebInOrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdRhItemBO;
import com.tydic.uoc.common.ability.bo.UocOrdSaleRspBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipIReqBO;
import com.tydic.uoc.common.ability.bo.UocPebArrRegisterShipItemReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.ability.bo.UocPebSaleOrderConfirmShipReqBO;
import com.tydic.uoc.common.busi.api.PebInOrderBusiService;
import com.tydic.uoc.common.busi.bo.UocPebOrderAcceptReqBO;
import com.tydic.uoc.common.comb.api.UocPebOrderAcceptCombService;
import com.tydic.uoc.common.comb.api.UocPebSaleOrderAllConfirmCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdRhInfoMapper;
import com.tydic.uoc.dao.UocOrdRhItemMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipItemPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdRhInfoPO;
import com.tydic.uoc.po.UocOrdRhItemPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebInOrderAbilityService"})
public class PebInOrderAbilityServiceImpl
implements PebInOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebInOrderAbilityServiceImpl.class);
    @Autowired
    private PebIntfQryInOrderService pebIntfQryInOrderService;
    @Autowired
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private PebInOrderBusiService pebInOrderBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private UocOrdRhInfoMapper uocOrdRhInfoMapper;
    @Autowired
    private UocOrdRhItemMapper uocOrdRhItemMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private UocPebSaleOrderAllConfirmCombService uocPebSaleOrderAllConfirmCombService;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private UocPebOrderAcceptCombService uocPebOrderAcceptCombService;

    @PostMapping(value={"dealInOrder"})
    public PebInOrderRspBO dealInOrder(@RequestBody PebInOrderReqBO reqBO) {
        ArrayList<PebIntfQryInOrderData> data;
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        PebIntfQryInOrderReqBO orderReqBO = new PebIntfQryInOrderReqBO();
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getOrderNo())) {
            data = new ArrayList<PebIntfQryInOrderData>();
            for (String orderNo : reqBO.getOrderNo()) {
                OrdSalePO salePO = new OrdSalePO();
                salePO.setSaleVoucherNo(orderNo);
                salePO = this.ordSaleMapper.getModelBy(salePO);
                if (salePO == null) continue;
                UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
                zmInfoPO.setOrderId(salePO.getOrderId());
                zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
                PebIntfQryInOrderData orderData = new PebIntfQryInOrderData();
                orderData.setORG_ID(zmInfoPO.getBuynerErpNo());
                orderData.setPO_NUM(orderNo);
                data.add(orderData);
                orderReqBO.setP_PO_NUMS(data);
            }
        } else {
            orderReqBO.setP_DATE_F(DateUtils.dateToStrLong((Date)reqBO.getStart()));
            orderReqBO.setP_DATE_T(DateUtils.dateToStrLong((Date)reqBO.getEnd()));
            data = new ArrayList();
            PebIntfQryInOrderData orderData = new PebIntfQryInOrderData();
            orderData.setORG_ID("");
            orderData.setPO_NUM("");
            data.add(orderData);
            orderReqBO.setP_PO_NUMS(data);
        }
        PebIntfQryInOrderRspBO orderRspBO = this.pebIntfQryInOrderService.qryErpInOrder(orderReqBO);
        if (!"0000".equals(orderRspBO.getRespCode())) {
            throw new UocProBusinessException(orderRspBO.getRespCode(), "erp\u67e5\u8be2\u5165\u5e93\u5355:" + orderRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)orderRspBO.getLines())) {
            return rspBO;
        }
        for (PebIntfQryInOrderLine line : orderRspBO.getLines()) {
            UocOrdRhItemBO itemBO = new UocOrdRhItemBO();
            BeanUtils.copyProperties((Object)line, (Object)itemBO);
            PebInOrderReqBO busi = new PebInOrderReqBO();
            busi.setLine(itemBO);
            OrdSalePO salePO = new OrdSalePO();
            salePO.setSaleVoucherNo(line.getPoNum());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (salePO == null) continue;
            busi.setOrderId(salePO.getOrderId());
            busi.setSource(salePO.getOrderSource());
            PebInOrderRspBO inOrderRspBO = this.pebInOrderBusiService.dealInOrder(busi);
            if (!CollectionUtils.isNotEmpty((Collection)inOrderRspBO.getSaleRspBOS())) continue;
            for (UocOrdSaleRspBO saleRspBO : inOrderRspBO.getSaleRspBOS()) {
                UocPebOrdIdxSyncReqBO ordIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                ordIdxSyncReqBO.setObjId(saleRspBO.getSaleVoucherId());
                ordIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
                ordIdxSyncReqBO.setOrderId(saleRspBO.getOrderId());
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)ordIdxSyncReqBO)));
            }
        }
        return rspBO;
    }

    @PostMapping(value={"dealAccEstroe"})
    public PebInOrderRspBO dealAccEstroe(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        List getEstoreAcc = this.ordSaleMapper.getEstoreAcc(new OrdSalePO());
        if (CollectionUtils.isEmpty((Collection)getEstoreAcc)) {
            return rspBO;
        }
        for (OrdSalePO salePO : getEstoreAcc) {
            UocOrdRhInfoPO infoPO = new UocOrdRhInfoPO();
            infoPO.setExt1("DELIVER");
            List list = this.uocOrdRhInfoMapper.selectByCondition(infoPO);
            StringBuilder ext = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                UocOrdRhInfoPO po = (UocOrdRhInfoPO)list.get(i);
                ext.append(po.getReceiptNum());
                if (i == list.size() - 1) continue;
                ext.append(",");
            }
            UocPebSaleOrderConfirmShipReqBO shipReqBO = new UocPebSaleOrderConfirmShipReqBO();
            shipReqBO.setExt1(ext.toString());
            shipReqBO.setIsSync(Boolean.valueOf(true));
            shipReqBO.setOrderId(salePO.getOrderId());
            OrderPO orderPO = this.orderMapper.getModelById(salePO.getOrderId().longValue());
            shipReqBO.setOperId(orderPO.getCreateOperId());
            shipReqBO.setName(((UocOrdRhInfoPO)list.get(0)).getFullName());
            this.uocPebSaleOrderAllConfirmCombService.dealUocPebSaleOrderConfirm(shipReqBO);
        }
        return rspBO;
    }

    @PostMapping(value={"dealAccZone"})
    public PebInOrderRspBO dealAccZone(@RequestBody PebInOrderReqBO reqBO) {
        PebInOrderRspBO rspBO = new PebInOrderRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        UocOrdRhInfoPO uocOrdRhInfoPO = new UocOrdRhInfoPO();
        uocOrdRhInfoPO.setLastUpdateDate(new Date(System.currentTimeMillis() - 300000L));
        List rhInfoPOS = this.uocOrdRhInfoMapper.getAcc(uocOrdRhInfoPO);
        if (CollectionUtils.isEmpty((Collection)rhInfoPOS)) {
            return rspBO;
        }
        for (UocOrdRhInfoPO infoPO : rhInfoPOS) {
            UocOrdRhItemPO rhItemPO = new UocOrdRhItemPO();
            rhItemPO.setExt2(infoPO.getId().toString());
            rhItemPO.setAccStatus(Integer.valueOf(0));
            List list = this.uocOrdRhItemMapper.selectByCondition(rhItemPO);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            OrdShipItemPO shipItemPO = new OrdShipItemPO();
            shipItemPO.setOrderId(infoPO.getOrderId());
            List shipItemPOS = this.ordShipItemMapper.getAcc(shipItemPO);
            if (CollectionUtils.isEmpty((Collection)shipItemPOS)) continue;
            try {
                this.accZone(list, shipItemPOS, infoPO);
            }
            catch (Exception e) {
                log.error("\u4e13\u533a\u5165\u5e93\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\uff1a" + e);
            }
        }
        return rspBO;
    }

    private void accZone(List<UocOrdRhItemPO> list, List<OrdShipItemPO> uShips, UocOrdRhInfoPO infoPO) {
        boolean bl;
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        ArrayList<Long> updateIds = new ArrayList<Long>();
        Long zid = null;
        for (UocOrdRhItemPO uocOrdRhItemPO : list) {
            zid = Long.valueOf(uocOrdRhItemPO.getExt2());
            updateIds.add(uocOrdRhItemPO.getId());
            BigDecimal bigDecimal = (BigDecimal)map.get(uocOrdRhItemPO.getOrdItemId());
            if (bigDecimal == null) {
                map.put(uocOrdRhItemPO.getOrdItemId(), uocOrdRhItemPO.getQuantity());
                continue;
            }
            BigDecimal bigDecimal2 = bigDecimal.add(uocOrdRhItemPO.getQuantity());
            map.put(uocOrdRhItemPO.getOrdItemId(), bigDecimal2);
        }
        ArrayList<UocPebArrRegisterShipItemReqBO> uocPebArrRegisterShipItemReqBOList = new ArrayList<UocPebArrRegisterShipItemReqBO>();
        for (OrdShipItemPO ordShipItemPO : uShips) {
            UocPebArrRegisterShipItemReqBO registerShipItemReqBO;
            BigDecimal canAcc;
            BigDecimal count = (BigDecimal)map.get(ordShipItemPO.getOrdItemId());
            if (count == null || count.compareTo(BigDecimal.ZERO) == 0 || (canAcc = ordShipItemPO.getArriveCount().subtract(ordShipItemPO.getRefuseCount()).subtract(ordShipItemPO.getReturnCount()).subtract(ordShipItemPO.getAcceptanceCount())).compareTo(BigDecimal.ZERO) == 0) continue;
            if (canAcc.compareTo(count) >= 0) {
                registerShipItemReqBO = new UocPebArrRegisterShipItemReqBO();
                registerShipItemReqBO.setArriveCount(count);
                registerShipItemReqBO.setShipItemId(ordShipItemPO.getShipItemId());
                registerShipItemReqBO.setShiId(ordShipItemPO.getShipVoucherId());
                uocPebArrRegisterShipItemReqBOList.add(registerShipItemReqBO);
                map.put(ordShipItemPO.getOrdItemId(), BigDecimal.ZERO);
                continue;
            }
            registerShipItemReqBO = new UocPebArrRegisterShipItemReqBO();
            registerShipItemReqBO.setArriveCount(canAcc);
            registerShipItemReqBO.setShipItemId(ordShipItemPO.getShipItemId());
            uocPebArrRegisterShipItemReqBOList.add(registerShipItemReqBO);
            registerShipItemReqBO.setShiId(ordShipItemPO.getShipVoucherId());
            map.put(ordShipItemPO.getOrdItemId(), count.subtract(canAcc));
        }
        boolean bl2 = true;
        for (Long id : map.keySet()) {
            if (((BigDecimal)map.get(id)).compareTo(BigDecimal.ZERO) <= 0) continue;
            bl = false;
            break;
        }
        if (!bl) {
            return;
        }
        UocPebOrderAcceptReqBO uocPebOrderAcceptReqBO = new UocPebOrderAcceptReqBO();
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(infoPO.getOrderId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        uocPebOrderAcceptReqBO.setOrderId(salePO.getOrderId());
        uocPebOrderAcceptReqBO.setSaleVoucherId(salePO.getSaleVoucherId());
        uocPebOrderAcceptReqBO.setEntireFlag(PecConstant.EntireFlag.NO);
        uocPebOrderAcceptReqBO.setName(infoPO.getFullName());
        uocPebOrderAcceptReqBO.setUserId(Long.valueOf("99999999999"));
        uocPebOrderAcceptReqBO.setZid(zid);
        uocPebOrderAcceptReqBO.setUpdateId(updateIds);
        ArrayList<UocPebArrRegisterShipIReqBO> arrInspectionList = new ArrayList<UocPebArrRegisterShipIReqBO>();
        Map<Long, List<UocPebArrRegisterShipItemReqBO>> listMap = uocPebArrRegisterShipItemReqBOList.stream().collect(Collectors.groupingBy(UocPebArrRegisterShipItemReqBO::getShiId));
        for (Long shipId : listMap.keySet()) {
            UocPebArrRegisterShipIReqBO registerShipIReqBO = new UocPebArrRegisterShipIReqBO();
            registerShipIReqBO.setShipVoucherId(shipId);
            registerShipIReqBO.setUocPebArrRegisterShipItemReqBOList(listMap.get(shipId));
            arrInspectionList.add(registerShipIReqBO);
        }
        uocPebOrderAcceptReqBO.setArrInspectionList(arrInspectionList);
        uocPebOrderAcceptReqBO.setIsSync(true);
        this.uocPebOrderAcceptCombService.dealPebOrderAccept(uocPebOrderAcceptReqBO);
    }
}

