/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.uoc.base.bo.UocProRspListBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.po.DicDictionary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dicDictionaryService")
public class DicDictionaryServiceImpl
implements DicDictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DicDictionaryServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public void adddict(DicDictionaryBO dict) {
        DicDictionary dicDictionary = new DicDictionary();
        int count = this.sysDicDictionaryMapper.selectcount(dict.getCode(), dict.getPCode());
        if (count > 0) {
            throw new UocProBusinessException("ERROR", "\u7f16\u7801\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)dict, (Object)dicDictionary);
        this.sysDicDictionaryMapper.insertdicty(dicDictionary);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dict.getPCode()})) {
            this.cacheService.delete(dict.getPCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updatedict(DicDictionaryBO dict) {
        DicDictionary dicDictionary = this.sysDicDictionaryMapper.selectdictionaryByCodeAndCode(dict.getCode(), dict.getPCode());
        dicDictionary.setTitle(dict.getTitle());
        dicDictionary.setOrderId(dict.getOrderId());
        dicDictionary.setUpdateUid(dict.getUpdateUid());
        dicDictionary.setUpdateTm(dict.getUpdateTm());
        int num = this.sysDicDictionaryMapper.updatedicty(dicDictionary);
        if (num > 0 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dicDictionary.getpCode()})) {
            this.cacheService.delete(dicDictionary.getpCode());
        }
        return num;
    }

    @Override
    public DicDictionaryBO selectdict(String code) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary dictionary = this.sysDicDictionaryMapper.selectdictionary(code);
        BeanUtils.copyProperties((Object)dictionary, (Object)dicDictionaryBO);
        return dicDictionaryBO;
    }

    @Override
    public DicDictionaryBO selectdictionaryByCodeAndCode(String code, String pcode) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary dictionary = this.sysDicDictionaryMapper.selectdictionaryByCodeAndCode(code, pcode);
        if (dictionary != null) {
            BeanUtils.copyProperties((Object)dictionary, (Object)dicDictionaryBO);
        }
        return dicDictionaryBO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deletedict(String code) {
        DicDictionary dicDictionary = this.sysDicDictionaryMapper.selectByPrimaryKey(code);
        int num = this.sysDicDictionaryMapper.updateDisFlag(code);
        this.sysDicDictionaryMapper.selectByPrimaryKey(code);
        if (num > 0 && dicDictionary != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dicDictionary.getpCode()})) {
            this.cacheService.delete(dicDictionary.getpCode());
        }
        return num;
    }

    @Override
    @Transactional
    public UocProRspListBo<DicDictionaryBO> selectDictValByCode(String code) {
        UocProRspListBo rspBO = new UocProRspListBo();
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{code})) {
            throw new UocProBusinessException("100002", "\u5b57\u5178\u67e5\u8be2\uff1a\u5165\u53c2code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u5b57\u5178\u67e5\u8be2\uff1a\u5165\u53c2code\u4e0d\u80fd\u4e3a\u7a7a" + code);
        ArrayList<DicDictionaryBO> list = new ArrayList<DicDictionaryBO>();
        List dicDictionaries = this.sysDicDictionaryMapper.selectDictValByCode(code);
        DicDictionaryBO tmpDicDictionaryBO = null;
        for (DicDictionary dicDictionary : dicDictionaries) {
            tmpDicDictionaryBO = new DicDictionaryBO();
            BeanUtils.copyProperties((Object)dicDictionary, (Object)tmpDicDictionaryBO);
            list.add(tmpDicDictionaryBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setList(list);
        return rspBO;
    }

    @Override
    public Map<String, String> getValueByCode(String pCode) {
        List list = this.sysDicDictionaryMapper.selectByPCode(pCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionary dicDictionary : list) {
            map.put(dicDictionary.getCode(), dicDictionary.getTitle());
        }
        return map;
    }

    @Override
    public DicDictionaryBO getCodeByVal(String queryStr, String pCode) {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        DicDictionary codeByVal = this.sysDicDictionaryMapper.getCodeByVal(queryStr, pCode);
        if (codeByVal != null) {
            BeanUtils.copyProperties((Object)codeByVal, (Object)dicDictionaryBO);
        }
        return dicDictionaryBO;
    }
}

