/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.busi.api.UocEsQryAfsListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsListRspBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsListSingleBO;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="esQryAfsListBusiService")
public class UocEsQryAfsListBusiServiceImpl
implements UocEsQryAfsListBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UocEsQryAfsListBusiServiceImpl.class);
    private UocEsConfig uocEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;
    private UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryAfsListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryAfsListRspBO qryAfsList(UocEsQryAfsListReqBO uocEsQryAfsListReqBO) {
        UocEsQryAfsListRspBO rspBO = new UocEsQryAfsListRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryAfsEsSql(uocEsQryAfsListReqBO);
        LOGGER.debug("ES\u67e5\u8be2\u552e\u540e\u5355\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.uocEsConfig.getAfsIndexName() + "/" + this.uocEsConfig.getAfsIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getAfsIndexName());
                if (!index) {
                    LOGGER.error("\u81ea\u52a8\u521b\u5efa\u552e\u540e\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u552e\u540e\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    LOGGER.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("102038");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u552e\u540e\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            LOGGER.error("ioException", (Throwable)e);
            rspBO.setRespCode("102038");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u552e\u540e\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u552e\u540e\u5355result---->" + result);
        if (null != uocEsQryAfsListReqBO.getIsQueryTab() && uocEsQryAfsListReqBO.getIsQueryTab().booleanValue()) {
            this.resovelRetrunCounts(result, rspBO);
        } else {
            rspBO = this.resovelRetrunData(result, rspBO, uocEsQryAfsListReqBO.getPageSize(), uocEsQryAfsListReqBO.getPageNo());
        }
        return rspBO;
    }

    private UocEsQryAfsListRspBO resovelRetrunData(String result, UocEsQryAfsListRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u552e\u540e\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<UocEsQryAfsListSingleBO> afterSalesDetailsListQueryBOS = new ArrayList<UocEsQryAfsListSingleBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            UocEsQryAfsListSingleBO esQryAfsListSingleBO = (UocEsQryAfsListSingleBO)JSON.toJavaObject((JSON)objJson, UocEsQryAfsListSingleBO.class);
            afterSalesDetailsListQueryBOS.add(esQryAfsListSingleBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u552e\u540e\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(afterSalesDetailsListQueryBOS);
        return rspBO;
    }

    public void resovelRetrunCounts(String result, UocEsQryAfsListRspBO rspBO) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<Integer, Integer> tabCountsMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getInteger("key"), bucketsObj.getInteger("doc_count"));
        }
        rspBO.setTabCountsMap(tabCountsMap);
    }
}

