/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.uac.util.GenerateIdUtil;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtTaskCreateOrderNotifyService;
import com.tydic.uoc.common.ability.bo.PebExtTaskCreateOrderNotifyReqBO;
import com.tydic.uoc.common.ability.bo.PebExtTaskCreateOrderNotifyRspBO;
import com.tydic.uoc.common.busi.api.UocSendMessageBusiService;
import com.tydic.uoc.common.busi.bo.UocOrdNotifyConfBO;
import com.tydic.uoc.common.busi.bo.UocSendMessageReqBO;
import com.tydic.uoc.dao.OrdConfNotifyMapper;
import com.tydic.uoc.dao.OrdRemindLogMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdConfNotifyPO;
import com.tydic.uoc.po.OrdRemindLogPO;
import com.tydic.uoc.po.OrdSalePO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtTaskCreateOrderNotifyService"})
public class PebExtTaskCreateOrderNotifyServiceImpl
implements PebExtTaskCreateOrderNotifyService {
    private static final Logger log = LoggerFactory.getLogger(PebExtTaskCreateOrderNotifyServiceImpl.class);
    @Autowired
    private UocSendMessageBusiService uocSendMessageBusiService;
    @Autowired
    private OrdConfNotifyMapper ordConfNotifyMapper;
    @Autowired
    private OrdRemindLogMapper ordRemindLogMapper;
    @Autowired
    private GenerateIdUtil idUtil;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${SEND_DAY:10}")
    private Integer day;

    @PostMapping(value={"dealCreateOrderNotifyByThree"})
    public PebExtTaskCreateOrderNotifyRspBO dealCreateOrderNotifyByThree(@RequestBody PebExtTaskCreateOrderNotifyReqBO reqBO) {
        PebExtTaskCreateOrderNotifyRspBO rspBO = new PebExtTaskCreateOrderNotifyRspBO();
        this.validateArg(reqBO);
        List<OrdConfNotifyPO> ordConfNotifyPOS = this.doGetConfigs();
        if (CollectionUtils.isNotEmpty(ordConfNotifyPOS)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(5, -this.day.intValue());
            Date startCreateTime = calendar.getTime();
            ordConfNotifyPOS.stream().collect(Collectors.groupingBy(OrdConfNotifyPO::getSaleState)).forEach((getSaleState, notifyPOList) -> {
                if (getSaleState.equals(UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER)) {
                    this.createOrderSendMessage((List<OrdConfNotifyPO>)notifyPOList, startCreateTime);
                } else if (getSaleState.equals(UocConstant.SALE_ORDER_STATUS.ZONE_AUDIT)) {
                    this.approveOrderSendMessage((List<OrdConfNotifyPO>)notifyPOList, startCreateTime);
                } else if (getSaleState.equals(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP)) {
                    this.approveOrderSendMessage((List<OrdConfNotifyPO>)notifyPOList, startCreateTime);
                } else if (getSaleState.equals(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED)) {
                    this.shipOrderSendMessage((List<OrdConfNotifyPO>)notifyPOList, startCreateTime);
                }
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Page<OrdSalePO> setSelectPageSize(int i) {
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(i);
        return page;
    }

    private void shipOrderSendMessage(List<OrdConfNotifyPO> notifyPOList, Date startCreateTime) {
        notifyPOList.forEach(notify -> {
            Date beforeTime = this.getBeforeTime((OrdConfNotifyPO)notify);
            Page<OrdSalePO> page = this.setSelectPageSize(10);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setSaleState(notify.getSaleState());
            ordSalePO.setOrderSource(String.valueOf(notify.getOrderType()));
            ordSalePO.setCreateTime(beforeTime);
            ordSalePO.setEstimateArrivalTime(startCreateTime);
            try {
                List shipList = this.ordSaleMapper.getShipListByState(ordSalePO, notify.getId(), page);
                if (CollectionUtils.isNotEmpty((Collection)shipList)) {
                    shipList.stream().sorted(Comparator.comparing(OrdSalePO::getEstimateArrivalTime).reversed()).collect(Collectors.toList()).forEach(ordSale -> {
                        ordSale.setCreateTime(ordSale.getEstimateArrivalTime());
                        this.doSendMessage((OrdConfNotifyPO)notify, (OrdSalePO)ordSale);
                    });
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u53d1\u8d27\u4e2d\u8ba2\u5355\u5217\u8868\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        });
    }

    private void approveOrderSendMessage(List<OrdConfNotifyPO> notifyPOList, Date startCreateTime) {
        notifyPOList.forEach(notify -> {
            Date beforeTime = this.getBeforeTime((OrdConfNotifyPO)notify);
            Page<OrdSalePO> page = this.setSelectPageSize(20);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setSaleState(notify.getSaleState());
            ordSalePO.setOrderSource(String.valueOf(notify.getOrderType()));
            ordSalePO.setCreateTime(beforeTime);
            ordSalePO.setEstimateArrivalTime(startCreateTime);
            try {
                List ordSaleList = this.ordSaleMapper.getApprovalOrderListByState(ordSalePO, notify.getId(), page);
                if (CollectionUtils.isNotEmpty((Collection)ordSaleList)) {
                    ordSaleList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrdSalePO>(Comparator.comparing(OrdSalePO::getOrderId))), ArrayList::new)).parallelStream().sorted(Comparator.comparing(OrdSalePO::getCreateTime).reversed()).collect(Collectors.toList()).forEach(orderBO -> this.doSendMessage((OrdConfNotifyPO)notify, (OrdSalePO)orderBO));
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u5ba1\u6279\u5355\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        });
    }

    private Date getBeforeTime(OrdConfNotifyPO notify) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -notify.getDealTime().intValue());
        return calendar.getTime();
    }

    private void createOrderSendMessage(List<OrdConfNotifyPO> notifyPOList, Date startCreateTime) {
        notifyPOList.forEach(notify -> {
            Date endCreateTime = this.getBeforeTime((OrdConfNotifyPO)notify);
            Page<OrdSalePO> page = this.setSelectPageSize(10);
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setSaleState(notify.getSaleState());
            ordSalePO.setOrderSource(String.valueOf(notify.getOrderType()));
            ordSalePO.setCreateTime(endCreateTime);
            ordSalePO.setEstimateArrivalTime(startCreateTime);
            try {
                List listByState = this.ordSaleMapper.getOrderListByState(ordSalePO, notify.getId(), page);
                if (CollectionUtils.isNotEmpty((Collection)listByState)) {
                    listByState.stream().sorted(Comparator.comparing(OrdSalePO::getCreateTime).reversed()).collect(Collectors.toList()).forEach(orderBO -> this.doSendMessage((OrdConfNotifyPO)notify, (OrdSalePO)orderBO));
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendMessage(OrdConfNotifyPO notify, OrdSalePO orderBO) {
        try {
            UocSendMessageReqBO uocSendMessageReqBO = new UocSendMessageReqBO();
            uocSendMessageReqBO.setCheck(false);
            UocOrdNotifyConfBO ordNotifyConf = new UocOrdNotifyConfBO();
            BeanUtils.copyProperties((Object)notify, (Object)ordNotifyConf);
            uocSendMessageReqBO.setOrdNotifyConf(ordNotifyConf);
            uocSendMessageReqBO.setSaleVoucherNo(orderBO.getSaleVoucherNo());
            if (StringUtils.isNotBlank((CharSequence)orderBO.getCreateOperId())) {
                uocSendMessageReqBO.setUserId(Long.valueOf(orderBO.getCreateOperId()));
            }
            if (null != orderBO.getCreateTime()) {
                uocSendMessageReqBO.setPushTime(DateUtil.formatDate((Date)orderBO.getCreateTime()));
            } else {
                uocSendMessageReqBO.setPushTime(DateUtil.formatDate((Date)new Date()));
            }
            this.uocSendMessageBusiService.dealSendNotifyMessage(uocSendMessageReqBO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.dealAddLog(orderBO.getOrderId(), notify);
        }
    }

    private void validateArg(PebExtTaskCreateOrderNotifyReqBO reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100002", "\u8ba2\u5355\u53d1\u9001\u901a\u77e5\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<OrdConfNotifyPO> doGetConfigs() {
        OrdConfNotifyPO ordConfNotifyPO = new OrdConfNotifyPO();
        ordConfNotifyPO.setNotifyType(PebExtConstant.NOTIFY_TYPE.ORDER_WARNING);
        ordConfNotifyPO.setState(Integer.valueOf(1));
        try {
            Page<OrdSalePO> page = this.setSelectPageSize(30);
            List<OrdConfNotifyPO> ordConfNotifyPOS = this.ordConfNotifyMapper.queryAll(ordConfNotifyPO, page);
            log.info("\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)ordConfNotifyPOS));
            if (CollectionUtils.isEmpty((Collection)ordConfNotifyPOS)) {
                log.info("\u672a\u67e5\u8be2\u5230\u901a\u77e5\u914d\u7f6e\u4fe1\u606f");
            }
            ordConfNotifyPOS = ordConfNotifyPOS.stream().sorted(Comparator.comparing(OrdConfNotifyPO::getCreateTime)).collect(Collectors.toList());
            return ordConfNotifyPOS;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u901a\u77e5\u914d\u7f6e\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return new ArrayList<OrdConfNotifyPO>();
        }
    }

    private void dealAddLog(Long orderId, OrdConfNotifyPO ordConfNotify) {
        OrdRemindLogPO ordRemindLogPO = new OrdRemindLogPO();
        ordRemindLogPO.setId(Long.valueOf(this.idUtil.nextId()));
        ordRemindLogPO.setReceiveRole(ordConfNotify.getReceiveRole());
        ordRemindLogPO.setSendType(ordConfNotify.getNotifyType());
        ordRemindLogPO.setTemplateId(String.valueOf(ordConfNotify.getId()));
        ordRemindLogPO.setStatus(String.valueOf(ordConfNotify.getOrderType()));
        ordRemindLogPO.setMsgParam(ordConfNotify.getContent());
        ordRemindLogPO.setOrderId(orderId);
        ordRemindLogPO.setCreateTime(new Date());
        try {
            int result = this.ordRemindLogMapper.insert(ordRemindLogPO);
            if (result < 1) {
                log.debug("\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.debug("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38\uff0c\u5f02\u5e38\u63cf\u8ff0\uff1a" + e.getMessage());
        }
    }
}

