/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdPurchaseItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdPurchaseItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdPurchaseRspBO;
import com.tydic.uoc.common.ability.bo.UocPurchaseSingleDetailsQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocPurchaseSingleDetailsQueryRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.api.UocCorePurchaseSingleDetailsQueryAtomService;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.common.atom.bo.UocCorePurchaseSingleDetailsQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCorePurchaseSingleDetailsQueryRspBO;
import com.tydic.uoc.common.busi.api.UocPurchaseSingleDetailsQueryBusiService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPurchaseSingleDetailsQueryBusiService")
public class UocPurchaseSingleDetailsQueryBusiServiceImpl
implements UocPurchaseSingleDetailsQueryBusiService {
    @Autowired
    private UocCorePurchaseSingleDetailsQueryAtomService uocCorePurchaseSingleDetailsQueryAtomService;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    @Override
    public UocPurchaseSingleDetailsQueryRspBO getPurchaseSingleDetailsQuery(UocPurchaseSingleDetailsQueryReqBO reqBO) {
        UocPurchaseSingleDetailsQueryRspBO rspBO = new UocPurchaseSingleDetailsQueryRspBO();
        this.validateParams(reqBO);
        UocCorePurchaseSingleDetailsQueryReqBO atomReqBO = new UocCorePurchaseSingleDetailsQueryReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        atomReqBO.setPurchaseVoucherId(reqBO.getPurchaseVoucherId());
        UocCorePurchaseSingleDetailsQueryRspBO atomRspBO = this.uocCorePurchaseSingleDetailsQueryAtomService.getPurchaseSingleDetailsQuery(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            rspBO.setRespCode(atomRspBO.getRespCode());
            rspBO.setRespDesc(atomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO = this.buildAtomRspBO(atomRspBO);
        if (null != rspBO.getOrdPurchaseRspBO()) {
            this.transOrdPurchase(rspBO.getOrdPurchaseRspBO());
        }
        return rspBO;
    }

    private void validateParams(UocPurchaseSingleDetailsQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
        if (null == reqBO.getPurchaseVoucherId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getPurchaseVoucherId()) {
            throw new UocProBusinessException("100001", "\u7edf\u4e00\u91c7\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u5355ID\u3010purchaseVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private UocPurchaseSingleDetailsQueryRspBO buildAtomRspBO(UocCorePurchaseSingleDetailsQueryRspBO atomRspBO) {
        List<Integer> purchaseStateList = Arrays.asList(1100, 2127, 2109, 2128, 2110, 2111, 2112, 2113);
        UocPurchaseSingleDetailsQueryRspBO rspBO = new UocPurchaseSingleDetailsQueryRspBO();
        BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)rspBO);
        if (null != atomRspBO.getOrdPurchaseRspBO()) {
            UocOrdPurchaseRspBO ordPurchaseRspBO = new UocOrdPurchaseRspBO();
            BeanUtils.copyProperties((Object)atomRspBO.getOrdPurchaseRspBO(), (Object)ordPurchaseRspBO);
            rspBO.setOrdPurchaseRspBO(ordPurchaseRspBO);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getOrdPurchaseItemRspBOList())) {
            ArrayList<UocOrdPurchaseItemRspBO> ordPurchaseItemRspBOList = new ArrayList<UocOrdPurchaseItemRspBO>();
            for (OrdPurchaseItemRspBO ordPurchaseItemRspBO : atomRspBO.getOrdPurchaseItemRspBOList()) {
                UocOrdPurchaseItemRspBO uocOrdPurchaseItemRspBO = new UocOrdPurchaseItemRspBO();
                BeanUtils.copyProperties((Object)ordPurchaseItemRspBO, (Object)uocOrdPurchaseItemRspBO);
                if (purchaseStateList.contains(rspBO.getOrdPurchaseRspBO().getPurchaseState())) {
                    uocOrdPurchaseItemRspBO.setArrivalTime("\u81ea\u8ba2\u5355\u751f\u6548\u8d77" + ordPurchaseItemRspBO.getArrivalTime() + "\u65e5\u5185\u4ea4\u8d27");
                }
                uocOrdPurchaseItemRspBO.setComparisonGoodsNo(ordPurchaseItemRspBO.getRecvAddr());
                ordPurchaseItemRspBOList.add(uocOrdPurchaseItemRspBO);
            }
            rspBO.setOrdPurchaseItemRspBOList(ordPurchaseItemRspBOList);
        }
        if (CollectionUtils.isNotEmpty(atomRspBO.getPurchaseAccessoryList())) {
            ArrayList<UocOrdAccessoryRspBO> purchaseOrdAccessoryRspBOList = new ArrayList<UocOrdAccessoryRspBO>();
            for (OrdAccessoryRspBO ordAccessoryRspBO : atomRspBO.getPurchaseAccessoryList()) {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = new UocOrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)ordAccessoryRspBO, (Object)uocOrdAccessoryRspBO);
                purchaseOrdAccessoryRspBOList.add(uocOrdAccessoryRspBO);
            }
            rspBO.setPurchaseAccessoryList(purchaseOrdAccessoryRspBOList);
        }
        return rspBO;
    }

    private void transOrdPurchase(UocOrdPurchaseRspBO ordPurchaseRspBO) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordPurchaseRspBO.getOrderLevel() + "");
        dictReqBO.setPcode("ORDER_LEVEL");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setOrderLevelStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getOrderSource());
        dictReqBO.setPcode("ORDER_SOURCE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setOrderSourceStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getOrderMethod() + "");
        dictReqBO.setPcode("ORDER_METHOD");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setOrderMethodStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getPurchaseType() + "");
        dictReqBO.setPcode("PURCHASE_TYPE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setPurchaseTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getSaleState() + "");
        dictReqBO.setPcode("SALE_ORDER_STATUS");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getPurchaseState() + "");
        dictReqBO.setPcode("PURCHASE_ORDER_STATUS");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setPurchaseStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getPurchaseState() + "");
        dictReqBO.setPcode("PURCHASE_ORDER_STATUS_ADMIN");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setPurchaseStateAdminStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        dictReqBO.setCode(ordPurchaseRspBO.getPurchaseState() + "");
        dictReqBO.setPcode("PURCHASE_ORDER_STATUS_DESC");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            ordPurchaseRspBO.setPurchaseStateDesc(dictRspBO.getDicDictionarys().getDescrip());
        }
    }
}

