/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.common.ability.api.PebExtPrintShipAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtPrintShipAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintShipAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipItemPrintRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipPrintRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipPrintQueryRspBO;
import com.tydic.uoc.common.busi.api.UocShipDetailsListQueryBusiService;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPrintShipAbilityService"})
public class PebExtPrintShipAbilityServiceImpl
implements PebExtPrintShipAbilityService {
    @Autowired
    private UocShipDetailsListQueryBusiService uocShipDetailsListQueryBusiService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @PostMapping(value={"dealPrintShip"})
    public PebExtPrintShipAbilityRspBO dealPrintShip(@RequestBody PebExtPrintShipAbilityReqBO reqBO) {
        this.validateParams(reqBO);
        PebExtPrintShipAbilityRspBO rspBO = new PebExtPrintShipAbilityRspBO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null == ordSale) {
            throw new UocProBusinessException("100001", "\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        UocShipDetailsListQueryReqBO busiReqBO = new UocShipDetailsListQueryReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        UocShipDetailsListQueryRspBO shipDetailsQuery = this.uocShipDetailsListQueryBusiService.getShipDetailsQuery(busiReqBO);
        BeanUtils.copyProperties((Object)shipDetailsQuery, (Object)rspBO);
        if (!"0000".equals(shipDetailsQuery.getRespCode())) {
            return rspBO;
        }
        List shipDetailsQueryRspBOList = shipDetailsQuery.getShipDetailsQueryRspBOList();
        if (!CollectionUtils.isEmpty((Collection)shipDetailsQueryRspBOList)) {
            ArrayList<UocShipPrintQueryRspBO> uocShipPrintQueryRspBOList = new ArrayList<UocShipPrintQueryRspBO>(shipDetailsQueryRspBOList.size());
            for (UocShipDetailsQueryRspBO uscShipDetailBo : shipDetailsQueryRspBOList) {
                UocShipPrintQueryRspBO uocShipPrintQueryRspBO = new UocShipPrintQueryRspBO();
                UocOrdShipRspBO ordShipRspBO = uscShipDetailBo.getOrdShipRspBO();
                UocOrdShipPrintRspBO uocOrdShipPrintRspBO = new UocOrdShipPrintRspBO();
                BeanUtils.copyProperties((Object)ordShipRspBO, (Object)uocOrdShipPrintRspBO);
                uocOrdShipPrintRspBO.setOutOrderId(ordSale.getOutOrderId());
                uocOrdShipPrintRspBO.setSaleVoucherNo(ordSale.getSaleVoucherNo());
                uocOrdShipPrintRspBO.setPurName(ordShipRspBO.getOrdStakeholderRspBO().getPurName());
                uocOrdShipPrintRspBO.setSupName(ordShipRspBO.getOrdStakeholderRspBO().getSupName());
                uocOrdShipPrintRspBO.setShipTime(DateUtil.dateToStr((Date)ordShipRspBO.getShipTime()));
                uocShipPrintQueryRspBO.setOrdShipPrint(uocOrdShipPrintRspBO);
                List ordShipItemRspBOList = uscShipDetailBo.getOrdShipItemRspBOList();
                ArrayList<UocOrdShipItemPrintRspBO> uocOrdShipItemPrintRspBOList = new ArrayList<UocOrdShipItemPrintRspBO>(ordShipItemRspBOList.size());
                for (int i = 0; i < ordShipItemRspBOList.size(); ++i) {
                    UocOrdShipItemPrintRspBO uocOrdShipItemPrintRspBO = new UocOrdShipItemPrintRspBO();
                    BeanUtils.copyProperties(ordShipItemRspBOList.get(i), (Object)uocOrdShipItemPrintRspBO);
                    uocOrdShipItemPrintRspBO.setIndex(i + 1);
                    uocOrdShipItemPrintRspBO.setEstimateArrivalTime(DateUtil.dateToStr((Date)ordShipRspBO.getEstimateArrivalTime()));
                    uocOrdShipItemPrintRspBOList.add(uocOrdShipItemPrintRspBO);
                }
                uocShipPrintQueryRspBO.setOrdShipItemPrintList(uocOrdShipItemPrintRspBOList);
                uocShipPrintQueryRspBOList.add(uocShipPrintQueryRspBO);
            }
            rspBO.setUocOrdShipPrintList(uocShipPrintQueryRspBOList);
        } else {
            rspBO.setUocOrdShipPrintList(Collections.emptyList());
        }
        return rspBO;
    }

    private void validateParams(PebExtPrintShipAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() || 0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipVoucherId() || 0L == reqBO.getShipVoucherId()) {
            throw new UocProBusinessException("100001", "\u53d1\u8d27\u5355\u8be6\u60c5\u67e5\u8be2API\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

